/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config;

import com.google.common.collect.Sets;
import com.hazelcast.webmonitor.controller.dto.AddClusterRequestDTO;
import com.hazelcast.webmonitor.model.sql.ClusterModel;
import com.hazelcast.webmonitor.repositories.sql.ClusterRepository;
import com.hazelcast.webmonitor.utils.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DefaultClusterCreator {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultClusterCreator.class);
    @Autowired
    private ClusterRepository clusterRepository;
    @Value(value="#{environment.MC_DEFAULT_CLUSTER_MEMBERS}")
    private String members;
    @Value(value="#{environment.MC_DEFAULT_CLUSTER}")
    private String clusterName = "dev";

    @PostConstruct
    void createTargetCluster() {
        if (!StringUtil.isNullOrEmptyAfterTrim((String)this.members)) {
            List<String> membersList = Arrays.asList(this.members.split(","));
            if (this.clusterRepository.getAllClusterNames().contains(this.clusterName)) {
                this.failIfDifferentConfigs(membersList);
            } else {
                AddClusterRequestDTO addCluster = new AddClusterRequestDTO(this.clusterName, membersList, true);
                this.clusterRepository.add(addCluster);
                log.info("New cluster {} created with members {} from MC_DEFAULT_CLUSTER_MEMBERS", (Object)this.clusterName, (Object)this.members);
            }
        }
    }

    private void failIfDifferentConfigs(List<String> members) {
        HashSet<String> membersSet = new HashSet<String>(members);
        ClusterModel existingCluster = this.clusterRepository.getCluster(this.clusterName);
        HashSet<String> existingMembers = new HashSet<String>(Arrays.asList(existingCluster.getMemberAddresses()));
        if (!Sets.symmetricDifference(membersSet, existingMembers).isEmpty()) {
            String errorMessage = String.format("Cluster %s exists with members %s, but MC_DEFAULT_CLUSTER_MEMBERS is %s", this.clusterName, String.join((CharSequence)",", existingMembers), String.join((CharSequence)",", membersSet));
            log.error(errorMessage);
            throw new Error(errorMessage);
        }
    }

    @ConstructorProperties(value={"clusterRepository", "members", "clusterName"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DefaultClusterCreator(ClusterRepository clusterRepository, String members, String clusterName) {
        this.clusterRepository = clusterRepository;
        this.members = members;
        this.clusterName = clusterName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DefaultClusterCreator() {
    }
}

