/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config;

import com.hazelcast.webmonitor.DiagnosticsTool;
import com.hazelcast.webmonitor.config.properties.JMXConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.MetricsConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.PrometheusExporterConfigurationProperties;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.ClusteredJetStatsAggregator;
import com.hazelcast.webmonitor.service.ClusteredJetStatsProvider;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import com.hazelcast.webmonitor.service.HomeDirectoryProviderImpl;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.jet.JetMetricsService;
import com.hazelcast.webmonitor.service.jet.JetService;
import com.hazelcast.webmonitor.service.metrics.MetricsConsumer;
import com.hazelcast.webmonitor.service.metrics.MetricsService;
import com.hazelcast.webmonitor.service.metrics.MetricsTraceLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAspectJAutoProxy
public class AppConfig {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppConfig.class);
    private static final int ASYNC_EXECUTOR_CORE_POOL_SIZE = 2;
    private static final int ASYNC_EXECUTOR_MAX_POOL_SIZE = 30;
    private static final int ASYNC_EXECUTOR_QUEUE_CAPACITY = 100;
    private static final String ASYNC_EXECUTOR_THREAD_NAME_PREFIX = "AsyncExecutor-";
    private static final Logger EVENT_LOGGER = LoggerFactory.getLogger((String)"EventMulticaster");
    public static final String INTERNAL_MC_OBJECTS_PREFIX = "__mc.";

    @Bean
    public ThreadPoolTaskExecutor threadPoolTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(2);
        executor.setMaxPoolSize(30);
        executor.setQueueCapacity(100);
        executor.setThreadNamePrefix(ASYNC_EXECUTOR_THREAD_NAME_PREFIX);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new /* Unavailable Anonymous Inner Class!! */);
        return executor;
    }

    @Bean(name={"applicationEventMulticaster"})
    public ApplicationEventMulticaster applicationEventMulticaster(BeanFactory beanFactory, ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        SimpleApplicationEventMulticaster eventMulticaster = new SimpleApplicationEventMulticaster(beanFactory);
        eventMulticaster.setTaskExecutor((Executor)threadPoolTaskExecutor);
        eventMulticaster.setErrorHandler(t -> EVENT_LOGGER.warn("An error occurred during event handling", t));
        return eventMulticaster;
    }

    @Bean
    public DiagnosticsTool diagnosticsTool(HomeDirectoryProvider homeDir, MCConfigurationProperties mcProperties, PrometheusExporterConfigurationProperties prometheusProperties, LicenseManager licenseManager) {
        if (mcProperties.getDiagnostics().isEnabled()) {
            if (!licenseManager.hasValidLicense()) {
                log.warn("Diagnostics tool is enabled, but no license is configured. The diagnostics tool will not record any metrics.");
            }
            if (!prometheusProperties.isEnabled()) {
                log.warn("Diagnostics tool is enabled, but prometheus exporter is not enabled. The diagnostics tool will not record any metrics.");
            }
            return new DiagnosticsTool(homeDir, mcProperties);
        }
        return null;
    }

    @Bean
    public ClusteredJetStatsProvider clusteredJetStatsAggregator(JetService jetService, ClusterManager clusterManager, MCConfigurationProperties mcProperties, JMXConfigurationProperties jmxProperties) {
        if (jmxProperties.isEnabled() || mcProperties.getRest().isEnabled()) {
            return new ClusteredJetStatsAggregator(jetService, clusterManager);
        }
        return ClusteredJetStatsProvider.NOOP;
    }

    @Bean
    public MetricsConsumer metricsConsumer(MetricsService metricsService, JetMetricsService jetMetricsService, ApplicationEventPublisher applicationEventPublisher, ClusterManager clusterManager, LicenseManager licenseManager, MCClientManager clientManager, MetricsConfigurationProperties metricsProperties, MetricsTraceLogger metricsTraceLogger) {
        return new MetricsConsumer(metricsService, jetMetricsService, applicationEventPublisher, clusterManager, clientManager, licenseManager, metricsProperties, metricsTraceLogger);
    }

    @Bean
    public MetricsTraceLogger metricsTraceLogger(MetricsConfigurationProperties metricsConfigurationProperties) {
        return new MetricsTraceLogger(metricsConfigurationProperties, LoggerFactory.getLogger((String)"MetricsTrace"));
    }

    @Bean
    public HomeDirectoryProvider homeDirectoryProvider(MCConfigurationProperties mcProperties) {
        return new HomeDirectoryProviderImpl(mcProperties.getHome());
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

