/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.BaseCliTask;
import com.hazelcast.webmonitor.cli.CliException;
import com.hazelcast.webmonitor.cli.LdapOptions;
import com.hazelcast.webmonitor.cli.SetupKeystoreOptions;
import com.hazelcast.webmonitor.repositories.sql.GroupedSettingsDAO;
import com.hazelcast.webmonitor.repositories.sql.SettingsDAO;
import com.hazelcast.webmonitor.security.spi.impl.SecurityConfigurationManager;
import com.hazelcast.webmonitor.security.spi.impl.SecurityProviderConfig;
import com.hazelcast.webmonitor.security.spi.impl.ldap.BuiltInKeystorePersistentLdapConfig;
import com.hazelcast.webmonitor.security.spi.impl.ldap.ExistingKeystorePersistentLdapConfig;
import com.hazelcast.webmonitor.security.spi.impl.ldap.NoKeystorePersistentLdapConfig;
import java.io.PrintWriter;
import org.jdbi.v3.core.Jdbi;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

@CommandLine.Command(description={"Configure LDAP Security Provider. No Security Provider should be already configured when using this task. If you need to overwrite security provider configuration, use 'security reset' task first.%n*Important notice* Make sure that Management Center web application is stopped (offline) before starting this task.%n"}, mixinStandardHelpOptions=true, sortOptions=false)
public class ConfigureLdapTask
extends BaseCliTask {
    @CommandLine.Mixin
    private LdapOptions ldapOptions;
    @CommandLine.Mixin
    private SetupKeystoreOptions keystoreOptions;

    ConfigureLdapTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    public void execute() {
        this.ldapOptions.validate();
        Jdbi jdbi = this.initJdbi();
        SettingsDAO settingsDAO = new SettingsDAO(jdbi);
        SecurityConfigurationManager securityManager = new SecurityConfigurationManager(settingsDAO);
        if (securityManager.getCurrentSecurityProviderName() != null) {
            throw new CliException("Security Provider is already configured. Use 'security reset' task first, if you want to set up new security provider.");
        }
        GroupedSettingsDAO groupedSettingsDAO = new GroupedSettingsDAO(jdbi, settingsDAO);
        if (this.keystoreOptions.isEnabled()) {
            this.setupWithKeystore(jdbi, groupedSettingsDAO);
        } else {
            this.setupWithoutKeystore(groupedSettingsDAO);
        }
        securityManager.setCurrentSecurityProviderName("LDAP");
        this.printf("Successfully set up LDAP security provider.%n", new Object[0]);
    }

    private void setupWithKeystore(Jdbi jdbi, GroupedSettingsDAO groupedSettingsDAO) {
        this.keystoreOptions.validate();
        if (this.keystoreOptions.isCreateKeyStore()) {
            BuiltInKeystorePersistentLdapConfig ldapConfig = new BuiltInKeystorePersistentLdapConfig(jdbi, groupedSettingsDAO, this.keystoreOptions.getKeyStorePath(), this.keystoreOptions.getKeyStorePassword());
            ldapConfig.write(this.ldapOptions.ldapConfig());
        } else {
            ExistingKeystorePersistentLdapConfig ldapConfig = new ExistingKeystorePersistentLdapConfig(jdbi, groupedSettingsDAO, this.keystoreOptions.getKeyStorePath(), this.keystoreOptions.getKeyStorePassword(), this.keystoreOptions.getKeyStoreType(), this.keystoreOptions.getKeyStoreProvider());
            ldapConfig.write(this.ldapOptions.ldapConfig());
        }
    }

    private void setupWithoutKeystore(GroupedSettingsDAO groupedSettingsDAO) {
        new NoKeystorePersistentLdapConfig(groupedSettingsDAO).write((SecurityProviderConfig)this.ldapOptions.ldapConfig());
    }
}

