/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.auditlog.impl;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.auditlog.Level;
import com.hazelcast.webmonitor.auditlog.impl.AuditableEvent;
import com.hazelcast.webmonitor.auditlog.impl.LoggingAuditLogService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingAuditLogService
implements AuditLogService {
    public static final String AUDITLOG_CATEGORY = "hazelcast.auditlog";
    private final Logger logger = LoggerFactory.getLogger((String)"hazelcast.auditlog");

    public void log(AuditableEvent event) {
        Level level = event.getLevel();
        String message = event.getMessage();
        Map parameters = event.getParameters();
        if (!this.isLoggable(level)) {
            return;
        }
        StringBuilder sb = new StringBuilder(event.getTypeId()).append(":");
        if (message != null) {
            sb.append(message);
        }
        sb.append(":");
        if (parameters != null && !parameters.isEmpty()) {
            sb.append(parameters);
        }
        this.log(level, sb.toString(), event.getCause());
    }

    private boolean isLoggable(Level level) {
        switch (1.$SwitchMap$com$hazelcast$webmonitor$auditlog$Level[level.ordinal()]) {
            case 1: {
                return this.logger.isDebugEnabled();
            }
            case 2: {
                return this.logger.isInfoEnabled();
            }
            case 3: {
                return this.logger.isWarnEnabled();
            }
            case 4: {
                return this.logger.isErrorEnabled();
            }
        }
        throw new IllegalArgumentException("Unknown Level " + level);
    }

    private void log(Level level, String message, Throwable cause) {
        switch (1.$SwitchMap$com$hazelcast$webmonitor$auditlog$Level[level.ordinal()]) {
            case 1: {
                this.logger.debug(message, cause);
                break;
            }
            case 2: {
                this.logger.info(message, cause);
                break;
            }
            case 3: {
                this.logger.warn(message, cause);
                break;
            }
            case 4: {
                this.logger.error(message, cause);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Level " + level);
            }
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LoggingAuditLogService() {
    }
}

