/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor;

import com.hazelcast.webmonitor.EnvProperty;
import com.hazelcast.webmonitor.config.properties.ADConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.BuildInfo;
import com.hazelcast.webmonitor.config.properties.JMXConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.LdapConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.MCClientConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.MetricsConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.PhoneHomeConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.PrometheusExporterConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.SecurityDictionaryConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.SqlConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.WebSocketConfigurationProperties;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Console;
import java.net.InetAddress;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.event.EventListener;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
@EnableConfigurationProperties(value={MCConfigurationProperties.class, JMXConfigurationProperties.class, ADConfigurationProperties.class, LdapConfigurationProperties.class, MCClientConfigurationProperties.class, MetricsConfigurationProperties.class, PhoneHomeConfigurationProperties.class, SecurityDictionaryConfigurationProperties.class, PrometheusExporterConfigurationProperties.class, SqlConfigurationProperties.class, WebSocketConfigurationProperties.class})
public class MCApplication {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MCApplication.class);
    public static final int ERROR_EXIT_STATUS = 100;
    @Autowired
    private MCConfigurationProperties configurationProperties;

    public static void main(String[] args) {
        MCApplication.askAndSetKeyStorePasswordIfNecessary();
        SpringApplication.run(MCApplication.class, (String[])args);
    }

    private static void askAndSetKeyStorePasswordIfNecessary() {
        if (System.getProperties().containsKey(EnvProperty.ASK_KEYSTORE_PASS.toString())) {
            String keyStorePassword = MCApplication.askKeyStorePassword();
            System.setProperty(EnvProperty.KEYSTORE_PASSWORD.toString(), keyStorePassword);
        }
    }

    private static String askKeyStorePassword() {
        Console console = MCApplication.checkAndGetConsole();
        char[] passwordArray = new char[]{};
        boolean passwordVerified = false;
        while (!passwordVerified) {
            char[] confirmPasswordArray;
            passwordArray = console.readPassword("Enter the keyStore password: ", new Object[0]);
            passwordVerified = Arrays.equals(passwordArray, confirmPasswordArray = console.readPassword("Confirm the keyStore password: ", new Object[0]));
            if (!passwordVerified) {
                console.printf("Passwords do not match!%n", new Object[0]);
                continue;
            }
            if (passwordArray != null && passwordArray.length != 0) continue;
            console.printf("No password entered!%n", new Object[0]);
            passwordVerified = false;
        }
        return new String(passwordArray);
    }

    private static Console checkAndGetConsole() {
        Console console = System.console();
        if (console == null) {
            MCApplication.exit((String)"Couldn't get Console instance", (int)1);
        }
        return console;
    }

    public static void exit(String message, int status) {
        if (status == 100) {
            log.error(message);
        } else {
            log.info(message);
        }
        System.exit(status);
    }

    @EventListener(value={ApplicationStartedEvent.class})
    public void logBuildInfo() {
        InetAddress hostAddress = this.configurationProperties.getHostAddress();
        boolean tlsEnabled = this.configurationProperties.getTls().isEnabled();
        StringBuilder url = new StringBuilder().append(tlsEnabled ? "https" : "http").append("://").append(hostAddress == null ? "localhost" : hostAddress.getHostAddress()).append(":").append(tlsEnabled ? this.configurationProperties.getHttpsPort() : this.configurationProperties.getHttpPort()).append(this.configurationProperties.getContextPath());
        log.info("Hazelcast Management Center successfully started at {}", (Object)url);
        log.info("Hazelcast Management Center {} ({} - {}), Hazelcast client version: {}, embedded Jetty version: {}", new Object[]{BuildInfo.getFullVersion(), BuildInfo.getBuildTimestamp(), BuildInfo.getRevision(), BuildInfo.getHazelcastClientVersion(), BuildInfo.getJettyVersion()});
    }
}

