/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import org.apache.hadoop.fs.store.LogExactlyOnce;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class V2Migration {
    public static final Logger SDK_V2_UPGRADE_LOG = LoggerFactory.getLogger("org.apache.hadoop.fs.s3a.SDKV2Upgrade");
    private static final LogExactlyOnce WARN_ON_DELEGATION_TOKENS = new LogExactlyOnce(SDK_V2_UPGRADE_LOG);
    private static final LogExactlyOnce WARN_ON_GET_S3_CLIENT = new LogExactlyOnce(SDK_V2_UPGRADE_LOG);
    private static final LogExactlyOnce WARN_OF_DIRECTLY_REFERENCED_CREDENTIAL_PROVIDER = new LogExactlyOnce(SDK_V2_UPGRADE_LOG);
    private static final LogExactlyOnce WARN_OF_CUSTOM_SIGNER = new LogExactlyOnce(SDK_V2_UPGRADE_LOG);
    private static final LogExactlyOnce WARN_ON_GET_OBJECT_METADATA = new LogExactlyOnce(SDK_V2_UPGRADE_LOG);

    private V2Migration() {
    }

    public static void v1ProviderReferenced(String name) {
        WARN_OF_DIRECTLY_REFERENCED_CREDENTIAL_PROVIDER.warn("Directly referencing AWS SDK V1 credential provider {}. AWS SDK V1 credential providers will be removed once S3A is upgraded to SDK V2", name);
    }

    public static void v1S3ClientRequested() {
        WARN_ON_GET_S3_CLIENT.warn("getAmazonS3ClientForTesting() will be removed as part of upgrading S3A to AWS SDK V2", new Object[0]);
    }

    public static void v1DelegationTokenCredentialProvidersUsed() {
        WARN_ON_DELEGATION_TOKENS.warn("The credential provider interface has changed in AWS SDK V2, custom credential providers used in delegation tokens binding classes will need to be updated once S3A is upgraded to SDK V2", new Object[0]);
    }

    public static void v1CustomSignerUsed() {
        WARN_OF_CUSTOM_SIGNER.warn("The signer interface has changed in AWS SDK V2, custom signers will need to be updated once S3A is upgraded to SDK V2", new Object[0]);
    }

    public static void v1GetObjectMetadataCalled() {
        WARN_ON_GET_OBJECT_METADATA.warn("getObjectMetadata() called. This operation and it's response will be changed as part of upgrading S3A to AWS SDK V2", new Object[0]);
    }
}

