/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit.files;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSDataOutputStreamBuilder;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.impl.AbstractFSBuilderImpl;
import org.apache.hadoop.fs.s3a.commit.ValidationFailure;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.util.JsonSerialization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class PersistentCommitData<T extends PersistentCommitData>
implements Serializable,
IOStatisticsSource {
    private static final Logger LOG = LoggerFactory.getLogger(PersistentCommitData.class);
    public static final int VERSION = 2;

    public abstract void validate() throws ValidationFailure;

    public abstract byte[] toBytes(JsonSerialization<T> var1) throws IOException;

    public abstract IOStatistics save(FileSystem var1, Path var2, JsonSerialization<T> var3) throws IOException;

    public static <T extends PersistentCommitData> T load(FileSystem fs, FileStatus status, JsonSerialization<T> serializer) throws IOException {
        Path path = status.getPath();
        LOG.debug("Reading commit data from file {}", (Object)path);
        PersistentCommitData result = (PersistentCommitData)serializer.load(fs, path, status);
        result.validate();
        return (T)result;
    }

    public static <T extends PersistentCommitData> IOStatistics saveFile(FileSystem fs, Path path, T instance, JsonSerialization<T> serializer, boolean performance) throws IOException {
        Object builder = ((FSDataOutputStreamBuilder)((FSDataOutputStreamBuilder)fs.createFile(path).create()).recursive()).overwrite(true);
        ((AbstractFSBuilderImpl)builder).opt("fs.s3a.create.performance", performance);
        return PersistentCommitData.saveToStream(path, instance, builder, serializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends PersistentCommitData> IOStatistics saveToStream(Path path, T instance, FSDataOutputStreamBuilder builder, JsonSerialization<T> serializer) throws IOException {
        LOG.debug("saving commit data to file {}", (Object)path);
        try (Object dataOutputStream = builder.build();){
            ((FilterOutputStream)dataOutputStream).write(serializer.toBytes(instance));
        }
        return ((FSDataOutputStream)dataOutputStream).getIOStatistics();
    }
}

