/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.audit;

import com.amazonaws.HandlerContextAware;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.audit.AWSAuditEventCallbacks;
import org.apache.hadoop.fs.s3a.audit.AuditManagerS3A;
import org.apache.hadoop.fs.s3a.audit.OperationAuditor;
import org.apache.hadoop.fs.s3a.audit.OperationAuditorOptions;
import org.apache.hadoop.fs.s3a.audit.impl.ActiveAuditManagerS3A;
import org.apache.hadoop.fs.s3a.audit.impl.LoggingAuditor;
import org.apache.hadoop.fs.s3a.audit.impl.NoopAuditManagerS3A;
import org.apache.hadoop.fs.s3a.audit.impl.S3AInternalAuditConstants;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuditIntegration {
    private static final Logger LOG = LoggerFactory.getLogger(AuditIntegration.class);

    private AuditIntegration() {
    }

    public static AuditManagerS3A createAndStartAuditManager(Configuration conf, IOStatisticsStore iostatistics) {
        AuditManagerS3A auditManager;
        if (conf.getBoolean("fs.s3a.audit.enabled", true)) {
            auditManager = new ActiveAuditManagerS3A(Objects.requireNonNull(iostatistics));
        } else {
            LOG.debug("auditing is disabled");
            auditManager = AuditIntegration.stubAuditManager();
        }
        auditManager.init(conf);
        auditManager.start();
        LOG.debug("Started Audit Manager {}", (Object)auditManager);
        return auditManager;
    }

    public static AuditManagerS3A stubAuditManager() {
        return new NoopAuditManagerS3A();
    }

    public static OperationAuditor createAndInitAuditor(Configuration conf, String key, OperationAuditorOptions options) throws IOException {
        Class<OperationAuditor> auditClassname = conf.getClass(key, LoggingAuditor.class, OperationAuditor.class);
        try {
            LOG.debug("Auditor class is {}", (Object)auditClassname);
            Constructor<OperationAuditor> constructor = auditClassname.getConstructor(new Class[0]);
            OperationAuditor instance = constructor.newInstance(new Object[0]);
            instance.init(options);
            return instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
            throw new IOException("Failed to instantiate class " + auditClassname + " defined in " + key + ": " + e, e);
        }
    }

    public static <T extends HandlerContextAware> AWSAuditEventCallbacks retrieveAttachedSpan(T request) {
        return request.getHandlerContext(S3AInternalAuditConstants.AUDIT_SPAN_HANDLER_CONTEXT);
    }

    public static <T extends HandlerContextAware> void attachSpanToRequest(T request, AWSAuditEventCallbacks span) {
        request.addHandlerContext(S3AInternalAuditConstants.AUDIT_SPAN_HANDLER_CONTEXT, (AWSAuditEventCallbacks)span);
    }
}

