/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.gzip;

import io.airlift.compress.gzip.HadoopJdkGzipInputStream;
import io.airlift.compress.gzip.HadoopJdkGzipOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DoNotPool;

public class JdkGzipCodec
implements CompressionCodec {
    @Override
    public CompressionOutputStream createOutputStream(OutputStream outputStream) throws IOException {
        return new HadoopJdkGzipOutputStream(outputStream, 8192);
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream outputStream, Compressor compressor) throws IOException {
        if (!(compressor instanceof HadoopGzipCompressor)) {
            throw new IllegalArgumentException("Compressor is not the Gzip decompressor");
        }
        return new HadoopJdkGzipOutputStream(outputStream, 8192);
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        return HadoopGzipCompressor.class;
    }

    @Override
    public Compressor createCompressor() {
        return new HadoopGzipCompressor();
    }

    @Override
    public CompressionInputStream createInputStream(InputStream inputStream) throws IOException {
        return new HadoopJdkGzipInputStream(inputStream, 8192);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream inputStream, Decompressor decompressor) throws IOException {
        if (!(decompressor instanceof HadoopGzipDecompressor)) {
            throw new IllegalArgumentException("Decompressor is not the Gzip decompressor");
        }
        return new HadoopJdkGzipInputStream(inputStream, 8192);
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        return HadoopGzipDecompressor.class;
    }

    @Override
    public Decompressor createDecompressor() {
        return new HadoopGzipDecompressor();
    }

    @Override
    public String getDefaultExtension() {
        return ".gz";
    }

    @DoNotPool
    private static class HadoopGzipDecompressor
    implements Decompressor {
        private HadoopGzipDecompressor() {
        }

        @Override
        public void setInput(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("Gzip block decompressor is not supported");
        }

        @Override
        public boolean needsInput() {
            throw new UnsupportedOperationException("Gzip block decompressor is not supported");
        }

        @Override
        public void setDictionary(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("Gzip block decompressor is not supported");
        }

        @Override
        public boolean needsDictionary() {
            throw new UnsupportedOperationException("Gzip block decompressor is not supported");
        }

        @Override
        public boolean finished() {
            throw new UnsupportedOperationException("Gzip block decompressor is not supported");
        }

        @Override
        public int decompress(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException("Gzip block decompressor is not supported");
        }

        @Override
        public int getRemaining() {
            throw new UnsupportedOperationException("Gzip block decompressor is not supported");
        }

        @Override
        public void reset() {
        }

        @Override
        public void end() {
        }
    }

    @DoNotPool
    private static class HadoopGzipCompressor
    implements Compressor {
        private HadoopGzipCompressor() {
        }

        @Override
        public void setInput(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("Gzip block compressor is not supported");
        }

        @Override
        public boolean needsInput() {
            throw new UnsupportedOperationException("Gzip block compressor is not supported");
        }

        @Override
        public void setDictionary(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("Gzip block compressor is not supported");
        }

        @Override
        public long getBytesRead() {
            throw new UnsupportedOperationException("Gzip block compressor is not supported");
        }

        @Override
        public long getBytesWritten() {
            throw new UnsupportedOperationException("Gzip block compressor is not supported");
        }

        @Override
        public void finish() {
            throw new UnsupportedOperationException("Gzip block compressor is not supported");
        }

        @Override
        public boolean finished() {
            throw new UnsupportedOperationException("Gzip block compressor is not supported");
        }

        @Override
        public int compress(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException("Gzip block compressor is not supported");
        }

        @Override
        public void reset() {
        }

        @Override
        public void end() {
        }

        @Override
        public void reinit(Configuration conf) {
        }
    }
}

