/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.validate;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.org.apache.calcite.sql.validate.AbstractNamespace;
import com.hazelcast.org.apache.calcite.sql.validate.SelectScope;
import com.hazelcast.org.apache.calcite.sql.validate.SqlModality;
import com.hazelcast.org.apache.calcite.sql.validate.SqlMonotonicity;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorImpl;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Objects;

public class SelectNamespace
extends AbstractNamespace {
    private final SqlSelect select;

    public SelectNamespace(SqlValidatorImpl validator, SqlSelect select, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.select = select;
    }

    @Override
    public @Nullable SqlNode getNode() {
        return this.select;
    }

    @Override
    public RelDataType validateImpl(RelDataType targetRowType) {
        this.validator.validateSelect(this.select, targetRowType);
        return Objects.requireNonNull(this.rowType, "rowType");
    }

    @Override
    public boolean supportsModality(SqlModality modality) {
        return this.validator.validateModality(this.select, modality, false);
    }

    @Override
    public SqlMonotonicity getMonotonicity(String columnName) {
        RelDataType rowType = this.getRowTypeSansSystemColumns();
        int field = SqlTypeUtil.findField(rowType, columnName);
        SelectScope selectScope = Objects.requireNonNull(this.validator.getRawSelectScope(this.select), () -> "rawSelectScope for " + this.select);
        SqlNode selectItem = Objects.requireNonNull(selectScope.getExpandedSelectList(), () -> "expandedSelectList for selectScope of " + this.select).get(field);
        return this.validator.getSelectScope(this.select).getMonotonicity(selectItem);
    }
}

