/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.type;

import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFamily;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeImpl;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeExplicitPrecedenceList;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeFamily;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public abstract class AbstractSqlType
extends RelDataTypeImpl
implements Cloneable,
Serializable {
    protected final SqlTypeName typeName;
    protected boolean isNullable;

    protected AbstractSqlType(SqlTypeName typeName, boolean isNullable, @Nullable List<? extends RelDataTypeField> fields) {
        super(fields);
        this.typeName = Objects.requireNonNull(typeName, "typeName");
        this.isNullable = isNullable || typeName == SqlTypeName.NULL;
    }

    @Override
    public SqlTypeName getSqlTypeName() {
        return this.typeName;
    }

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    @Override
    public RelDataTypeFamily getFamily() {
        SqlTypeFamily family = this.typeName.getFamily();
        return family != null ? family : this;
    }

    @Override
    public RelDataTypePrecedenceList getPrecedenceList() {
        RelDataTypePrecedenceList list = SqlTypeExplicitPrecedenceList.getListForType(this);
        if (list != null) {
            return list;
        }
        return super.getPrecedenceList();
    }
}

