/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.advise;

import com.hazelcast.org.apache.calcite.avatica.util.Quoting;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParser;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class SqlSimpleParser {
    private final String hintToken;
    private final SqlParser.Config parserConfig;

    @Deprecated
    public SqlSimpleParser(String hintToken) {
        this(hintToken, SqlParser.Config.DEFAULT);
    }

    public SqlSimpleParser(String hintToken, SqlParser.Config parserConfig) {
        this.hintToken = hintToken;
        this.parserConfig = parserConfig;
    }

    public String simplifySql(String sql, int cursor) {
        if (cursor >= sql.length()) {
            sql = sql + " " + this.hintToken + " ";
        } else {
            String left = sql.substring(0, cursor);
            String right = sql.substring(cursor);
            sql = left + " " + this.hintToken + " " + right;
        }
        return this.simplifySql(sql);
    }

    public String simplifySql(String sql) {
        Token token;
        Tokenizer tokenizer = new Tokenizer(sql, this.hintToken, this.parserConfig.quoting());
        ArrayList<Token> list = new ArrayList<Token>();
        while ((token = tokenizer.nextToken()) != null) {
            if (token.type == TokenType.COMMENT) continue;
            list.add(token);
        }
        ArrayList<Token> outList = new ArrayList<Token>();
        SqlSimpleParser.consumeQuery(list.listIterator(), outList);
        Query.simplifyList(outList, this.hintToken);
        StringBuilder buf = new StringBuilder();
        int k = -1;
        for (Token token2 : outList) {
            if (++k > 0) {
                buf.append(' ');
            }
            token2.unparse(buf);
        }
        return buf.toString();
    }

    private static void consumeQuery(ListIterator<Token> iter, List<Token> outList) {
        block3: while (iter.hasNext()) {
            SqlSimpleParser.consumeSelect(iter, outList);
            if (!iter.hasNext()) continue;
            Token token = iter.next();
            switch (token.type) {
                case UNION: 
                case INTERSECT: 
                case EXCEPT: 
                case MINUS: {
                    outList.add(token);
                    if (!iter.hasNext()) continue block3;
                    token = iter.next();
                    if (token.type == TokenType.ID && "ALL".equalsIgnoreCase(token.s)) {
                        outList.add(token);
                        continue block3;
                    }
                    iter.previous();
                    continue block3;
                }
            }
            iter.previous();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void consumeSelect(ListIterator<Token> iter, List<Token> outList) {
        boolean isQuery = false;
        int start = outList.size();
        ArrayList<Token> subQueryList = new ArrayList<Token>();
        block6: while (iter.hasNext()) {
            Token token = iter.next();
            subQueryList.add(token);
            switch (token.type) {
                case LPAREN: {
                    SqlSimpleParser.consumeQuery(iter, subQueryList);
                    break;
                }
                case RPAREN: {
                    if (!isQuery) break block6;
                    subQueryList.remove(subQueryList.size() - 1);
                    break block6;
                }
                case SELECT: {
                    isQuery = true;
                    break;
                }
                case UNION: 
                case INTERSECT: 
                case EXCEPT: 
                case MINUS: {
                    subQueryList.remove(subQueryList.size() - 1);
                    iter.previous();
                    break block6;
                }
            }
        }
        if (isQuery) {
            outList.subList(start, outList.size()).clear();
            outList.add(new Query(subQueryList));
            if (outList.size() < 2) return;
            if (outList.get(outList.size() - 2).type != TokenType.LPAREN) return;
            outList.add(new Token(TokenType.RPAREN));
            return;
        }
        outList.addAll(subQueryList);
    }

    static class Query
    extends Token {
        private final List<Token> tokenList;

        Query(List<Token> tokenList) {
            super(TokenType.QUERY);
            this.tokenList = new ArrayList<Token>(tokenList);
        }

        @Override
        public void unparse(StringBuilder buf) {
            int k = -1;
            for (Token token : this.tokenList) {
                if (++k > 0) {
                    buf.append(' ');
                }
                token.unparse(buf);
            }
        }

        public static void simplifyList(List<Token> list, String hintToken) {
            for (Token token : list) {
                Query query;
                if (!(token instanceof Query) || !(query = (Query)token).contains(hintToken)) continue;
                list.clear();
                list.add(query.simplify(hintToken));
                break;
            }
        }

        public Query simplify(@Nullable String hintToken) {
            TokenType clause = TokenType.SELECT;
            TokenType foundInClause = null;
            Query foundInSubQuery = null;
            TokenType majorClause = null;
            if (hintToken != null) {
                for (Token token : this.tokenList) {
                    switch (token.type) {
                        case ID: {
                            if (!hintToken.equals(token.s)) break;
                            foundInClause = clause;
                            break;
                        }
                        case SELECT: 
                        case FROM: 
                        case WHERE: 
                        case GROUP: 
                        case HAVING: 
                        case ORDER: {
                            majorClause = token.type;
                        }
                        case JOIN: 
                        case USING: 
                        case ON: {
                            clause = token.type;
                            break;
                        }
                        case COMMA: {
                            if (majorClause != TokenType.FROM) break;
                            clause = TokenType.FROM;
                            break;
                        }
                        case QUERY: {
                            if (!((Query)token).contains(hintToken)) break;
                            foundInClause = clause;
                            foundInSubQuery = (Query)token;
                            break;
                        }
                    }
                }
            } else {
                foundInClause = TokenType.QUERY;
            }
            if (foundInClause != null) {
                switch (foundInClause) {
                    case SELECT: {
                        this.purgeSelectListExcept(hintToken);
                        this.purgeWhere();
                        this.purgeOrderBy();
                        break;
                    }
                    case FROM: 
                    case JOIN: {
                        this.purgeSelect();
                        this.purgeFromExcept(hintToken);
                        this.purgeWhere();
                        this.purgeGroupByHaving();
                        this.purgeOrderBy();
                        break;
                    }
                    case USING: 
                    case ON: {
                        this.purgeSelect();
                        this.purgeWhere();
                        this.purgeOrderBy();
                        break;
                    }
                    case WHERE: {
                        this.purgeSelect();
                        this.purgeGroupByHaving();
                        this.purgeOrderBy();
                        break;
                    }
                    case GROUP: 
                    case HAVING: {
                        this.purgeSelect();
                        this.purgeWhere();
                        this.purgeOrderBy();
                        break;
                    }
                    case ORDER: {
                        this.purgeWhere();
                        break;
                    }
                    case QUERY: {
                        this.purgeWhere();
                        this.purgeGroupByHaving();
                        break;
                    }
                }
            }
            for (Token token : this.tokenList) {
                switch (token.type) {
                    case QUERY: {
                        Query query = (Query)token;
                        query.simplify(query == foundInSubQuery ? hintToken : null);
                        break;
                    }
                }
            }
            return this;
        }

        private void purgeSelectListExcept(@Nullable String hintToken) {
            List<Token> sublist = this.findClause(TokenType.SELECT);
            int parenCount = 0;
            int itemStart = 1;
            int itemEnd = -1;
            boolean found = false;
            block6: for (int i = 0; i < sublist.size(); ++i) {
                Token token = sublist.get(i);
                switch (token.type) {
                    case LPAREN: {
                        ++parenCount;
                        continue block6;
                    }
                    case RPAREN: {
                        --parenCount;
                        continue block6;
                    }
                    case COMMA: {
                        if (parenCount != 0) continue block6;
                        if (found) {
                            itemEnd = i;
                            continue block6;
                        }
                        itemStart = i + 1;
                        continue block6;
                    }
                    case ID: {
                        if (!Objects.requireNonNull(hintToken, "hintToken").equals(token.s)) continue block6;
                        found = true;
                        continue block6;
                    }
                }
            }
            if (found) {
                if (itemEnd < 0) {
                    itemEnd = sublist.size();
                }
                ArrayList<Token> selectItem = new ArrayList<Token>(sublist.subList(itemStart, itemEnd));
                Token select = sublist.get(0);
                sublist.clear();
                sublist.add(select);
                sublist.addAll(selectItem);
            }
        }

        private void purgeSelect() {
            List<Token> sublist = this.findClause(TokenType.SELECT);
            Token select = sublist.get(0);
            sublist.clear();
            sublist.add(select);
            sublist.add(new Token(TokenType.ID, "*"));
        }

        private void purgeSelectExprsKeepAliases() {
            List<Token> sublist = this.findClause(TokenType.SELECT);
            ArrayList<Token> newSelectClause = new ArrayList<Token>();
            newSelectClause.add(sublist.get(0));
            int itemStart = 1;
            for (int i = 1; i < sublist.size(); ++i) {
                Token token = sublist.get(i);
                if (i + 1 != sublist.size() && sublist.get(i + 1).type != TokenType.COMMA) continue;
                if (token.type == TokenType.ID) {
                    newSelectClause.add(new Token(TokenType.ID, "0"));
                    newSelectClause.add(new Token(TokenType.ID, "AS"));
                    newSelectClause.add(token);
                } else {
                    newSelectClause.addAll(sublist.subList(itemStart, i + 1));
                }
                itemStart = i + 2;
                if (i + 1 >= sublist.size()) continue;
                newSelectClause.add(new Token(TokenType.COMMA));
            }
            sublist.clear();
            sublist.addAll(newSelectClause);
        }

        private void purgeFromExcept(@Nullable String hintToken) {
            List<Token> sublist = this.findClause(TokenType.FROM);
            int itemStart = -1;
            int itemEnd = -1;
            int joinCount = 0;
            boolean found = false;
            block6: for (int i = 0; i < sublist.size(); ++i) {
                Token token = sublist.get(i);
                switch (token.type) {
                    case QUERY: {
                        if (!((Query)token).contains(Objects.requireNonNull(hintToken, "hintToken"))) continue block6;
                        found = true;
                        continue block6;
                    }
                    case JOIN: {
                        ++joinCount;
                    }
                    case FROM: 
                    case ON: 
                    case COMMA: {
                        if (found) {
                            itemEnd = i;
                            continue block6;
                        }
                        itemStart = i + 1;
                        continue block6;
                    }
                    case ID: {
                        if (!Objects.requireNonNull(hintToken, "hintToken").equals(token.s)) continue block6;
                        found = true;
                        continue block6;
                    }
                }
            }
            if (found && joinCount == 0) {
                if (itemEnd == -1) {
                    itemEnd = sublist.size();
                }
                ArrayList<Token> fromItem = new ArrayList<Token>(sublist.subList(itemStart, itemEnd));
                Token from = sublist.get(0);
                sublist.clear();
                sublist.add(from);
                sublist.addAll(fromItem);
            }
            if (sublist.get(sublist.size() - 1).type == TokenType.ON) {
                sublist.add(new Token(TokenType.ID, "TRUE"));
            }
        }

        private void purgeWhere() {
            List<Token> sublist = this.findClauseOrNull(TokenType.WHERE);
            if (sublist != null) {
                sublist.clear();
            }
        }

        private void purgeGroupByHaving() {
            List<Token> sublist = this.findClauseOrNull(TokenType.GROUP);
            if (sublist != null) {
                sublist.clear();
            }
            if ((sublist = this.findClauseOrNull(TokenType.HAVING)) != null) {
                sublist.clear();
            }
        }

        private void purgeOrderBy() {
            List<Token> sublist = this.findClauseOrNull(TokenType.ORDER);
            if (sublist != null) {
                sublist.clear();
            }
        }

        private List<Token> findClause(TokenType keyword) {
            return Objects.requireNonNull(this.findClauseOrNull(keyword), () -> "clause does not exist: " + (Object)((Object)keyword));
        }

        private @Nullable List<Token> findClauseOrNull(TokenType keyword) {
            int start = -1;
            int k = -1;
            EnumSet<TokenType[]> clauses = EnumSet.of(TokenType.SELECT, new TokenType[]{TokenType.FROM, TokenType.WHERE, TokenType.GROUP, TokenType.HAVING, TokenType.ORDER});
            for (Token token : this.tokenList) {
                ++k;
                if (token.type == keyword) {
                    start = k;
                    continue;
                }
                if (start < 0 || !clauses.contains((Object)token.type)) continue;
                return this.tokenList.subList(start, k);
            }
            if (start >= 0) {
                return this.tokenList.subList(start, k + 1);
            }
            return null;
        }

        private boolean contains(String hintToken) {
            for (Token token : this.tokenList) {
                switch (token.type) {
                    case ID: {
                        if (!hintToken.equals(token.s)) break;
                        return true;
                    }
                    case QUERY: {
                        if (!((Query)token).contains(hintToken)) break;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    public static class IdToken
    extends Token {
        public IdToken(TokenType type, String s2) {
            super(type, s2);
            assert (type == TokenType.DQID || type == TokenType.ID);
        }
    }

    public static class Token {
        private final TokenType type;
        private final @Nullable String s;

        Token(TokenType tokenType) {
            this(tokenType, null);
        }

        Token(TokenType type, @Nullable String s2) {
            this.type = type;
            this.s = s2;
        }

        public String toString() {
            return this.s == null ? this.type.toString() : (Object)((Object)this.type) + "(" + this.s + ")";
        }

        public void unparse(StringBuilder buf) {
            if (this.s == null) {
                buf.append(this.type.sql());
            } else {
                buf.append(this.s);
            }
        }
    }

    public static class Tokenizer {
        private static final Map<String, TokenType> TOKEN_TYPES = new HashMap<String, TokenType>();
        final String sql;
        private final String hintToken;
        private final char openQuote;
        private int pos;
        int start = 0;

        @Deprecated
        public Tokenizer(String sql, String hintToken) {
            this(sql, hintToken, Quoting.DOUBLE_QUOTE);
        }

        public Tokenizer(String sql, String hintToken, Quoting quoting) {
            this.sql = sql;
            this.hintToken = hintToken;
            this.openQuote = quoting.string.charAt(0);
            this.pos = 0;
        }

        private Token parseQuotedIdentifier() {
            String match;
            char closeQuote;
            this.start = this.pos++;
            char c = closeQuote = this.openQuote == '[' ? (char)']' : (char)this.openQuote;
            while (this.pos < this.sql.length()) {
                char c2 = this.sql.charAt(this.pos);
                ++this.pos;
                if (c2 != closeQuote) continue;
                if (this.pos >= this.sql.length() || this.sql.charAt(this.pos) != closeQuote) break;
                ++this.pos;
            }
            if ((match = this.sql.substring(this.start, this.pos)).startsWith(this.openQuote + " " + this.hintToken + " ")) {
                return new Token(TokenType.ID, this.hintToken);
            }
            return new Token(TokenType.DQID, match);
        }

        public @Nullable Token nextToken() {
            while (this.pos < this.sql.length()) {
                String name;
                TokenType tokenType;
                char c = this.sql.charAt(this.pos);
                switch (c) {
                    case ',': {
                        ++this.pos;
                        return new Token(TokenType.COMMA);
                    }
                    case '(': {
                        ++this.pos;
                        return new Token(TokenType.LPAREN);
                    }
                    case ')': {
                        ++this.pos;
                        return new Token(TokenType.RPAREN);
                    }
                    case '\'': {
                        char c1;
                        this.start = this.pos++;
                        while (this.pos < this.sql.length()) {
                            c = this.sql.charAt(this.pos);
                            ++this.pos;
                            if (c != '\'') continue;
                            if (this.pos >= this.sql.length() || (c1 = this.sql.charAt(this.pos)) != '\'') break;
                            ++this.pos;
                        }
                        String match = this.sql.substring(this.start, this.pos);
                        return new Token(TokenType.SQID, match);
                    }
                    case '/': {
                        char c1;
                        if (this.pos + 1 < this.sql.length()) {
                            c1 = this.sql.charAt(this.pos + 1);
                            if (c1 == '*') {
                                int end = this.sql.indexOf("*/", this.pos + 2);
                                end = end < 0 ? this.sql.length() : (end += "*/".length());
                                this.pos = end;
                                return new Token(TokenType.COMMENT);
                            }
                            if (c1 == '/') {
                                this.pos = Tokenizer.indexOfLineEnd(this.sql, this.pos + 2);
                                return new Token(TokenType.COMMENT);
                            }
                        }
                    }
                    case '-': {
                        if (c != '-' || this.pos + 1 >= this.sql.length() || this.sql.charAt(this.pos + 1) != '-') break;
                        this.pos = Tokenizer.indexOfLineEnd(this.sql, this.pos + 2);
                        return new Token(TokenType.COMMENT);
                    }
                }
                if (c == this.openQuote) {
                    return this.parseQuotedIdentifier();
                }
                if (Character.isWhitespace(c)) {
                    ++this.pos;
                    continue;
                }
                int start = this.pos++;
                block14: while (this.pos < this.sql.length()) {
                    c = this.sql.charAt(this.pos);
                    switch (c) {
                        case '\'': 
                        case '(': 
                        case ')': 
                        case ',': 
                        case '/': {
                            break block14;
                        }
                        case '-': {
                            if (c == '-' && this.pos + 1 < this.sql.length() && this.sql.charAt(this.pos + 1) == '-') break block14;
                        }
                        default: {
                            if (Character.isWhitespace(c) || c == this.openQuote) break block14;
                            ++this.pos;
                            continue block14;
                        }
                    }
                }
                if ((tokenType = TOKEN_TYPES.get((name = this.sql.substring(start, this.pos)).toUpperCase(Locale.ROOT))) == null) {
                    return new IdToken(TokenType.ID, name);
                }
                return new Token(tokenType);
            }
            return null;
        }

        private static int indexOfLineEnd(String sql, int i) {
            int length = sql.length();
            while (i < length) {
                char c = sql.charAt(i);
                switch (c) {
                    case '\n': 
                    case '\r': {
                        return i;
                    }
                }
                ++i;
            }
            return i;
        }

        static {
            for (TokenType type : TokenType.values()) {
                TOKEN_TYPES.put(type.name(), type);
            }
        }
    }

    static enum TokenType {
        SELECT,
        FROM,
        JOIN,
        ON,
        USING,
        WHERE,
        GROUP,
        HAVING,
        ORDER,
        BY,
        UNION,
        INTERSECT,
        EXCEPT,
        MINUS,
        LPAREN{

            @Override
            public String sql() {
                return "(";
            }
        }
        ,
        RPAREN{

            @Override
            public String sql() {
                return ")";
            }
        }
        ,
        ID,
        DQID,
        SQID,
        COMMENT,
        COMMA{

            @Override
            public String sql() {
                return ",";
            }
        }
        ,
        QUERY;


        public String sql() {
            return this.name();
        }
    }
}

