/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql;

import com.hazelcast.org.apache.calcite.linq4j.Ord;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlBinaryOperator;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlWindow;
import com.hazelcast.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.util.SqlBasicVisitor;
import com.hazelcast.org.apache.calcite.sql.util.SqlVisitor;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.util.Static;

public class SqlOverOperator
extends SqlBinaryOperator {
    public SqlOverOperator() {
        super("OVER", SqlKind.OVER, 20, true, ReturnTypes.ARG0_FORCE_NULLABLE, null, (SqlOperandTypeChecker)OperandTypes.ANY_IGNORE);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        assert (call.getOperator() == this);
        assert (call.operandCount() == 2);
        SqlCall aggCall = (SqlCall)call.operand(0);
        switch (aggCall.getKind()) {
            case RESPECT_NULLS: 
            case IGNORE_NULLS: {
                validator.validateCall(aggCall, scope);
                aggCall = (SqlCall)aggCall.operand(0);
                break;
            }
        }
        if (!aggCall.getOperator().isAggregator()) {
            throw validator.newValidationError(aggCall, Static.RESOURCE.overNonAggregate());
        }
        Object window = call.operand(1);
        validator.validateWindow((SqlNode)window, scope, aggCall);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        this.validateOperands(validator, scope, call);
        Object agg = call.operand(0);
        if (!(agg instanceof SqlCall)) {
            throw new IllegalStateException("Argument to SqlOverOperator should be SqlCall, got " + agg.getClass() + ": " + agg);
        }
        Object window = call.operand(1);
        SqlWindow w = validator.resolveWindow((SqlNode)window, scope);
        final int groupCount = w.isAlwaysNonEmpty() ? 1 : 0;
        SqlCall aggCall = (SqlCall)agg;
        SqlCallBinding opBinding = new SqlCallBinding(validator, scope, aggCall){

            @Override
            public int getGroupCount() {
                return groupCount;
            }
        };
        RelDataType ret = aggCall.getOperator().inferReturnType(opBinding);
        validator.setValidatedNodeType(call, ret);
        validator.setValidatedNodeType((SqlNode)agg, ret);
        return ret;
    }

    @Override
    public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
        if (onlyExpressions) {
            for (Ord<SqlNode> operand : Ord.zip(call.getOperandList())) {
                if (operand == null || operand.i == 1 && operand.e instanceof SqlIdentifier) continue;
                argHandler.visitChild(visitor, call, operand.i, (SqlNode)operand.e);
            }
        } else {
            super.acceptCall(visitor, call, onlyExpressions, argHandler);
        }
    }
}

