/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.runtime;

import com.hazelcast.org.apache.calcite.runtime.CalciteException;
import com.hazelcast.org.checkerframework.checker.initialization.qual.UnknownInitialization;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;

public class CalciteContextException
extends CalciteException {
    private static final long serialVersionUID = -54978888153560134L;
    private int posLine;
    private int posColumn;
    private int endPosLine;
    private int endPosColumn;
    private @Nullable String originalStatement;

    public CalciteContextException(String message, Throwable cause) {
        this(message, cause, 0, 0, 0, 0);
    }

    public CalciteContextException(String message, Throwable cause, int posLine, int posColumn, int endPosLine, int endPosColumn) {
        super(message, cause);
        assert (cause != null);
        this.setPosition(posLine, posColumn, endPosLine, endPosColumn);
    }

    public CalciteContextException(String message, Throwable cause, String inputText) {
        this(message, cause, 0, 0, 0, 0);
        this.originalStatement = inputText;
    }

    public void setPosition(int posLine, int posColumn) {
        this.posLine = posLine;
        this.posColumn = posColumn;
        this.endPosLine = posLine;
        this.endPosColumn = posColumn;
    }

    public void setPosition(@UnknownInitialization CalciteContextException this, int posLine, int posColumn, int endPosLine, int endPosColumn) {
        this.posLine = posLine;
        this.posColumn = posColumn;
        this.endPosLine = endPosLine;
        this.endPosColumn = endPosColumn;
    }

    public int getPosLine() {
        return this.posLine;
    }

    public int getPosColumn() {
        return this.posColumn;
    }

    public int getEndPosLine() {
        return this.endPosLine;
    }

    public int getEndPosColumn() {
        return this.endPosColumn;
    }

    public @Nullable String getOriginalStatement() {
        return this.originalStatement;
    }

    public void setOriginalStatement(@Nullable String originalStatement) {
        this.originalStatement = originalStatement;
    }

    @Override
    public @Nullable String getMessage() {
        Throwable cause = this.getCause();
        if (cause == null) {
            return super.getMessage();
        }
        return super.getMessage() + ": " + cause.getMessage();
    }
}

