/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rex;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rex.RexBiVisitor;
import com.hazelcast.org.apache.calcite.rex.RexDigestIncludeType;
import com.hazelcast.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexNormalize;
import com.hazelcast.org.apache.calcite.rex.RexSubQuery;
import com.hazelcast.org.apache.calcite.rex.RexUnknownAs;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.rex.RexVisitor;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSyntax;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.org.apache.calcite.util.Litmus;
import com.hazelcast.org.apache.calcite.util.Pair;
import com.hazelcast.org.apache.calcite.util.Sarg;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RexCall
extends RexNode {
    public final SqlOperator op;
    public final ImmutableList<RexNode> operands;
    public final RelDataType type;
    public final int nodeCount;
    protected int hash = 0;
    private @Nullable Pair<SqlOperator, List<RexNode>> normalized;

    protected RexCall(RelDataType type, SqlOperator operator, List<? extends RexNode> operands) {
        this.type = Objects.requireNonNull(type, "type");
        this.op = Objects.requireNonNull(operator, "operator");
        this.operands = ImmutableList.copyOf(operands);
        this.nodeCount = RexUtil.nodeCount(1, this.operands);
        assert (operator.getKind() != null) : operator;
        assert (operator.validRexOperands(operands.size(), Litmus.THROW)) : this;
        assert (operator.kind != SqlKind.IN || this instanceof RexSubQuery);
    }

    protected final void appendOperands(StringBuilder sb) {
        if (this.operands.isEmpty()) {
            return;
        }
        ArrayList<String> operandDigests = new ArrayList<String>(this.operands.size());
        for (int i = 0; i < this.operands.size(); ++i) {
            RexNode otherArg;
            RexNode operand = (RexNode)this.operands.get(i);
            if (!(operand instanceof RexLiteral)) {
                operandDigests.add(operand.toString());
                continue;
            }
            RexDigestIncludeType includeType = RexDigestIncludeType.OPTIONAL;
            if ((this.isA(SqlKind.AND) || this.isA(SqlKind.OR)) && operand.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
                includeType = RexDigestIncludeType.NO_TYPE;
            }
            if (SqlKind.SIMPLE_BINARY_OPS.contains((Object)this.getKind()) && (!((otherArg = (RexNode)this.operands.get(1 - i)) instanceof RexLiteral) || RexCall.digestSkipsType((RexLiteral)otherArg)) && SqlTypeUtil.equalSansNullability(operand.getType(), otherArg.getType())) {
                includeType = RexDigestIncludeType.NO_TYPE;
            }
            operandDigests.add(RexCall.computeDigest((RexLiteral)operand, includeType));
        }
        int totalLength = (operandDigests.size() - 1) * 2;
        for (String s2 : operandDigests) {
            totalLength += s2.length();
        }
        sb.ensureCapacity(sb.length() + totalLength);
        for (int i = 0; i < operandDigests.size(); ++i) {
            String op = (String)operandDigests.get(i);
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(op);
        }
    }

    private static boolean digestSkipsType(RexLiteral literal) {
        return literal.digestIncludesType() == RexDigestIncludeType.NO_TYPE;
    }

    private static String computeDigest(RexLiteral literal, RexDigestIncludeType includeType) {
        return literal.computeDigest(includeType);
    }

    protected String computeDigest(boolean withType) {
        StringBuilder sb = new StringBuilder(this.op.getName());
        if (this.operands.size() != 0 || this.op.getSyntax() != SqlSyntax.FUNCTION_ID) {
            sb.append("(");
            this.appendOperands(sb);
            sb.append(")");
        }
        if (withType) {
            sb.append(":");
            sb.append(this.type.getFullTypeString());
        }
        return sb.toString();
    }

    @Override
    public final String toString() {
        return this.computeDigest(this.digestWithType());
    }

    private boolean digestWithType() {
        return this.isA(SqlKind.CAST) || this.isA(SqlKind.NEW_SPECIFICATION);
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitCall(this);
    }

    @Override
    public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
        return visitor.visitCall(this, arg);
    }

    @Override
    public RelDataType getType() {
        return this.type;
    }

    @Override
    public boolean isAlwaysTrue() {
        switch (this.getKind()) {
            case IS_NOT_NULL: {
                return !((RexNode)this.operands.get(0)).getType().isNullable();
            }
            case IS_NOT_TRUE: 
            case IS_FALSE: 
            case NOT: {
                return ((RexNode)this.operands.get(0)).isAlwaysFalse();
            }
            case IS_NOT_FALSE: 
            case IS_TRUE: 
            case CAST: {
                return ((RexNode)this.operands.get(0)).isAlwaysTrue();
            }
            case SEARCH: {
                Sarg sarg = ((RexLiteral)this.operands.get(1)).getValueAs(Sarg.class);
                return Objects.requireNonNull(sarg, "sarg").isAll() && (sarg.nullAs == RexUnknownAs.TRUE || !((RexNode)this.operands.get(0)).getType().isNullable());
            }
        }
        return false;
    }

    @Override
    public boolean isAlwaysFalse() {
        switch (this.getKind()) {
            case IS_NULL: {
                return !((RexNode)this.operands.get(0)).getType().isNullable();
            }
            case IS_NOT_TRUE: 
            case IS_FALSE: 
            case NOT: {
                return ((RexNode)this.operands.get(0)).isAlwaysTrue();
            }
            case IS_NOT_FALSE: 
            case IS_TRUE: 
            case CAST: {
                return ((RexNode)this.operands.get(0)).isAlwaysFalse();
            }
            case SEARCH: {
                Sarg sarg = ((RexLiteral)this.operands.get(1)).getValueAs(Sarg.class);
                return Objects.requireNonNull(sarg, "sarg").isNone() && (sarg.nullAs == RexUnknownAs.FALSE || !((RexNode)this.operands.get(0)).getType().isNullable());
            }
        }
        return false;
    }

    @Override
    public SqlKind getKind() {
        return this.op.kind;
    }

    public List<RexNode> getOperands() {
        return this.operands;
    }

    public SqlOperator getOperator() {
        return this.op;
    }

    @Override
    public int nodeCount() {
        return this.nodeCount;
    }

    public RexCall clone(RelDataType type, List<RexNode> operands) {
        return new RexCall(type, this.op, operands);
    }

    private Pair<SqlOperator, List<RexNode>> getNormalized() {
        if (this.normalized == null) {
            this.normalized = RexNormalize.normalize(this.op, this.operands);
        }
        return this.normalized;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair<SqlOperator, List<RexNode>> x = this.getNormalized();
        RexCall rexCall = (RexCall)o;
        Pair<SqlOperator, List<RexNode>> y = rexCall.getNormalized();
        return ((SqlOperator)x.left).equals(y.left) && ((List)x.right).equals(y.right) && this.type.equals(rexCall.type);
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = RexNormalize.hashCode(this.op, this.operands);
        }
        return this.hash;
    }
}

