/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.linq4j.tree;

import com.hazelcast.org.apache.calcite.linq4j.tree.Blocks;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.org.apache.calcite.linq4j.tree.ExpressionType;
import com.hazelcast.org.apache.calcite.linq4j.tree.ExpressionWriter;
import com.hazelcast.org.apache.calcite.linq4j.tree.ParameterExpression;
import com.hazelcast.org.apache.calcite.linq4j.tree.Shuttle;
import com.hazelcast.org.apache.calcite.linq4j.tree.Statement;
import com.hazelcast.org.apache.calcite.linq4j.tree.Visitor;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Objects;

public class ForEachStatement
extends Statement {
    public final ParameterExpression parameter;
    public final Expression iterable;
    public final Statement body;
    private int hash;

    public ForEachStatement(ParameterExpression parameter, Expression iterable, Statement body) {
        super(ExpressionType.ForEach, Void.TYPE);
        this.parameter = Objects.requireNonNull(parameter, "parameter");
        this.iterable = Objects.requireNonNull(iterable, "iterable");
        this.body = Objects.requireNonNull(body, "body");
    }

    @Override
    public ForEachStatement accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        Expression iterable1 = this.iterable.accept(shuttle);
        Statement body1 = this.body.accept(shuttle);
        return shuttle.visit(this, this.parameter, iterable1, body1);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    void accept0(ExpressionWriter writer) {
        writer.append("for (").append(this.parameter.type).append(" ").append(this.parameter).append(" : ").append(this.iterable).append(") ").append(Blocks.toBlock(this.body));
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return this == o || o instanceof ForEachStatement && this.parameter.equals(((ForEachStatement)o).parameter) && this.iterable.equals(((ForEachStatement)o).iterable) && this.body.equals(((ForEachStatement)o).body);
    }

    @Override
    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            result = Objects.hash(new Object[]{this.nodeType, this.type, this.parameter, this.iterable, this.body});
            if (result == 0) {
                result = 1;
            }
            this.hash = result;
        }
        return result;
    }
}

