/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.interpreter;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.com.google.common.collect.ImmutableMap;
import com.hazelcast.com.google.common.collect.Iterables;
import com.hazelcast.com.google.common.collect.LinkedHashMultimap;
import com.hazelcast.com.google.common.collect.Lists;
import com.hazelcast.com.google.common.collect.Multimap;
import com.hazelcast.org.apache.calcite.DataContext;
import com.hazelcast.org.apache.calcite.DataContexts;
import com.hazelcast.org.apache.calcite.adapter.java.JavaTypeFactory;
import com.hazelcast.org.apache.calcite.config.CalciteSystemProperty;
import com.hazelcast.org.apache.calcite.interpreter.Compiler;
import com.hazelcast.org.apache.calcite.interpreter.Context;
import com.hazelcast.org.apache.calcite.interpreter.InterpretableRel;
import com.hazelcast.org.apache.calcite.interpreter.JaninoRexCompiler;
import com.hazelcast.org.apache.calcite.interpreter.Node;
import com.hazelcast.org.apache.calcite.interpreter.Nodes;
import com.hazelcast.org.apache.calcite.interpreter.Row;
import com.hazelcast.org.apache.calcite.interpreter.Scalar;
import com.hazelcast.org.apache.calcite.interpreter.Sink;
import com.hazelcast.org.apache.calcite.interpreter.Source;
import com.hazelcast.org.apache.calcite.linq4j.AbstractEnumerable;
import com.hazelcast.org.apache.calcite.linq4j.Enumerable;
import com.hazelcast.org.apache.calcite.linq4j.Enumerator;
import com.hazelcast.org.apache.calcite.linq4j.Linq4j;
import com.hazelcast.org.apache.calcite.linq4j.Ord;
import com.hazelcast.org.apache.calcite.linq4j.TransformedEnumerator;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.hep.HepPlanner;
import com.hazelcast.org.apache.calcite.plan.hep.HepProgram;
import com.hazelcast.org.apache.calcite.plan.hep.HepProgramBuilder;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.RelVisitor;
import com.hazelcast.org.apache.calcite.rel.rules.CoreRules;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.util.Pair;
import com.hazelcast.org.apache.calcite.util.ReflectUtil;
import com.hazelcast.org.apache.calcite.util.ReflectiveVisitDispatcher;
import com.hazelcast.org.apache.calcite.util.ReflectiveVisitor;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import com.hazelcast.org.checkerframework.checker.initialization.qual.UnknownInitialization;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public class Interpreter
extends AbstractEnumerable<Object[]>
implements AutoCloseable {
    private final Map<RelNode, NodeInfo> nodes;
    private final DataContext dataContext;
    private final RelNode rootRel;

    public Interpreter(DataContext dataContext, RelNode rootRel) {
        this.dataContext = Objects.requireNonNull(dataContext, "dataContext");
        RelNode rel = Interpreter.optimize(rootRel);
        Nodes.CoreCompiler compiler = new Nodes.CoreCompiler(this, rootRel.getCluster());
        Pair<RelNode, Map<RelNode, NodeInfo>> pair = compiler.visitRoot(rel);
        this.rootRel = (RelNode)pair.left;
        this.nodes = ImmutableMap.copyOf((Map)pair.right);
    }

    private static RelNode optimize(RelNode rootRel) {
        HepProgram hepProgram = new HepProgramBuilder().addRuleInstance(CoreRules.CALC_SPLIT).addRuleInstance(CoreRules.FILTER_SCAN).addRuleInstance(CoreRules.FILTER_INTERPRETER_SCAN).addRuleInstance(CoreRules.PROJECT_TABLE_SCAN).addRuleInstance(CoreRules.PROJECT_INTERPRETER_TABLE_SCAN).addRuleInstance(CoreRules.AGGREGATE_REDUCE_FUNCTIONS).build();
        HepPlanner planner = new HepPlanner(hepProgram);
        planner.setRoot(rootRel);
        rootRel = planner.findBestExp();
        return rootRel;
    }

    @Override
    public Enumerator<@Nullable Object[]> enumerator() {
        Enumerator<Object> rows;
        this.start();
        NodeInfo nodeInfo = Objects.requireNonNull(this.nodes.get(this.rootRel), () -> "nodeInfo for " + this.rootRel);
        if (nodeInfo.rowEnumerable != null) {
            rows = nodeInfo.rowEnumerable.enumerator();
        } else {
            ArrayDeque<Row> queue = Iterables.getOnlyElement(nodeInfo.sinks.values()).list;
            rows = Linq4j.iterableEnumerator(queue);
        }
        return new TransformedEnumerator<Row, Object[]>(rows){

            @Override
            protected @Nullable Object[] transform(Row row) {
                return row.getValues();
            }
        };
    }

    private void start() {
        for (Map.Entry<RelNode, NodeInfo> entry : this.nodes.entrySet()) {
            NodeInfo nodeInfo = entry.getValue();
            try {
                assert (nodeInfo.node != null) : "node must not be null for nodeInfo, rel=" + nodeInfo.rel;
                nodeInfo.node.run();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void close() {
        this.nodes.values().forEach(NodeInfo::close);
    }

    static interface ScalarCompiler {
        public Scalar.Producer compile(List<RexNode> var1, RelDataType var2);
    }

    static class Edge
    extends Pair<RelNode, Integer> {
        Edge(@Nullable RelNode parent, int ordinal) {
            super(parent, ordinal);
        }
    }

    static class CompilerImpl
    extends RelVisitor
    implements Compiler,
    ReflectiveVisitor {
        final ScalarCompiler scalarCompiler;
        private final ReflectiveVisitDispatcher<CompilerImpl, RelNode> dispatcher = ReflectUtil.createDispatcher(CompilerImpl.class, RelNode.class);
        @NotOnlyInitialized
        protected final Interpreter interpreter;
        protected @Nullable RelNode rootRel;
        protected @Nullable RelNode rel;
        protected @Nullable Node node;
        final Map<RelNode, NodeInfo> nodes = new LinkedHashMap<RelNode, NodeInfo>();
        final Map<RelNode, List<RelNode>> relInputs = new HashMap<RelNode, List<RelNode>>();
        final Multimap<RelNode, Edge> outEdges = LinkedHashMultimap.create();
        private static final String REWRITE_METHOD_NAME = "rewrite";
        private static final String VISIT_METHOD_NAME = "visit";

        CompilerImpl(@UnknownInitialization Interpreter interpreter, RelOptCluster cluster) {
            this.interpreter = interpreter;
            this.scalarCompiler = new JaninoRexCompiler(cluster.getRexBuilder());
        }

        Pair<RelNode, Map<RelNode, NodeInfo>> visitRoot(RelNode p) {
            this.rootRel = p;
            this.visit(p, 0, null);
            return Pair.of(Objects.requireNonNull(this.rootRel, "rootRel"), this.nodes);
        }

        @Override
        public void visit(RelNode p, int ordinal, @Nullable RelNode parent) {
            while (true) {
                this.rel = null;
                boolean found = this.dispatcher.invokeVisitor(this, p, REWRITE_METHOD_NAME);
                if (!found) {
                    throw new AssertionError((Object)"interpreter: no implementation for rewrite");
                }
                if (this.rel == null) break;
                if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
                    System.out.println("Interpreter: rewrite " + p + " to " + this.rel);
                }
                p = Objects.requireNonNull(this.rel, "rel");
                if (parent != null) {
                    List<RelNode> inputs = this.relInputs.get(parent);
                    if (inputs == null) {
                        inputs = Lists.newArrayList(parent.getInputs());
                        this.relInputs.put(parent, inputs);
                    }
                    inputs.set(ordinal, p);
                    continue;
                }
                this.rootRel = p;
            }
            List<RelNode> inputs = this.relInputs.get(p);
            RelNode finalP = p;
            Ord.forEach((Iterable)Util.first(inputs, p.getInputs()), (r, i) -> this.outEdges.put((RelNode)r, new Edge(finalP, i)));
            if (inputs != null) {
                for (int i2 = 0; i2 < inputs.size(); ++i2) {
                    RelNode input = inputs.get(i2);
                    this.visit(input, i2, p);
                }
            } else {
                p.childrenAccept(this);
            }
            this.node = null;
            boolean found = this.dispatcher.invokeVisitor(this, p, VISIT_METHOD_NAME);
            if (!found) {
                if (p instanceof InterpretableRel) {
                    InterpretableRel interpretableRel = (InterpretableRel)p;
                    this.node = interpretableRel.implement(new InterpretableRel.InterpreterImplementor(this, null, DataContexts.EMPTY));
                } else {
                    throw new AssertionError((Object)("interpreter: no implementation for " + p.getClass()));
                }
            }
            NodeInfo nodeInfo = this.nodes.get(p);
            assert (nodeInfo != null);
            nodeInfo.node = this.node;
            if (inputs != null) {
                for (int i3 = 0; i3 < inputs.size(); ++i3) {
                    RelNode input = inputs.get(i3);
                    this.visit(input, i3, p);
                }
            }
        }

        public void rewrite(RelNode r) {
        }

        @Override
        public Scalar compile(List<RexNode> nodes, @Nullable RelDataType inputRowType) {
            if (inputRowType == null) {
                inputRowType = this.getTypeFactory().builder().build();
            }
            return (Scalar)this.scalarCompiler.compile(nodes, inputRowType).apply(this.interpreter.dataContext);
        }

        private JavaTypeFactory getTypeFactory() {
            return this.interpreter.dataContext.getTypeFactory();
        }

        @Override
        public RelDataType combinedRowType(List<RelNode> inputs) {
            RelDataTypeFactory.FieldInfoBuilder builder = this.getTypeFactory().builder();
            for (RelNode input : inputs) {
                ((RelDataTypeFactory.Builder)builder).addAll(input.getRowType().getFieldList());
            }
            return builder.build();
        }

        @Override
        public Source source(RelNode rel, int ordinal) {
            RelNode input = this.getInput(rel, ordinal);
            Edge edge = new Edge(rel, ordinal);
            Collection<Edge> edges = this.outEdges.get(input);
            NodeInfo nodeInfo = this.nodes.get(input);
            if (nodeInfo == null) {
                throw new AssertionError((Object)("should be registered: " + rel));
            }
            if (nodeInfo.rowEnumerable != null) {
                return new EnumeratorSource(nodeInfo.rowEnumerable.enumerator());
            }
            assert (nodeInfo.sinks.size() == edges.size());
            ListSink sink = nodeInfo.sinks.get(edge);
            if (sink != null) {
                return new ListSource(sink.list);
            }
            throw new IllegalStateException("Got a sink " + sink + " to which there is no match source type!");
        }

        private RelNode getInput(RelNode rel, int ordinal) {
            List<RelNode> inputs = this.relInputs.get(rel);
            if (inputs != null) {
                return inputs.get(ordinal);
            }
            return rel.getInput(ordinal);
        }

        @Override
        public Sink sink(RelNode rel) {
            Collection<Edge> edges = this.outEdges.get(rel);
            Collection<Edge> edges2 = edges.isEmpty() ? ImmutableList.of(new Edge(null, 0)) : edges;
            NodeInfo nodeInfo = this.nodes.get(rel);
            if (nodeInfo == null) {
                nodeInfo = new NodeInfo(rel, null);
                this.nodes.put(rel, nodeInfo);
                for (Edge edge : edges2) {
                    nodeInfo.sinks.put(edge, new ListSink(new ArrayDeque()));
                }
            } else {
                for (Edge edge : edges2) {
                    if (nodeInfo.sinks.containsKey(edge)) continue;
                    nodeInfo.sinks.put(edge, new ListSink(new ArrayDeque()));
                }
            }
            if (edges.size() == 1) {
                return Iterables.getOnlyElement(nodeInfo.sinks.values());
            }
            ArrayList<ArrayDeque<Row>> queues = new ArrayList<ArrayDeque<Row>>();
            for (ListSink sink : nodeInfo.sinks.values()) {
                queues.add(sink.list);
            }
            return new DuplicatingSink(queues);
        }

        @Override
        public void enumerable(RelNode rel, Enumerable<Row> rowEnumerable) {
            NodeInfo nodeInfo = new NodeInfo(rel, rowEnumerable);
            this.nodes.put(rel, nodeInfo);
        }

        @Override
        public Context createContext() {
            return new Context(this.getDataContext());
        }

        @Override
        public DataContext getDataContext() {
            return this.interpreter.dataContext;
        }
    }

    private static class DuplicatingSink
    implements Sink {
        private List<ArrayDeque<Row>> queues;

        private DuplicatingSink(List<ArrayDeque<Row>> queues) {
            this.queues = ImmutableList.copyOf(queues);
        }

        @Override
        public void send(Row row) throws InterruptedException {
            for (ArrayDeque<Row> queue : this.queues) {
                queue.add(row);
            }
        }

        @Override
        public void end() throws InterruptedException {
        }

        @Override
        public void setSourceEnumerable(Enumerable<Row> enumerable) throws InterruptedException {
            Enumerator enumerator = enumerable.enumerator();
            while (enumerator.moveNext()) {
                this.send((Row)enumerator.current());
            }
            enumerator.close();
        }
    }

    private static class ListSource
    implements Source {
        private final ArrayDeque<Row> list;
        private @Nullable Iterator<Row> iterator;

        ListSource(ArrayDeque<Row> list) {
            this.list = list;
        }

        @Override
        public @Nullable Row receive() {
            try {
                if (this.iterator == null) {
                    this.iterator = this.list.iterator();
                }
                return this.iterator.next();
            }
            catch (NoSuchElementException e) {
                this.iterator = null;
                return null;
            }
        }

        @Override
        public void close() {
        }
    }

    private static class ListSink
    implements Sink {
        final ArrayDeque<Row> list;

        private ListSink(ArrayDeque<Row> list) {
            this.list = list;
        }

        @Override
        public void send(Row row) throws InterruptedException {
            this.list.add(row);
        }

        @Override
        public void end() throws InterruptedException {
        }

        @Override
        public void setSourceEnumerable(Enumerable<Row> enumerable) throws InterruptedException {
            Enumerator enumerator = enumerable.enumerator();
            while (enumerator.moveNext()) {
                this.send((Row)enumerator.current());
            }
            enumerator.close();
        }
    }

    private static class EnumeratorSource
    implements Source {
        private final Enumerator<Row> enumerator;

        EnumeratorSource(Enumerator<Row> enumerator) {
            this.enumerator = Objects.requireNonNull(enumerator, "enumerator");
        }

        @Override
        public @Nullable Row receive() {
            if (this.enumerator.moveNext()) {
                return this.enumerator.current();
            }
            this.enumerator.close();
            return null;
        }

        @Override
        public void close() {
            this.enumerator.close();
        }
    }

    private static class NodeInfo {
        final RelNode rel;
        final Map<Edge, ListSink> sinks = new LinkedHashMap<Edge, ListSink>();
        final @Nullable Enumerable<Row> rowEnumerable;
        @Nullable Node node;

        NodeInfo(RelNode rel, @Nullable Enumerable<Row> rowEnumerable) {
            this.rel = rel;
            this.rowEnumerable = rowEnumerable;
        }

        void close() {
            if (this.node != null) {
                Node n = this.node;
                this.node = null;
                n.close();
            }
        }
    }
}

