/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.adapter.enumerable;

import com.hazelcast.org.apache.calcite.DataContext;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import com.hazelcast.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import com.hazelcast.org.apache.calcite.adapter.enumerable.PhysType;
import com.hazelcast.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import com.hazelcast.org.apache.calcite.adapter.enumerable.RexImpTable;
import com.hazelcast.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import com.hazelcast.org.apache.calcite.adapter.java.JavaTypeFactory;
import com.hazelcast.org.apache.calcite.linq4j.tree.BlockBuilder;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.TableFunctionScan;
import com.hazelcast.org.apache.calcite.rel.metadata.RelColumnMapping;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rex.RexCall;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.schema.QueryableTable;
import com.hazelcast.org.apache.calcite.schema.impl.TableFunctionImpl;
import com.hazelcast.org.apache.calcite.sql.SqlWindowTableFunction;
import com.hazelcast.org.apache.calcite.sql.validate.SqlConformance;
import com.hazelcast.org.apache.calcite.sql.validate.SqlConformanceEnum;
import com.hazelcast.org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;

public class EnumerableTableFunctionScan
extends TableFunctionScan
implements EnumerableRel {
    public EnumerableTableFunctionScan(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, @Nullable Type elementType, RelDataType rowType, RexNode call, @Nullable Set<RelColumnMapping> columnMappings) {
        super(cluster, traits, inputs, call, elementType, rowType, columnMappings);
    }

    @Override
    public EnumerableTableFunctionScan copy(RelTraitSet traitSet, List<RelNode> inputs, RexNode rexCall, @Nullable Type elementType, RelDataType rowType, @Nullable Set<RelColumnMapping> columnMappings) {
        return new EnumerableTableFunctionScan(this.getCluster(), traitSet, inputs, elementType, rowType, rexCall, columnMappings);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        if (EnumerableTableFunctionScan.isImplementorDefined((RexCall)this.getCall())) {
            return this.tvfImplementorBasedImplement(implementor, pref);
        }
        return this.defaultTableFunctionImplement(implementor, pref);
    }

    private static boolean isImplementorDefined(RexCall call) {
        return call.getOperator() instanceof SqlWindowTableFunction && RexImpTable.INSTANCE.get((SqlWindowTableFunction)call.getOperator()) != null;
    }

    private boolean isQueryable() {
        if (!(this.getCall() instanceof RexCall)) {
            return false;
        }
        RexCall call = (RexCall)this.getCall();
        if (!(call.getOperator() instanceof SqlUserDefinedTableFunction)) {
            return false;
        }
        SqlUserDefinedTableFunction udtf = (SqlUserDefinedTableFunction)call.getOperator();
        if (!(udtf.getFunction() instanceof TableFunctionImpl)) {
            return false;
        }
        TableFunctionImpl tableFunction = (TableFunctionImpl)udtf.getFunction();
        Method method = tableFunction.method;
        return QueryableTable.class.isAssignableFrom(method.getReturnType());
    }

    private EnumerableRel.Result defaultTableFunctionImplement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder bb = new BlockBuilder();
        Type elementType = this.getElementType();
        JavaRowFormat format = elementType == null ? JavaRowFormat.ARRAY : (this.getRowType().getFieldCount() == 1 && this.isQueryable() ? JavaRowFormat.SCALAR : (elementType instanceof Class && Object[].class.isAssignableFrom((Class)elementType) ? JavaRowFormat.ARRAY : JavaRowFormat.CUSTOM));
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), format, false);
        RexToLixTranslator t2 = RexToLixTranslator.forAggregation((JavaTypeFactory)this.getCluster().getTypeFactory(), bb, null, implementor.getConformance());
        t2 = t2.setCorrelates(implementor.allCorrelateVariables);
        bb.add(Expressions.return_(null, t2.translate(this.getCall())));
        return implementor.result(physType, bb.toBlock());
    }

    private EnumerableRel.Result tvfImplementorBasedImplement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        JavaTypeFactory typeFactory = implementor.getTypeFactory();
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel child = (EnumerableRel)this.getInputs().get(0);
        EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
        PhysType physType = PhysTypeImpl.of(typeFactory, this.getRowType(), pref.prefer(result.format));
        Expression inputEnumerable = builder.append("_input", result.block, false);
        SqlConformance conformance = (SqlConformance)implementor.map.getOrDefault("_conformance", SqlConformanceEnum.DEFAULT);
        builder.add(RexToLixTranslator.translateTableFunction(typeFactory, conformance, builder, DataContext.ROOT, (RexCall)this.getCall(), inputEnumerable, result.physType, physType));
        return implementor.result(physType, builder.toBlock());
    }
}

