/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operators.string;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlValidator;
import com.hazelcast.jet.sql.impl.validate.operators.common.HazelcastFunction;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.ReplaceUnknownOperandTypeInference;
import com.hazelcast.jet.sql.impl.validate.param.AnyToVarcharParameterConverter;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlDynamicParam;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeTransforms;

public final class HazelcastConcatWSOperator
extends HazelcastFunction {
    public static final HazelcastConcatWSOperator INSTANCE = new HazelcastConcatWSOperator();

    private HazelcastConcatWSOperator() {
        super("CONCAT_WS", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.explicit(SqlTypeName.VARCHAR, -1), SqlTypeTransforms.TO_NULLABLE), new ReplaceUnknownOperandTypeInference(SqlTypeName.VARCHAR), SqlFunctionCategory.STRING);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.from(2);
    }

    @Override
    public boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        HazelcastSqlValidator validator = binding.getValidator();
        if (binding.getOperandType(0).getSqlTypeName() != SqlTypeName.VARCHAR) {
            if (throwOnFailure) {
                throw binding.newValidationSignatureError();
            }
            return false;
        }
        for (int i = 1; i < binding.getOperandCount(); ++i) {
            SqlNode operand = binding.operand(i);
            RelDataType operandType = binding.getOperandType(i);
            if (operandType.getSqlTypeName() != SqlTypeName.VARCHAR) {
                RelDataType newOperandType = HazelcastTypeUtils.createType(validator.getTypeFactory(), SqlTypeName.VARCHAR, operandType.isNullable());
                validator.getTypeCoercion().coerceOperandType(binding.getScope(), binding.getCall(), i, newOperandType);
            }
            if (operand.getKind() != SqlKind.DYNAMIC_PARAM) continue;
            int paramIndex = ((SqlDynamicParam)operand).getIndex();
            AnyToVarcharParameterConverter paramConverter = new AnyToVarcharParameterConverter(paramIndex, operand.getParserPosition());
            validator.setParameterConverter(paramIndex, paramConverter);
        }
        return true;
    }
}

