/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operand;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlValidator;
import com.hazelcast.jet.sql.impl.validate.operand.OperandChecker;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlDynamicParam;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.sql.impl.ParameterConverter;

public abstract class AbstractOperandChecker
implements OperandChecker {
    protected AbstractOperandChecker() {
    }

    @Override
    public boolean check(HazelcastCallBinding callBinding, boolean throwOnFailure, int operandIndex) {
        Object value;
        HazelcastSqlValidator validator = callBinding.getValidator();
        Object operand = callBinding.getCall().operand(operandIndex);
        if (((SqlNode)operand).getKind() == SqlKind.DYNAMIC_PARAM) {
            this.validateDynamicParam((SqlDynamicParam)operand, validator);
            return true;
        }
        if (((SqlNode)operand).getKind() == SqlKind.ARGUMENT_ASSIGNMENT && ((SqlNode)(value = ((SqlCall)operand).operand(0))).getKind() == SqlKind.DYNAMIC_PARAM) {
            this.validateDynamicParam((SqlDynamicParam)value, validator);
            return true;
        }
        RelDataType operandType = validator.deriveType(callBinding.getScope(), (SqlNode)operand);
        assert (!HazelcastTypeUtils.isNullOrUnknown(operandType.getSqlTypeName())) : "Operand type is not resolved";
        if (this.matchesTargetType(operandType)) {
            return true;
        }
        if (this.coerce(validator, callBinding, (SqlNode)operand, operandType, operandIndex)) {
            return true;
        }
        if (throwOnFailure) {
            throw callBinding.newValidationSignatureError();
        }
        return false;
    }

    private void validateDynamicParam(SqlDynamicParam operand, HazelcastSqlValidator validator) {
        RelDataType type = this.getTargetType(validator.getTypeFactory(), true);
        validator.setValidatedNodeType(operand, type);
        ParameterConverter converter = this.parameterConverter(operand);
        validator.setParameterConverter(operand.getIndex(), converter);
    }

    protected abstract RelDataType getTargetType(RelDataTypeFactory var1, boolean var2);

    protected abstract boolean matchesTargetType(RelDataType var1);

    protected abstract ParameterConverter parameterConverter(SqlDynamicParam var1);

    protected abstract boolean coerce(HazelcastSqlValidator var1, HazelcastCallBinding var2, SqlNode var3, RelDataType var4, int var5);
}

