/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.jet.datamodel.Tuple3;
import com.hazelcast.jet.sql.impl.schema.TableResolverImpl;
import com.hazelcast.jet.sql.impl.schema.TablesStorage;
import com.hazelcast.jet.sql.impl.schema.TypeDefinitionColumn;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.sql.impl.FieldsUtil;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.type.Type;
import com.hazelcast.sql.impl.schema.type.TypeKind;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TypesUtils {
    private TypesUtils() {
    }

    public static QueryDataType convertTypeToQueryDataType(Type rootType, TablesStorage tablesStorage) {
        return TypesUtils.convertTypeToQueryDataTypeInt(rootType.getName(), rootType, tablesStorage, new HashMap<String, QueryDataType>());
    }

    public static Type convertPortableClassToType(String name, ClassDefinition classDef, TableResolverImpl tableResolver) {
        Type type = new Type();
        type.setName(name);
        type.setKind(TypeKind.PORTABLE);
        type.setPortableFactoryId(Integer.valueOf(classDef.getFactoryId()));
        type.setPortableClassId(Integer.valueOf(classDef.getClassId()));
        type.setPortableVersion(Integer.valueOf(classDef.getVersion()));
        ArrayList<Type.TypeField> fields = new ArrayList<Type.TypeField>();
        for (int i = 0; i < classDef.getFieldCount(); ++i) {
            FieldDefinition portableField = classDef.getField(i);
            Type.TypeField typeField = new Type.TypeField();
            typeField.setName(portableField.getName());
            QueryDataType queryDataType = portableField.getType().equals((Object)FieldType.PORTABLE) ? TypesUtils.toQueryDataTypeRef(tableResolver.getTypes().stream().filter(t2 -> t2.getKind().equals((Object)TypeKind.PORTABLE)).filter(t2 -> t2.getPortableFactoryId().equals(portableField.getFactoryId())).filter(t2 -> t2.getPortableClassId().equals(portableField.getClassId())).filter(t2 -> t2.getPortableVersion().equals(portableField.getVersion())).findFirst().orElseThrow(() -> QueryException.error((String)("Type with Portable IDs " + TypesUtils.encodePortableId(portableField.getFactoryId(), portableField.getClassId(), portableField.getVersion()) + " does not exist.")))) : TypesUtils.resolvePortableFieldType(portableField.getType());
            typeField.setQueryDataType(queryDataType);
            fields.add(typeField);
        }
        type.setFields(fields);
        return type;
    }

    public static QueryDataType resolvePortableFieldType(FieldType fieldType) {
        switch (fieldType) {
            case BOOLEAN: {
                return QueryDataType.BOOLEAN;
            }
            case BYTE: {
                return QueryDataType.TINYINT;
            }
            case SHORT: {
                return QueryDataType.SMALLINT;
            }
            case INT: {
                return QueryDataType.INT;
            }
            case LONG: {
                return QueryDataType.BIGINT;
            }
            case FLOAT: {
                return QueryDataType.REAL;
            }
            case DOUBLE: {
                return QueryDataType.DOUBLE;
            }
            case DECIMAL: {
                return QueryDataType.DECIMAL;
            }
            case CHAR: {
                return QueryDataType.VARCHAR_CHARACTER;
            }
            case UTF: {
                return QueryDataType.VARCHAR;
            }
            case TIME: {
                return QueryDataType.TIME;
            }
            case DATE: {
                return QueryDataType.DATE;
            }
            case TIMESTAMP: {
                return QueryDataType.TIMESTAMP;
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                return QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME;
            }
        }
        return QueryDataType.OBJECT;
    }

    public static QueryDataType toQueryDataTypeRef(Type type) {
        switch (type.getKind()) {
            case JAVA: {
                QueryDataType queryDataType = new QueryDataType(type.getName(), QueryDataType.OBJECT_TYPE_KIND_JAVA);
                queryDataType.setObjectTypeMetadata(type.getJavaClassName());
                return queryDataType;
            }
            case PORTABLE: {
                QueryDataType queryDataType = new QueryDataType(type.getName(), QueryDataType.OBJECT_TYPE_KIND_PORTABLE);
                queryDataType.setObjectTypeMetadata(TypesUtils.encodePortableId(type.getPortableFactoryId(), type.getPortableClassId(), type.getPortableVersion()));
                return queryDataType;
            }
            case COMPACT: {
                QueryDataType queryDataType = new QueryDataType(type.getName(), QueryDataType.OBJECT_TYPE_KIND_COMPACT);
                queryDataType.setObjectTypeMetadata(type.getCompactTypeName());
                return queryDataType;
            }
        }
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public static String encodePortableId(int factoryId, int classId, int version) {
        return factoryId + ":" + classId + ":" + version;
    }

    public static Tuple3<Integer, Integer, Integer> decodePortableId(String encoded) {
        String[] components = encoded.split(":");
        assert (components.length == 3) : "Number of Portable ID components should always be 3";
        return Tuple3.tuple3((Object)Integer.parseInt(components[0]), (Object)Integer.parseInt(components[1]), (Object)Integer.parseInt(components[2]));
    }

    public static Type convertJavaClassToType(String name, List<TypeDefinitionColumn> columns, Class<?> typeClass) {
        Map<String, QueryDataType> userColumnsMap = columns.stream().collect(Collectors.toMap(TypeDefinitionColumn::name, TypeDefinitionColumn::dataType));
        Type type = new Type();
        type.setName(name);
        type.setKind(TypeKind.JAVA);
        type.setJavaClassName(typeClass.getName());
        ArrayList<Type.TypeField> fields = new ArrayList<Type.TypeField>();
        for (Map.Entry entry : FieldsUtil.resolveClass(typeClass).entrySet()) {
            QueryDataType queryDataType = TypesUtils.isUserClass((Class)entry.getValue()) ? (((Class)entry.getValue()).getName().equals(type.getJavaClassName()) ? TypesUtils.toQueryDataTypeRef(type) : (userColumnsMap.get(entry.getKey()) != null ? userColumnsMap.get(entry.getKey()) : QueryDataType.OBJECT)) : QueryDataTypeUtils.resolveTypeForClass((Class)((Class)entry.getValue()));
            fields.add(new Type.TypeField((String)entry.getKey(), queryDataType));
        }
        type.setFields(fields);
        return type;
    }

    public static void enrichMappingFieldType(TypeKind mappingTypeKind, MappingField field, TablesStorage tablesStorage) {
        if (!field.type().isCustomType()) {
            return;
        }
        Type type = tablesStorage.getType(field.type().getObjectTypeName());
        if (type == null) {
            throw QueryException.error((String)("Non existing type found in the mapping: " + field.type().getObjectTypeName()));
        }
        if (!mappingTypeKind.equals((Object)type.getKind())) {
            throw QueryException.error((String)("Can not use Type " + type.getName() + "[" + type.getKind() + "] with " + mappingTypeKind + " mapping."));
        }
        QueryDataType resolved = TypesUtils.convertTypeToQueryDataType(type, tablesStorage);
        field.setType(resolved);
    }

    public static TypeKind formatToTypeKind(String format) {
        if (format == null) {
            return TypeKind.NONE;
        }
        switch (format) {
            case "java": {
                return TypeKind.JAVA;
            }
            case "portable": {
                return TypeKind.PORTABLE;
            }
            case "compact": {
                return TypeKind.COMPACT;
            }
        }
        return TypeKind.NONE;
    }

    private static QueryDataType convertTypeToQueryDataTypeInt(@Nonnull String typeName, @Nullable Type type, @Nonnull TablesStorage tablesStorage, @Nonnull Map<String, QueryDataType> seen) {
        QueryDataType convertedType = seen.get(typeName);
        if (convertedType != null) {
            return convertedType;
        }
        if (type == null) {
            type = tablesStorage.getType(typeName);
        }
        if (type == null) {
            throw QueryException.error((String)("Encountered type '" + typeName + "', which doesn't exist"));
        }
        convertedType = TypesUtils.toQueryDataTypeRef(type);
        seen.putIfAbsent(type.getName(), convertedType);
        for (Type.TypeField field : type.getFields()) {
            QueryDataType queryDataType = field.getQueryDataType().isCustomType() ? TypesUtils.convertTypeToQueryDataTypeInt(field.getQueryDataType().getObjectTypeName(), null, tablesStorage, seen) : field.getQueryDataType();
            convertedType.getObjectFields().add(new QueryDataType.QueryDataTypeField(field.getName(), queryDataType));
        }
        return convertedType;
    }

    private static boolean isUserClass(Class<?> clazz) {
        return !clazz.isPrimitive() && !clazz.getPackage().getName().startsWith("java.");
    }
}

