/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.org.apache.calcite.sql.SqlDrop;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.util.ImmutableNullableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SqlDropType
extends SqlDrop {
    private static final SqlSpecialOperator DROP_TYPE = new SqlSpecialOperator("DROP TYPE", SqlKind.DROP_TYPE);
    private final SqlIdentifier typeName;

    public SqlDropType(SqlIdentifier name, boolean ifExists, SqlParserPos pos) {
        super(DROP_TYPE, pos, ifExists);
        this.typeName = Objects.requireNonNull(name, "Type name should not be null");
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    public String typeName() {
        return this.typeName.toString();
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return DROP_TYPE;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.typeName);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP TYPE");
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.typeName.unparse(writer, leftPrec, rightPrec);
    }
}

