/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.AggregateLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.ImmutableStreamAggregateCannotExecuteRule;
import com.hazelcast.jet.sql.impl.opt.physical.ShouldNotExecuteRel;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import org.immutables.value.Value;

@Value.Enclosing
public final class StreamAggregateCannotExecuteRule
extends RelRule<RelRule.Config> {
    public static final RelOptRule INSTANCE = new StreamAggregateCannotExecuteRule(Config.DEFAULT);

    private StreamAggregateCannotExecuteRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        AggregateLogicalRel aggr = (AggregateLogicalRel)call.rel(0);
        call.transformTo(new ShouldNotExecuteRel(aggr.getCluster(), OptUtils.toPhysicalConvention(aggr.getTraitSet()), aggr.getRowType(), "Streaming aggregation is supported only for window aggregation, with imposed order, grouping by a window bound (see TUMBLE/HOP and IMPOSE_ORDER functions)"));
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableStreamAggregateCannotExecuteRule.Config.builder().description(StreamAggregateCannotExecuteRule.class.getSimpleName()).operandSupplier(b0 -> b0.operand(AggregateLogicalRel.class).trait(Conventions.LOGICAL).predicate(OptUtils::isUnbounded).anyInputs()).build();

        @Override
        default public RelOptRule toRule() {
            return new StreamAggregateCannotExecuteRule(this);
        }
    }
}

