/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.core.SlidingWindowPolicy;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.function.KeyedWindowResultFunction;
import com.hazelcast.jet.impl.util.ConstantFunctionEx;
import com.hazelcast.jet.sql.impl.ObjectArrayKey;
import com.hazelcast.jet.sql.impl.aggregate.WindowUtils;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.metadata.WatermarkedFields;
import com.hazelcast.jet.sql.impl.opt.physical.AggregateAbstractPhysicalRule;
import com.hazelcast.jet.sql.impl.opt.physical.CreateDagVisitor;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Aggregate;
import com.hazelcast.org.apache.calcite.rel.core.AggregateCall;
import com.hazelcast.org.apache.calcite.rel.hint.RelHint;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.expression.ColumnExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class SlidingWindowAggregatePhysicalRel
extends Aggregate
implements PhysicalRel {
    private final int timestampFieldIndex;
    private final FunctionEx<ExpressionEvalContext, SlidingWindowPolicy> windowPolicyProvider;
    private final int numStages;
    private final List<Integer> windowStartIndexes;
    private final List<Integer> windowEndIndexes;

    SlidingWindowAggregatePhysicalRel(RelOptCluster cluster, RelTraitSet traits, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls, int timestampFieldIndex, FunctionEx<ExpressionEvalContext, SlidingWindowPolicy> windowPolicyProvider, int numStages, List<Integer> windowStartIndexes, List<Integer> windowEndIndexes) {
        super(cluster, traits, new ArrayList<RelHint>(), input, groupSet, groupSets, aggCalls);
        this.timestampFieldIndex = timestampFieldIndex;
        this.windowPolicyProvider = windowPolicyProvider;
        this.numStages = numStages;
        this.windowStartIndexes = windowStartIndexes;
        this.windowEndIndexes = windowEndIndexes;
    }

    public FunctionEx<JetSqlRow, ?> groupKeyFn() {
        ImmutableBitSet groupSet = this.getGroupSetReduced();
        if (groupSet.isEmpty()) {
            return new ConstantFunctionEx((Object)ThreadLocalRandom.current().nextInt());
        }
        return ObjectArrayKey.projectFn(groupSet.toArray());
    }

    public AggregateOperation<?, JetSqlRow> aggrOp() {
        return AggregateAbstractPhysicalRule.aggregateOperation(this.getInput().getRowType(), this.getGroupSetReduced(), this.getAggCallList());
    }

    private ImmutableBitSet getGroupSetReduced() {
        ImmutableBitSet reducedGroupSet = this.getGroupSet();
        for (Integer index : this.windowStartIndexes) {
            reducedGroupSet = reducedGroupSet.clear(index);
        }
        for (Integer index : this.windowEndIndexes) {
            reducedGroupSet = reducedGroupSet.clear(index);
        }
        return reducedGroupSet;
    }

    public int timestampFieldIndex() {
        return this.timestampFieldIndex;
    }

    public Expression<?> timestampExpression() {
        RelDataTypeField timestampField = this.getInput().getRowType().getFieldList().get(this.timestampFieldIndex);
        return ColumnExpression.create((int)this.timestampFieldIndex, (QueryDataType)HazelcastTypeUtils.toHazelcastType(timestampField.getType()));
    }

    public FunctionEx<ExpressionEvalContext, SlidingWindowPolicy> windowPolicyProvider() {
        return this.windowPolicyProvider;
    }

    public int numStages() {
        return this.numStages;
    }

    public KeyedWindowResultFunction<? super Object, ? super JetSqlRow, ?> outputValueMapping() {
        int[] windowBoundsIndexMask = new int[this.getRowType().getFieldCount()];
        QueryDataType descriptorType = this.timestampExpression().getType();
        for (Integer index : this.windowStartIndexes) {
            windowBoundsIndexMask[index.intValue()] = -1;
        }
        for (Integer index : this.windowEndIndexes) {
            windowBoundsIndexMask[index.intValue()] = -2;
        }
        int j = 0;
        for (int i = 0; i < windowBoundsIndexMask.length; ++i) {
            if (windowBoundsIndexMask[i] < 0) continue;
            windowBoundsIndexMask[i] = j++;
        }
        return (KeyedWindowResultFunction & Serializable)(start, end, ignoredKey, result, isEarly) -> WindowUtils.insertWindowBound(result, start, end, descriptorType, windowBoundsIndexMask);
    }

    public WatermarkedFields watermarkedFields() {
        return new WatermarkedFields(new HashSet<Integer>(this.windowEndIndexes));
    }

    @Override
    public PlanNodeSchema schema(QueryParameterMetadata parameterMetadata) {
        return OptUtils.schema(this.getRowType());
    }

    @Override
    public Vertex accept(CreateDagVisitor visitor) {
        return visitor.onSlidingWindowAggregate(this);
    }

    @Override
    public final Aggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        return new SlidingWindowAggregatePhysicalRel(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls, this.timestampFieldIndex, this.windowPolicyProvider, this.numStages, this.windowStartIndexes, this.windowEndIndexes);
    }
}

