/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.TableModifyLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.UpdateByKeyMapLogicalRel;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;

final class UpdateByKeyMapLogicalRule
extends RelOptRule {
    static final RelOptRule INSTANCE = new UpdateByKeyMapLogicalRule();

    private UpdateByKeyMapLogicalRule() {
        super(UpdateByKeyMapLogicalRule.operandJ(TableModifyLogicalRel.class, Conventions.LOGICAL, modify -> !OptUtils.requiresJob(modify) && modify.isUpdate(), UpdateByKeyMapLogicalRule.operandJ(FullScanLogicalRel.class, null, scan -> OptUtils.hasTableType(scan, PartitionedMapTable.class), UpdateByKeyMapLogicalRule.none()), new RelOptRuleOperand[0]), UpdateByKeyMapLogicalRule.class.getSimpleName());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        TableModifyLogicalRel update = (TableModifyLogicalRel)call.rel(0);
        FullScanLogicalRel scan = (FullScanLogicalRel)call.rel(1);
        RelOptTable table = scan.getTable();
        RexNode keyCondition = OptUtils.extractKeyConstantExpression(table, update.getCluster().getRexBuilder());
        if (keyCondition != null) {
            UpdateByKeyMapLogicalRel rel = new UpdateByKeyMapLogicalRel(update.getCluster(), OptUtils.toLogicalConvention(update.getTraitSet()), table, keyCondition, update.getUpdateColumnList(), update.getSourceExpressionList());
            call.transformTo(rel);
        }
    }
}

