/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.jet.sql.impl.inject.UpsertInjector;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetUtils;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.RowValue;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class PojoUpsertTarget
implements UpsertTarget {
    private final Class<?> clazz;
    private final Map<String, Class<?>> typesByPaths;
    private Object pojo;

    PojoUpsertTarget(String className, Map<String, String> typeNamesByPaths) {
        this.clazz = ReflectionUtils.loadClass((String)className);
        this.typesByPaths = typeNamesByPaths.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ReflectionUtils.loadClass((String)((String)entry.getValue()))));
    }

    @Override
    public UpsertInjector createInjector(@Nullable String path, QueryDataType type) {
        if (path == null) {
            return UpsertInjector.FAILING_TOP_LEVEL_INJECTOR;
        }
        Method method = ReflectionUtils.findPropertySetter(this.clazz, (String)path, this.typesByPaths.get(path));
        if (method != null) {
            return this.createMethodInjector(method, type);
        }
        Field field = ReflectionUtils.findPropertyField(this.clazz, (String)path);
        if (field != null) {
            return this.createFieldInjector(field, type);
        }
        return this.createFailingInjector(path);
    }

    private UpsertInjector createMethodInjector(@Nonnull Method method, QueryDataType targetType) {
        return value -> {
            if (value == null && method.getParameterTypes()[0].isPrimitive()) {
                throw QueryException.error((String)("Cannot pass NULL to a method with a primitive argument: " + method));
            }
            try {
                if (value instanceof RowValue) {
                    method.invoke(this.pojo, UpsertTargetUtils.convertRowToJavaType(value, targetType));
                } else {
                    method.invoke(this.pojo, value);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw QueryException.error((String)("Invocation of '" + method + "' failed: " + e), (Throwable)e);
            }
        };
    }

    private UpsertInjector createFieldInjector(@Nonnull Field field, QueryDataType targetType) {
        return value -> {
            if (value == null && field.getType().isPrimitive()) {
                throw QueryException.error((String)("Cannot set NULL to a primitive field: " + field));
            }
            try {
                if (value instanceof RowValue) {
                    field.set(this.pojo, UpsertTargetUtils.convertRowToJavaType(value, targetType));
                } else {
                    field.set(this.pojo, value);
                }
            }
            catch (IllegalAccessException e) {
                throw QueryException.error((String)("Failed to set field " + field + ": " + e), (Throwable)e);
            }
        };
    }

    @Nonnull
    private UpsertInjector createFailingInjector(String path) {
        return value -> {
            if (value != null) {
                throw QueryException.error((String)("Cannot set property \"" + path + "\" to class " + this.clazz.getName() + ": no set-method or public field available"));
            }
        };
    }

    @Override
    public void init() {
        try {
            this.pojo = this.clazz.newInstance();
        }
        catch (Exception e) {
            throw QueryException.error((String)("Unable to instantiate class \"" + this.clazz.getName() + "\" : " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public Object conclude() {
        Object pojo = this.pojo;
        this.pojo = null;
        return pojo;
    }
}

