/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.datamodel.Tuple3;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorUtil;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolver;
import com.hazelcast.jet.sql.impl.inject.PortableUpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.schema.TypesUtils;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionBuilder;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class MetadataPortableResolver
implements KvMetadataResolver {
    static final MetadataPortableResolver INSTANCE = new MetadataPortableResolver();

    private MetadataPortableResolver() {
    }

    @Override
    public Stream<String> supportedFormats() {
        return Stream.of("portable");
    }

    @Override
    public Stream<MappingField> resolveAndValidateFields(boolean isKey, List<MappingField> userFields, Map<String, String> options, InternalSerializationService serializationService) {
        Map<QueryPath, MappingField> userFieldsByPath = KvMetadataResolver.extractFields(userFields, isKey);
        ClassDefinition classDefinition = MetadataPortableResolver.findClassDefinition(isKey, options, serializationService);
        return userFields.isEmpty() ? this.resolveFields(isKey, classDefinition, serializationService) : MetadataPortableResolver.resolveAndValidateFields(isKey, userFieldsByPath, classDefinition);
    }

    Stream<MappingField> resolveFields(boolean isKey, @Nullable ClassDefinition clazz, InternalSerializationService ss) {
        if (clazz == null || clazz.getFieldCount() == 0) {
            String name2 = isKey ? QueryPath.KEY : QueryPath.VALUE;
            return Stream.of(new MappingField(name2, QueryDataType.OBJECT, name2));
        }
        return clazz.getFieldNames().stream().map(name -> {
            QueryPath path = new QueryPath(name, isKey);
            QueryDataType type = TypesUtils.resolvePortableFieldType(clazz.getFieldType(name));
            return new MappingField(name, type, path.toString());
        });
    }

    private static Stream<MappingField> resolveAndValidateFields(boolean isKey, Map<QueryPath, MappingField> userFieldsByPath, @Nullable ClassDefinition clazz) {
        if (clazz == null) {
            return userFieldsByPath.values().stream().peek(mappingField -> {
                QueryDataType type = mappingField.type();
                if (type.getTypeFamily().equals((Object)QueryDataTypeFamily.OBJECT)) {
                    throw QueryException.error((String)("Cannot derive Portable type for '" + type.getTypeFamily() + "'"));
                }
            });
        }
        for (String name : clazz.getFieldNames()) {
            QueryPath path = new QueryPath(name, isKey);
            QueryDataType type = TypesUtils.resolvePortableFieldType(clazz.getFieldType(name));
            MappingField userField = userFieldsByPath.get(path);
            if (userField == null || type.getTypeFamily().equals((Object)userField.type().getTypeFamily())) continue;
            throw QueryException.error((String)("Mismatch between declared and resolved type: " + userField.name()));
        }
        return userFieldsByPath.values().stream();
    }

    @Override
    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<String, String> options, InternalSerializationService serializationService) {
        Map<QueryPath, MappingField> fieldsByPath = KvMetadataResolver.extractFields(resolvedFields, isKey);
        ClassDefinition clazz = MetadataPortableResolver.resolveClassDefinition(isKey, options, fieldsByPath.values(), serializationService);
        return MetadataPortableResolver.resolveMetadata(isKey, resolvedFields, fieldsByPath, clazz);
    }

    private static KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<QueryPath, MappingField> fieldsByPath, @Nonnull ClassDefinition clazz) {
        ArrayList<TableField> fields = new ArrayList<TableField>();
        for (Map.Entry<QueryPath, MappingField> entry : fieldsByPath.entrySet()) {
            QueryPath path = entry.getKey();
            QueryDataType type = entry.getValue().type();
            String name = entry.getValue().name();
            fields.add((TableField)new MapTableField(name, type, false, path));
        }
        KvMetadataResolver.maybeAddDefaultField(isKey, resolvedFields, fields, QueryDataType.OBJECT);
        return new KvMetadata(fields, (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, new PortableUpsertTargetDescriptor(clazz));
    }

    @Nullable
    private static ClassDefinition findClassDefinition(boolean isKey, Map<String, String> options, InternalSerializationService serializationService) {
        Tuple3<Integer, Integer, Integer> settings = MetadataPortableResolver.settings(isKey, options);
        return serializationService.getPortableContext().lookupClassDefinition(((Integer)settings.f0()).intValue(), ((Integer)settings.f1()).intValue(), ((Integer)settings.f2()).intValue());
    }

    @Nonnull
    private static ClassDefinition resolveClassDefinition(boolean isKey, Map<String, String> options, Collection<MappingField> fields, InternalSerializationService serializationService) {
        Tuple3<Integer, Integer, Integer> settings = MetadataPortableResolver.settings(isKey, options);
        ClassDefinition classDefinition = serializationService.getPortableContext().lookupClassDefinition(((Integer)settings.f0()).intValue(), ((Integer)settings.f1()).intValue(), ((Integer)settings.f2()).intValue());
        if (classDefinition != null) {
            return classDefinition;
        }
        ClassDefinitionBuilder classDefinitionBuilder = new ClassDefinitionBuilder(((Integer)settings.f0()).intValue(), ((Integer)settings.f1()).intValue(), ((Integer)settings.f2()).intValue());
        for (MappingField field : fields) {
            String name = field.name();
            QueryDataType type = field.type();
            switch (type.getTypeFamily()) {
                case BOOLEAN: {
                    classDefinitionBuilder.addBooleanField(name);
                    break;
                }
                case TINYINT: {
                    classDefinitionBuilder.addByteField(name);
                    break;
                }
                case SMALLINT: {
                    classDefinitionBuilder.addShortField(name);
                    break;
                }
                case INTEGER: {
                    classDefinitionBuilder.addIntField(name);
                    break;
                }
                case BIGINT: {
                    classDefinitionBuilder.addLongField(name);
                    break;
                }
                case REAL: {
                    classDefinitionBuilder.addFloatField(name);
                    break;
                }
                case DOUBLE: {
                    classDefinitionBuilder.addDoubleField(name);
                    break;
                }
                case DECIMAL: {
                    classDefinitionBuilder.addDecimalField(name);
                    break;
                }
                case VARCHAR: {
                    classDefinitionBuilder.addStringField(name);
                    break;
                }
                case TIME: {
                    classDefinitionBuilder.addTimeField(name);
                    break;
                }
                case DATE: {
                    classDefinitionBuilder.addDateField(name);
                    break;
                }
                case TIMESTAMP: {
                    classDefinitionBuilder.addTimestampField(name);
                    break;
                }
                case TIMESTAMP_WITH_TIME_ZONE: {
                    classDefinitionBuilder.addTimestampWithTimezoneField(name);
                    break;
                }
            }
        }
        return classDefinitionBuilder.build();
    }

    private static Tuple3<Integer, Integer, Integer> settings(boolean isKey, Map<String, String> options) {
        String factoryIdProperty = isKey ? "keyPortableFactoryId" : "valuePortableFactoryId";
        String classIdProperty = isKey ? "keyPortableClassId" : "valuePortableClassId";
        String classVersionProperty = isKey ? "keyPortableClassVersion" : "valuePortableClassVersion";
        return Tuple3.tuple3((Object)SqlConnectorUtil.asInt(options, factoryIdProperty, null), (Object)SqlConnectorUtil.asInt(options, classIdProperty, null), (Object)SqlConnectorUtil.asInt(options, classVersionProperty, 0));
    }
}

