/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTableField;
import com.hazelcast.jet.sql.impl.connector.jdbc.ParamCollectingVisitor;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.org.apache.calcite.rel.rel2sql.SqlImplementor;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import java.util.List;
import java.util.stream.Collectors;

class SelectQueryBuilder {
    private final String query;
    private final ParamCollectingVisitor paramCollectingVisitor = new ParamCollectingVisitor();

    SelectQueryBuilder(HazelcastTable hzTable) {
        JdbcTable table = (JdbcTable)((Object)hzTable.getTarget());
        SqlDialect dialect = table.sqlDialect();
        SqlImplementor.SimpleContext simpleContext = new SqlImplementor.SimpleContext(dialect, value -> {
            JdbcTableField field = (JdbcTableField)table.getField(value);
            return new SqlIdentifier(field.externalName(), SqlParserPos.ZERO);
        });
        RexNode filter = hzTable.getFilter();
        String predicateFragment = null;
        if (filter != null) {
            SqlNode sqlNode = simpleContext.toSql(null, filter);
            sqlNode.accept(this.paramCollectingVisitor);
            predicateFragment = sqlNode.toSqlString(dialect).toString();
        }
        String projectionFragment = null;
        List<RexNode> projects = hzTable.getProjects();
        if (!projects.isEmpty()) {
            projectionFragment = projects.stream().map(proj -> simpleContext.toSql(null, (RexNode)proj).toSqlString(dialect).toString()).collect(Collectors.joining(","));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        if (projectionFragment != null) {
            sb.append(projectionFragment);
        } else {
            sb.append("*");
        }
        sb.append(" FROM ").append(table.getExternalName());
        if (predicateFragment != null) {
            sb.append(" WHERE ").append(predicateFragment);
        }
        this.query = sb.toString();
    }

    String query() {
        return this.query;
    }

    int[] parameterPositions() {
        return this.paramCollectingVisitor.parameterPositions();
    }
}

