/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.ToResultSetFunction;
import com.hazelcast.jet.impl.connector.ReadJdbcP;
import com.hazelcast.jet.sql.impl.connector.jdbc.AbstractJdbcSqlConnectorProcessorSupplier;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.security.impl.function.SecuredFunction;
import com.hazelcast.security.permission.ConnectorPermission;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.io.IOException;
import java.io.Serializable;
import java.security.Permission;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SelectProcessorSupplier
extends AbstractJdbcSqlConnectorProcessorSupplier
implements ProcessorSupplier,
DataSerializable,
SecuredFunction {
    private String query;
    private int[] parameterPositions;
    private transient ExpressionEvalContext evalContext;

    public SelectProcessorSupplier() {
    }

    public SelectProcessorSupplier(@Nonnull String externalDataStoreRef, @Nonnull String query, @Nonnull int[] parameterPositions) {
        super(externalDataStoreRef);
        this.query = Objects.requireNonNull(query, "query must not be null");
        this.parameterPositions = Objects.requireNonNull(parameterPositions, "parameterPositions must not be null");
    }

    @Override
    public void init(@Nonnull ProcessorSupplier.Context context) throws Exception {
        super.init(context);
        this.evalContext = ExpressionEvalContext.from((ProcessorSupplier.Context)context);
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        ArrayList<ReadJdbcP> processors = new ArrayList<ReadJdbcP>(count);
        for (int i = 0; i < count; ++i) {
            ReadJdbcP processor = new ReadJdbcP((SupplierEx & Serializable)() -> this.dataSource.getConnection(), (ToResultSetFunction & Serializable)(connection, parallelism, index) -> {
                PreparedStatement statement = connection.prepareStatement(this.query);
                List arguments = this.evalContext.getArguments();
                for (int j = 0; j < this.parameterPositions.length; ++j) {
                    statement.setObject(j + 1, arguments.get(this.parameterPositions[j]));
                }
                try {
                    return statement.executeQuery();
                }
                catch (SQLException e) {
                    statement.close();
                    throw e;
                }
            }, (FunctionEx & Serializable)rs -> {
                int columnCount = rs.getMetaData().getColumnCount();
                Object[] row = new Object[columnCount];
                for (int j = 0; j < columnCount; ++j) {
                    Object value = rs.getObject(j + 1);
                    row[j] = this.convertValue(value);
                }
                return new JetSqlRow((SerializationService)this.evalContext.getSerializationService(), row);
            });
            processors.add(processor);
        }
        return processors;
    }

    private Object convertValue(Object value) {
        if (value instanceof Date) {
            return ((Date)value).toLocalDate();
        }
        if (value instanceof Time) {
            return ((Time)value).toLocalTime();
        }
        if (value instanceof Timestamp) {
            return ((Timestamp)value).toLocalDateTime();
        }
        return value;
    }

    @Nullable
    public List<Permission> permissions() {
        return Collections.singletonList(ConnectorPermission.jdbc((String)this.externalDataStoreRef, (String)"read"));
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.externalDataStoreRef);
        out.writeString(this.query);
        out.writeIntArray(this.parameterPositions);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.externalDataStoreRef = in.readString();
        this.query = in.readString();
        this.parameterPositions = in.readIntArray();
    }
}

