/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate.function;

import com.hazelcast.jet.sql.impl.aggregate.WindowUtils;
import com.hazelcast.jet.sql.impl.schema.HazelcastTableFunction;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandMetadata;
import com.hazelcast.org.apache.calcite.sql.type.SqlReturnTypeInference;

public abstract class HazelcastWindowTableFunction
extends HazelcastTableFunction {
    private static final String WINDOW_START_FIELD_NAME = "window_start";
    private static final String WINDOW_END_FIELD_NAME = "window_end";

    protected HazelcastWindowTableFunction(SqlKind kind, SqlOperandMetadata operandMetadata, int orderingColumnIndex) {
        super(kind.name(), operandMetadata, HazelcastWindowTableFunction.returnTypeInference(orderingColumnIndex));
    }

    private static SqlReturnTypeInference returnTypeInference(int orderingColumnParameterIndex) {
        return binding -> {
            SqlCallBinding callBinding = (SqlCallBinding)binding;
            RelDataType orderingColumnType = WindowUtils.getOrderingColumnType(callBinding, orderingColumnParameterIndex);
            RelDataType inputRowType = callBinding.getValidator().getValidatedNodeType(callBinding.operand(0));
            return ((RelDataTypeFactory.FieldInfoBuilder)binding.getTypeFactory().builder().kind(inputRowType.getStructKind()).addAll(inputRowType.getFieldList())).add(WINDOW_START_FIELD_NAME, orderingColumnType).add(WINDOW_END_FIELD_NAME, orderingColumnType).build();
        };
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return ordinal != 0;
    }
}

