/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.SlidingWindowPolicy;
import com.hazelcast.jet.sql.impl.validate.ValidationUtil;
import com.hazelcast.jet.sql.impl.validate.ValidatorResource;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.util.Static;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.datetime.DateTimeUtils;
import com.hazelcast.sql.impl.row.EmptyRow;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.SqlDaySecondInterval;
import com.hazelcast.sql.impl.type.converter.AbstractTemporalConverter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;

public final class WindowUtils {
    private WindowUtils() {
    }

    public static JetSqlRow insertWindowBound(JetSqlRow row, long windowStart, long windowEnd, QueryDataType descriptorType, int[] mapping) {
        Object[] result = new Object[mapping.length];
        for (int i = 0; i < mapping.length; ++i) {
            result[i] = mapping[i] == -1 ? WindowUtils.convertWindowBound(windowStart, descriptorType) : (mapping[i] == -2 ? WindowUtils.convertWindowBound(windowEnd, descriptorType) : row.get(mapping[i]));
        }
        return new JetSqlRow(row.getSerializationService(), result);
    }

    public static Traverser<JetSqlRow> addWindowBounds(final JetSqlRow row, int timeStampIndex, final SlidingWindowPolicy windowPolicy) {
        final Object value = row.get(timeStampIndex);
        if (value == null) {
            return Traversers.singleton((Object)row.extendedRow(2));
        }
        long millis = WindowUtils.extractMillis(value);
        final long slideStep = windowPolicy.frameSize();
        final long firstWindowStart = windowPolicy.floorFrameTs(millis - windowPolicy.windowSize() + slideStep);
        return new Traverser<JetSqlRow>(){
            long currentStart;
            {
                this.currentStart = firstWindowStart;
            }

            public JetSqlRow next() {
                if (this.currentStart >= firstWindowStart + windowPolicy.windowSize()) {
                    return null;
                }
                try {
                    JetSqlRow jetSqlRow = WindowUtils.addWindowBoundsSingleRow(row, value, this.currentStart, this.currentStart + windowPolicy.windowSize());
                    return jetSqlRow;
                }
                finally {
                    this.currentStart += slideStep;
                }
            }
        };
    }

    private static Object convertWindowBound(long boundary, QueryDataType descriptorType) {
        if (descriptorType.getTypeFamily().isTemporal()) {
            return descriptorType.convert((Object)DateTimeUtils.asTimestampWithTimezone((long)boundary, (ZoneId)AbstractTemporalConverter.DEFAULT_ZONE));
        }
        return descriptorType.convert((Object)boundary);
    }

    private static JetSqlRow addWindowBoundsSingleRow(JetSqlRow row, Object timeStamp, long windowStart, long windowEnd) {
        Object[] result = Arrays.copyOf(row.getValues(), row.getFieldCount() + 2);
        if (timeStamp instanceof Byte) {
            result[result.length - 2] = (byte)windowStart;
            result[result.length - 1] = (byte)windowEnd;
        } else if (timeStamp instanceof Short) {
            result[result.length - 2] = (short)windowStart;
            result[result.length - 1] = (short)windowEnd;
        } else if (timeStamp instanceof Integer) {
            result[result.length - 2] = (int)windowStart;
            result[result.length - 1] = (int)windowEnd;
        } else if (timeStamp instanceof Long) {
            result[result.length - 2] = windowStart;
            result[result.length - 1] = windowEnd;
        } else if (timeStamp instanceof LocalTime) {
            result[result.length - 2] = DateTimeUtils.asTimestampWithTimezone((long)windowStart, (ZoneId)AbstractTemporalConverter.DEFAULT_ZONE).toLocalTime();
            result[result.length - 1] = DateTimeUtils.asTimestampWithTimezone((long)windowEnd, (ZoneId)AbstractTemporalConverter.DEFAULT_ZONE).toLocalTime();
        } else if (timeStamp instanceof LocalDate) {
            result[result.length - 2] = DateTimeUtils.asTimestampWithTimezone((long)windowStart, (ZoneId)AbstractTemporalConverter.DEFAULT_ZONE).toLocalDate();
            result[result.length - 1] = DateTimeUtils.asTimestampWithTimezone((long)windowEnd, (ZoneId)AbstractTemporalConverter.DEFAULT_ZONE).toLocalDate();
        } else if (timeStamp instanceof LocalDateTime) {
            result[result.length - 2] = DateTimeUtils.asTimestampWithTimezone((long)windowStart, (ZoneId)AbstractTemporalConverter.DEFAULT_ZONE).toLocalDateTime();
            result[result.length - 1] = DateTimeUtils.asTimestampWithTimezone((long)windowEnd, (ZoneId)AbstractTemporalConverter.DEFAULT_ZONE).toLocalDateTime();
        } else {
            result[result.length - 2] = DateTimeUtils.asTimestampWithTimezone((long)windowStart, (ZoneId)AbstractTemporalConverter.DEFAULT_ZONE);
            result[result.length - 1] = DateTimeUtils.asTimestampWithTimezone((long)windowEnd, (ZoneId)AbstractTemporalConverter.DEFAULT_ZONE);
        }
        return new JetSqlRow(row.getSerializationService(), result);
    }

    public static long extractMillis(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof LocalTime) {
            return QueryDataType.TIME.getConverter().asTimestampWithTimezone(value).toInstant().toEpochMilli();
        }
        if (value instanceof LocalDate) {
            return QueryDataType.DATE.getConverter().asTimestampWithTimezone(value).toInstant().toEpochMilli();
        }
        if (value instanceof LocalDateTime) {
            return QueryDataType.TIMESTAMP.getConverter().asTimestampWithTimezone(value).toInstant().toEpochMilli();
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).toInstant().toEpochMilli();
        }
        return value.hashCode();
    }

    public static long extractMillis(Expression<?> expression, ExpressionEvalContext evalContext) {
        Object lag = expression.eval((Row)EmptyRow.INSTANCE, evalContext);
        return lag instanceof Number ? ((Number)lag).longValue() : ((SqlDaySecondInterval)lag).getMillis();
    }

    public static RelDataType getOrderingColumnType(SqlCallBinding binding, int orderingColumnParameterIndex) {
        SqlNode input = binding.operand(0);
        SqlCall descriptor = (SqlCall)ValidationUtil.unwrapFunctionOperand(binding.operand(orderingColumnParameterIndex));
        List<SqlNode> columnIdentifiers = descriptor.getOperandList();
        if (columnIdentifiers.size() != 1) {
            throw SqlUtil.newContextException(descriptor.getParserPosition(), ValidatorResource.RESOURCE.mustUseSingleOrderingColumn());
        }
        SqlIdentifier orderingColumnIdentifier = (SqlIdentifier)descriptor.getOperandList().get(0);
        String orderingColumnName = orderingColumnIdentifier.getSimple();
        SqlValidator validator = binding.getValidator();
        RelDataTypeField columnField = validator.getValidatedNodeType(input).getField(orderingColumnName, validator.getCatalogReader().nameMatcher().isCaseSensitive(), false);
        if (columnField == null) {
            throw SqlUtil.newContextException(descriptor.getParserPosition(), Static.RESOURCE.unknownIdentifier(orderingColumnName));
        }
        return columnField.getType();
    }
}

