/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.jet.sql.impl.aggregate.SqlAggregation;
import com.hazelcast.jet.sql.impl.expression.json.JsonCreationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class UnorderedJsonArrayAggAggregation
implements SqlAggregation {
    private final ArrayList<Object> values = new ArrayList();
    private boolean isAbsentOnNull;

    private UnorderedJsonArrayAggAggregation() {
    }

    private UnorderedJsonArrayAggAggregation(boolean isAbsentOnNull) {
        this.isAbsentOnNull = isAbsentOnNull;
    }

    public static UnorderedJsonArrayAggAggregation create(boolean isAbsentOnNull) {
        return new UnorderedJsonArrayAggAggregation(isAbsentOnNull);
    }

    @Override
    public void accumulate(Object value) {
        this.values.add(value);
    }

    @Override
    public void combine(SqlAggregation other) {
        UnorderedJsonArrayAggAggregation other0 = (UnorderedJsonArrayAggAggregation)other;
        this.values.addAll(other0.values);
    }

    @Override
    public Object collect() {
        StringBuilder sb = new StringBuilder();
        boolean firstValue = true;
        sb.append("[");
        for (Object value : this.values) {
            if (value == null) {
                if (this.isAbsentOnNull) continue;
                if (!firstValue) {
                    sb.append(",");
                }
                sb.append("null");
                firstValue = false;
                continue;
            }
            if (!firstValue) {
                sb.append(",");
            }
            sb.append(JsonCreationUtil.serializeValue(value));
            firstValue = false;
        }
        sb.append("]");
        if (firstValue) {
            return null;
        }
        return new HazelcastJsonValue(sb.toString());
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.isAbsentOnNull);
        out.writeInt(this.values.size());
        for (Object o : this.values) {
            out.writeObject(o);
        }
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.isAbsentOnNull = in.readBoolean();
        int size = in.readInt();
        this.values.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            this.values.add(in.readObject());
        }
    }
}

