/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.esri.core.geometry;

import com.hazelcast.com.esri.core.geometry.AttributeStreamOfInt32;
import com.hazelcast.com.esri.core.geometry.GeometryException;

final class WktParser {
    private String m_wkt_string;
    private int m_start_token;
    private int m_end_token;
    private int m_current_token_type;
    private boolean m_b_has_zs;
    private boolean m_b_has_ms;
    private boolean m_b_check_consistent_attributes;
    private boolean m_b_nan;
    private AttributeStreamOfInt32 m_function_stack;

    WktParser() {
    }

    WktParser(String string) {
        this.resetParser(string);
    }

    void resetParser(String string) {
        if (this.m_function_stack == null) {
            this.m_function_stack = new AttributeStreamOfInt32(0);
        }
        this.reset_();
        this.m_wkt_string = string;
    }

    int nextToken() {
        switch (this.m_function_stack.getLast()) {
            case 0: {
                this.xLiteral_();
                break;
            }
            case 1: {
                this.yLiteral_();
                break;
            }
            case 2: {
                this.zLiteral_();
                break;
            }
            case 3: {
                this.mLiteral_();
                break;
            }
            case 4: {
                this.pointStart_();
                break;
            }
            case 5: {
                this.pointStartAlt_();
                break;
            }
            case 6: {
                this.pointEnd_();
                break;
            }
            case 7: {
                this.lineStringStart_();
                break;
            }
            case 8: {
                this.lineStringEnd_();
                break;
            }
            case 9: {
                this.multiPointStart_();
                break;
            }
            case 10: {
                this.multiPointEnd_();
                break;
            }
            case 11: {
                this.polygonStart_();
                break;
            }
            case 12: {
                this.polygonEnd_();
                break;
            }
            case 13: {
                this.multiLineStringStart_();
                break;
            }
            case 14: {
                this.multiLineStringEnd_();
                break;
            }
            case 15: {
                this.multiPolygonStart_();
                break;
            }
            case 16: {
                this.multiPolygonEnd_();
                break;
            }
            case 17: {
                this.geometryCollectionStart_();
                break;
            }
            case 18: {
                this.geometryCollectionEnd_();
                break;
            }
            case 19: {
                this.accept_();
                break;
            }
            case 20: {
                this.geometry_();
                break;
            }
            case 21: {
                this.attributes_();
            }
        }
        return this.m_current_token_type;
    }

    double currentNumericLiteral() {
        if ((this.m_current_token_type & 0xF0000000) == 0) {
            throw new GeometryException("runtime error");
        }
        if (this.m_b_nan) {
            return Double.NaN;
        }
        double value = Double.parseDouble(this.m_wkt_string.substring(this.m_start_token, this.m_end_token));
        return value;
    }

    int currentToken() {
        return this.m_current_token_type;
    }

    boolean hasZs() {
        return this.m_b_has_zs;
    }

    boolean hasMs() {
        return this.m_b_has_ms;
    }

    private void reset_() {
        this.m_function_stack.add(19);
        this.m_function_stack.add(20);
        this.m_start_token = -1;
        this.m_end_token = 0;
        this.m_current_token_type = 0;
        this.m_b_has_zs = false;
        this.m_b_has_ms = false;
        this.m_b_check_consistent_attributes = false;
        this.m_b_nan = false;
    }

    private void accept_() {
        this.m_start_token = this.m_end_token;
        this.m_current_token_type = 0;
    }

    private void geometry_() {
        this.skipWhiteSpace_();
        this.m_start_token = this.m_end_token;
        this.m_function_stack.removeLast();
        if (this.m_start_token + 5 <= this.m_wkt_string.length() && this.m_wkt_string.regionMatches(true, this.m_start_token, "point", 0, 5)) {
            this.m_end_token = this.m_start_token + 5;
            this.m_current_token_type = 1;
            this.m_function_stack.add(4);
        } else if (this.m_start_token + 10 <= this.m_wkt_string.length() && this.m_wkt_string.regionMatches(true, this.m_start_token, "linestring", 0, 10)) {
            this.m_end_token = this.m_start_token + 10;
            this.m_current_token_type = 2;
            this.m_function_stack.add(7);
        } else if (this.m_start_token + 10 <= this.m_wkt_string.length() && this.m_wkt_string.regionMatches(true, this.m_start_token, "multipoint", 0, 10)) {
            this.m_end_token = this.m_start_token + 10;
            this.m_current_token_type = 4;
            this.m_function_stack.add(9);
        } else if (this.m_start_token + 7 <= this.m_wkt_string.length() && this.m_wkt_string.regionMatches(true, this.m_start_token, "polygon", 0, 7)) {
            this.m_end_token = this.m_start_token + 7;
            this.m_current_token_type = 3;
            this.m_function_stack.add(11);
        } else if (this.m_start_token + 15 <= this.m_wkt_string.length() && this.m_wkt_string.regionMatches(true, this.m_start_token, "multilinestring", 0, 15)) {
            this.m_end_token = this.m_start_token + 15;
            this.m_current_token_type = 5;
            this.m_function_stack.add(13);
        } else if (this.m_start_token + 12 <= this.m_wkt_string.length() && this.m_wkt_string.regionMatches(true, this.m_start_token, "multipolygon", 0, 12)) {
            this.m_end_token = this.m_start_token + 12;
            this.m_current_token_type = 6;
            this.m_function_stack.add(15);
        } else if (this.m_start_token + 18 <= this.m_wkt_string.length() && this.m_wkt_string.regionMatches(true, this.m_start_token, "geometrycollection", 0, 18)) {
            this.m_end_token = this.m_start_token + 18;
            this.m_current_token_type = 7;
            this.m_function_stack.add(17);
        } else {
            throw new IllegalArgumentException("Could not parse Well-Known Text around position: " + this.m_end_token);
        }
        this.m_function_stack.add(21);
    }

    private void attributes_() {
        this.skipWhiteSpace_();
        this.m_start_token = this.m_end_token;
        this.m_function_stack.removeLast();
        boolean b_has_zs = false;
        boolean b_has_ms = false;
        if (this.m_wkt_string.charAt(this.m_end_token) == 'z' || this.m_wkt_string.charAt(this.m_end_token) == 'Z') {
            b_has_zs = true;
            if (++this.m_end_token >= this.m_wkt_string.length()) {
                throw new IllegalArgumentException();
            }
        }
        if (this.m_wkt_string.charAt(this.m_end_token) == 'm' || this.m_wkt_string.charAt(this.m_end_token) == 'M') {
            b_has_ms = true;
            if (++this.m_end_token >= this.m_wkt_string.length()) {
                throw new IllegalArgumentException();
            }
        }
        if (this.m_b_check_consistent_attributes && (b_has_zs != this.m_b_has_zs || b_has_ms != this.m_b_has_ms)) {
            throw new IllegalArgumentException();
        }
        this.m_b_has_zs = b_has_zs;
        this.m_b_has_ms = b_has_ms;
        if (this.m_b_has_zs || this.m_b_has_ms) {
            this.m_current_token_type = this.m_b_has_zs && !this.m_b_has_ms ? 1000 : (this.m_b_has_ms && !this.m_b_has_zs ? 2000 : 3000);
        } else {
            this.nextToken();
        }
    }

    private void geometryCollectionStart_() {
        this.skipWhiteSpace_();
        this.m_start_token = this.m_end_token;
        this.m_b_check_consistent_attributes = true;
        if (this.empty_()) {
            this.m_function_stack.removeLast();
        } else if (this.leftParen_()) {
            this.m_function_stack.removeLast();
            this.m_function_stack.add(18);
            this.m_function_stack.add(20);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void geometryCollectionEnd_() {
        this.skipWhiteSpace_();
        this.m_start_token = this.m_end_token;
        if (this.comma_()) {
            this.m_function_stack.add(20);
            this.geometry_();
        } else if (this.rightParen_()) {
            this.m_function_stack.removeLast();
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void multiPolygonStart_() {
        this.skipWhiteSpace_();
        this.m_start_token = this.m_end_token;
        if (this.empty_()) {
            this.m_function_stack.removeLast();
        } else if (this.leftParen_()) {
            this.m_function_stack.removeLast();
            this.m_function_stack.add(16);
            this.m_function_stack.add(11);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void multiPolygonEnd_() {
        this.skipWhiteSpace_();
        this.m_start_token = this.m_end_token;
        if (this.comma_()) {
            this.m_function_stack.add(11);
            this.polygonStart_();
        } else if (this.rightParen_()) {
            this.m_function_stack.removeLast();
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void multiLineStringStart_() {
        this.skipWhiteSpace_();
        this.m_start_token = this.m_end_token;
        if (this.empty_()) {
            this.m_function_stack.removeLast();
        } else if (this.leftParen_()) {
            this.m_function_stack.removeLast();
            this.m_function_stack.add(14);
            this.m_function_stack.add(7);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void multiLineStringEnd_() {
        this.skipWhiteSpace_();
        this.m_start_token = this.m_end_token;
        if (this.comma_()) {
            this.m_function_stack.add(7);
            this.lineStringStart_();
        } else if (this.rightParen_()) {
            this.m_function_stack.removeLast();
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void multiPointStart_() {
        this.skipWhiteSpace_();
        this.m_start_token = this.m_end_token;
        if (this.empty_()) {
            this.m_function_stack.removeLast();
        } else if (this.leftParen_()) {
            this.m_function_stack.removeLast();
            this.m_function_stack.add(10);
            this.m_function_stack.add(5);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void multiPointEnd_() {
        this.skipWhiteSpace_();
        this.m_start_token = this.m_end_token;
        if (this.comma_()) {
            this.m_function_stack.add(4);
            this.pointStart_();
        } else if (this.rightParen_()) {
            this.m_function_stack.removeLast();
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void polygonStart_() {
        this.skipWhiteSpace_();
        this.m_start_token = this.m_end_token;
        if (this.empty_()) {
            this.m_function_stack.removeLast();
        } else if (this.leftParen_()) {
            this.m_function_stack.removeLast();
            this.m_function_stack.add(12);
            this.m_function_stack.add(7);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void polygonEnd_() {
        this.skipWhiteSpace_();
        this.m_start_token = this.m_end_token;
        if (this.comma_()) {
            this.m_function_stack.add(7);
            this.lineStringStart_();
        } else if (this.rightParen_()) {
            this.m_function_stack.removeLast();
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void lineStringStart_() {
        this.skipWhiteSpace_();
        this.m_start_token = this.m_end_token;
        if (this.empty_()) {
            this.m_function_stack.removeLast();
        } else if (this.leftParen_()) {
            this.m_function_stack.removeLast();
            this.m_function_stack.add(8);
            this.m_function_stack.add(0);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void lineStringEnd_() {
        this.skipWhiteSpace_();
        this.m_start_token = this.m_end_token;
        if (this.comma_()) {
            this.m_function_stack.add(0);
            this.xLiteral_();
        } else if (this.rightParen_()) {
            this.m_function_stack.removeLast();
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void pointStart_() {
        this.skipWhiteSpace_();
        this.m_start_token = this.m_end_token;
        if (this.empty_()) {
            this.m_function_stack.removeLast();
        } else if (this.leftParen_()) {
            this.m_function_stack.removeLast();
            this.m_function_stack.add(6);
            this.m_function_stack.add(0);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void pointStartAlt_() {
        this.skipWhiteSpace_();
        this.m_start_token = this.m_end_token;
        if (this.empty_()) {
            this.m_function_stack.removeLast();
        } else if (this.leftParen_()) {
            this.m_function_stack.removeLast();
            this.m_function_stack.add(6);
            this.m_function_stack.add(0);
        } else {
            this.m_function_stack.removeLast();
            this.m_function_stack.removeLast();
            this.m_function_stack.add(8);
            this.m_function_stack.add(0);
            this.nextToken();
        }
    }

    private void pointEnd_() {
        this.skipWhiteSpace_();
        this.m_start_token = this.m_end_token;
        if (!this.rightParen_()) {
            throw new IllegalArgumentException();
        }
        this.m_function_stack.removeLast();
    }

    private void xLiteral_() {
        this.signedNumericLiteral_();
        this.m_current_token_type = Integer.MIN_VALUE;
        this.m_function_stack.removeLast();
        this.m_function_stack.add(1);
    }

    private void yLiteral_() {
        this.signedNumericLiteral_();
        this.m_current_token_type = 0x40000000;
        this.m_function_stack.removeLast();
        if (this.m_b_has_zs) {
            this.m_function_stack.add(2);
        } else if (this.m_b_has_ms) {
            this.m_function_stack.add(3);
        }
    }

    private void zLiteral_() {
        this.signedNumericLiteral_();
        this.m_current_token_type = 0x20000000;
        this.m_function_stack.removeLast();
        if (this.m_b_has_ms) {
            this.m_function_stack.add(3);
        }
    }

    private void mLiteral_() {
        this.signedNumericLiteral_();
        this.m_current_token_type = 0x10000000;
        this.m_function_stack.removeLast();
    }

    private boolean nan_() {
        if (this.m_wkt_string.regionMatches(true, this.m_start_token, "nan", 0, 3)) {
            this.m_end_token += 3;
            this.m_b_nan = true;
            return true;
        }
        this.m_b_nan = false;
        return false;
    }

    private void sign_() {
        if ((this.m_wkt_string.charAt(this.m_end_token) == '-' || this.m_wkt_string.charAt(this.m_end_token) == '+') && ++this.m_end_token >= this.m_wkt_string.length()) {
            throw new IllegalArgumentException();
        }
    }

    private void signedNumericLiteral_() {
        this.skipWhiteSpace_();
        this.m_start_token = this.m_end_token;
        if (this.nan_()) {
            return;
        }
        this.sign_();
        this.unsignedNumericLiteral_();
    }

    private void unsignedNumericLiteral_() {
        this.exactNumericLiteral_();
        this.exp_();
    }

    private void exactNumericLiteral_() {
        if (Character.isDigit(this.m_wkt_string.charAt(this.m_end_token))) {
            this.digits_();
            if (this.m_wkt_string.charAt(this.m_end_token) == '.') {
                if (++this.m_end_token >= this.m_wkt_string.length()) {
                    throw new IllegalArgumentException();
                }
                if (Character.isDigit(this.m_wkt_string.charAt(this.m_end_token))) {
                    this.digits_();
                }
            }
        } else if (this.m_wkt_string.charAt(this.m_end_token) == '.') {
            if (++this.m_end_token >= this.m_wkt_string.length()) {
                throw new IllegalArgumentException();
            }
            if (!Character.isDigit(this.m_wkt_string.charAt(this.m_end_token))) {
                throw new IllegalArgumentException();
            }
            this.digits_();
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void digits_() {
        do {
            if (++this.m_end_token < this.m_wkt_string.length()) continue;
            throw new IllegalArgumentException();
        } while (Character.isDigit(this.m_wkt_string.charAt(this.m_end_token)));
    }

    private void exp_() {
        if (this.m_wkt_string.charAt(this.m_end_token) == 'e' || this.m_wkt_string.charAt(this.m_end_token) == 'E') {
            if (++this.m_end_token >= this.m_wkt_string.length()) {
                throw new IllegalArgumentException();
            }
            this.sign_();
            if (!Character.isDigit(this.m_wkt_string.charAt(this.m_end_token))) {
                throw new IllegalArgumentException();
            }
            this.digits_();
        }
    }

    private void skipWhiteSpace_() {
        if (this.m_end_token >= this.m_wkt_string.length()) {
            throw new IllegalArgumentException();
        }
        while (Character.isWhitespace(this.m_wkt_string.charAt(this.m_end_token))) {
            if (++this.m_end_token < this.m_wkt_string.length()) continue;
            throw new IllegalArgumentException();
        }
    }

    private boolean empty_() {
        if (this.m_wkt_string.regionMatches(true, this.m_start_token, "empty", 0, 5)) {
            this.m_end_token += 5;
            this.m_current_token_type = 50;
            return true;
        }
        return false;
    }

    private boolean comma_() {
        if (this.m_wkt_string.charAt(this.m_end_token) == ',') {
            ++this.m_end_token;
            return true;
        }
        return false;
    }

    private boolean leftParen_() {
        if (this.m_wkt_string.charAt(this.m_end_token) == '(') {
            ++this.m_end_token;
            this.m_current_token_type = 51;
            return true;
        }
        return false;
    }

    private boolean rightParen_() {
        if (this.m_wkt_string.charAt(this.m_end_token) == ')') {
            ++this.m_end_token;
            this.m_current_token_type = 52;
            return true;
        }
        return false;
    }

    private static interface Number {
        public static final int signed_numeric_literal = -268435456;
    }

    private static interface State {
        public static final int xLiteral = 0;
        public static final int yLiteral = 1;
        public static final int zLiteral = 2;
        public static final int mLiteral = 3;
        public static final int pointStart = 4;
        public static final int pointStartAlt = 5;
        public static final int pointEnd = 6;
        public static final int lineStringStart = 7;
        public static final int lineStringEnd = 8;
        public static final int multiPointStart = 9;
        public static final int multiPointEnd = 10;
        public static final int polygonStart = 11;
        public static final int polygonEnd = 12;
        public static final int multiLineStringStart = 13;
        public static final int multiLineStringEnd = 14;
        public static final int multiPolygonStart = 15;
        public static final int multiPolygonEnd = 16;
        public static final int geometryCollectionStart = 17;
        public static final int geometryCollectionEnd = 18;
        public static final int accept = 19;
        public static final int geometry = 20;
        public static final int attributes = 21;
    }

    static interface WktToken {
        public static final int not_available = 0;
        public static final int empty = 50;
        public static final int left_paren = 51;
        public static final int right_paren = 52;
        public static final int x_literal = Integer.MIN_VALUE;
        public static final int y_literal = 0x40000000;
        public static final int z_literal = 0x20000000;
        public static final int m_literal = 0x10000000;
        public static final int point = 1;
        public static final int linestring = 2;
        public static final int polygon = 3;
        public static final int multipoint = 4;
        public static final int multilinestring = 5;
        public static final int multipolygon = 6;
        public static final int geometrycollection = 7;
        public static final int attribute_z = 1000;
        public static final int attribute_m = 2000;
        public static final int attribute_zm = 3000;
    }
}

