/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kinesis.impl.source;

import com.hazelcast.com.amazonaws.SdkClientException;
import com.hazelcast.com.amazonaws.services.kinesis.AmazonKinesisAsync;
import com.hazelcast.com.amazonaws.services.kinesis.model.GetRecordsRequest;
import com.hazelcast.com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.hazelcast.com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.hazelcast.com.amazonaws.services.kinesis.model.GetShardIteratorResult;
import com.hazelcast.com.amazonaws.services.kinesis.model.ProvisionedThroughputExceededException;
import com.hazelcast.com.amazonaws.services.kinesis.model.Record;
import com.hazelcast.com.amazonaws.services.kinesis.model.Shard;
import com.hazelcast.com.amazonaws.services.kinesis.model.ShardIteratorType;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.util.counters.Counter;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.kinesis.impl.AbstractShardWorker;
import com.hazelcast.jet.kinesis.impl.KinesisUtil;
import com.hazelcast.jet.kinesis.impl.RandomizedRateTracker;
import com.hazelcast.jet.kinesis.impl.RetryTracker;
import com.hazelcast.jet.kinesis.impl.source.InitialShardIterators;
import com.hazelcast.jet.retry.RetryStrategy;
import com.hazelcast.logging.ILogger;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

class ShardReader
extends AbstractShardWorker
implements DynamicMetricsProvider {
    private static final int GET_RECORD_OPS_PER_SECOND = 5;
    private static final int SLEEP_ON_THROUGHPUT_EXCEEDED_MS = 200;
    private final Shard shard;
    private final RandomizedRateTracker getRecordsRateTracker = new RandomizedRateTracker(1000L, 5);
    @Probe(name="millisBehindLatest")
    private final Counter millisBehindLatestMetric = SwCounter.newSwCounter((long)-1L);
    private final RetryTracker getShardIteratorRetryTracker;
    private final RetryTracker readRecordRetryTracker;
    private final InitialShardIterators initialShardIterators;
    private State state = State.NO_SHARD_ITERATOR;
    private String shardIterator;
    private Future<GetShardIteratorResult> shardIteratorResult;
    private long nextGetShardIteratorTime = System.nanoTime();
    private Future<GetRecordsResult> recordsResult;
    private long nextGetRecordsTime = System.nanoTime();
    private List<Record> data = Collections.emptyList();
    private String lastSeenSeqNo;

    ShardReader(AmazonKinesisAsync kinesis, String stream, Shard shard, String lastSeenSeqNo, RetryStrategy retryStrategy, InitialShardIterators initialShardIterators, ILogger logger) {
        super(kinesis, stream, logger);
        this.shard = shard;
        this.lastSeenSeqNo = lastSeenSeqNo;
        this.readRecordRetryTracker = new RetryTracker(retryStrategy);
        this.getShardIteratorRetryTracker = new RetryTracker(retryStrategy);
        this.initialShardIterators = initialShardIterators;
    }

    public Result probe(long currentTime) {
        switch (this.state) {
            case NO_SHARD_ITERATOR: {
                return this.handleNoShardIterator(currentTime);
            }
            case WAITING_FOR_SHARD_ITERATOR: {
                return this.handleWaitingForShardIterator();
            }
            case NEED_TO_REQUEST_RECORDS: {
                return this.handleNeedToRequestRecords(currentTime);
            }
            case WAITING_FOR_RECORDS: {
                return this.handleWaitingForRecords();
            }
            case HAS_DATA_NEED_TO_REQUEST_RECORDS: {
                return this.handleHasDataNeedToRequestRecords(currentTime);
            }
            case HAS_DATA: {
                return this.handleHasData();
            }
            case SHARD_CLOSED: {
                return this.handleShardClosed();
            }
        }
        throw new JetException("Programming error, unhandled state: " + (Object)((Object)this.state));
    }

    private Result handleNoShardIterator(long currentTime) {
        if (this.attemptToSendGetShardIteratorRequest(currentTime)) {
            this.state = State.WAITING_FOR_SHARD_ITERATOR;
        }
        return Result.NOTHING;
    }

    private boolean attemptToSendGetShardIteratorRequest(long currentTime) {
        if (currentTime < this.nextGetShardIteratorTime) {
            return false;
        }
        GetShardIteratorRequest request = this.getShardIteratorRequest();
        this.shardIteratorResult = this.kinesis.getShardIteratorAsync(request);
        this.nextGetShardIteratorTime = currentTime;
        return true;
    }

    @Nonnull
    private GetShardIteratorRequest getShardIteratorRequest() {
        if (this.lastSeenSeqNo == null) {
            return this.initialShardIterators.request(this.streamName, this.shard);
        }
        GetShardIteratorRequest request = new GetShardIteratorRequest();
        request.setStreamName(this.streamName);
        request.setShardId(this.shard.getShardId());
        request.setShardIteratorType(ShardIteratorType.AFTER_SEQUENCE_NUMBER);
        request.setStartingSequenceNumber(this.lastSeenSeqNo);
        return request;
    }

    private Result handleWaitingForShardIterator() {
        if (this.shardIteratorResult.isDone()) {
            try {
                this.shardIterator = KinesisUtil.readResult(this.shardIteratorResult).getShardIterator();
            }
            catch (SdkClientException sce) {
                return this.dealWithGetShardIteratorFailure(sce);
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow((Throwable)t);
            }
            this.getShardIteratorRetryTracker.reset();
            this.state = State.NEED_TO_REQUEST_RECORDS;
        }
        return Result.NOTHING;
    }

    @Nonnull
    private Result dealWithGetShardIteratorFailure(Exception e) {
        this.getShardIteratorRetryTracker.attemptFailed();
        if (this.getShardIteratorRetryTracker.shouldTryAgain()) {
            long timeoutMillis = this.getShardIteratorRetryTracker.getNextWaitTimeMillis();
            this.logger.warning(String.format("Failed retrieving shard iterator, retrying in %d ms.Cause: %s", timeoutMillis, e.getMessage()));
            this.nextGetShardIteratorTime = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
            this.state = State.NO_SHARD_ITERATOR;
            return Result.NOTHING;
        }
        throw ExceptionUtil.rethrow((Throwable)e);
    }

    private Result handleNeedToRequestRecords(long currentTime) {
        if (this.attemptToSendGetRecordsRequest(currentTime)) {
            this.state = State.WAITING_FOR_RECORDS;
        }
        return Result.NOTHING;
    }

    private Result handleWaitingForRecords() {
        if (this.recordsResult.isDone()) {
            GetRecordsResult result;
            try {
                result = KinesisUtil.readResult(this.recordsResult);
            }
            catch (ProvisionedThroughputExceededException pte) {
                return this.dealWithThroughputExceeded();
            }
            catch (SdkClientException sce) {
                return this.dealWithReadRecordFailure(sce);
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow((Throwable)t);
            }
            this.readRecordRetryTracker.reset();
            this.shardIterator = result.getNextShardIterator();
            this.data = result.getRecords();
            if (!this.data.isEmpty()) {
                this.lastSeenSeqNo = this.data.get(this.data.size() - 1).getSequenceNumber();
                this.millisBehindLatestMetric.set(result.getMillisBehindLatest().longValue());
            }
            if (this.shardIterator == null) {
                this.state = State.SHARD_CLOSED;
                return this.data.isEmpty() ? Result.CLOSED : Result.HAS_DATA;
            }
            if (!this.data.isEmpty()) {
                this.state = State.HAS_DATA_NEED_TO_REQUEST_RECORDS;
                return Result.HAS_DATA;
            }
            this.state = State.NEED_TO_REQUEST_RECORDS;
            return Result.NOTHING;
        }
        return Result.NOTHING;
    }

    private Result dealWithThroughputExceeded() {
        long timeoutMillis = 200L;
        this.logger.warning(String.format("Data throughput rate exceeded. Backing off and retrying in %d ms.", timeoutMillis));
        this.updateGetNextRecordsTime(System.nanoTime(), TimeUnit.MILLISECONDS.toNanos(timeoutMillis));
        this.state = State.NEED_TO_REQUEST_RECORDS;
        return Result.NOTHING;
    }

    private Result dealWithReadRecordFailure(Exception e) {
        this.readRecordRetryTracker.attemptFailed();
        if (this.readRecordRetryTracker.shouldTryAgain()) {
            long timeoutMillis = this.readRecordRetryTracker.getNextWaitTimeMillis();
            this.logger.warning(String.format("Failed reading records, retrying in %d. Cause: %s", timeoutMillis, e.getMessage()));
            this.updateGetNextRecordsTime(System.nanoTime(), TimeUnit.MILLISECONDS.toNanos(timeoutMillis));
            this.state = State.NEED_TO_REQUEST_RECORDS;
            return Result.NOTHING;
        }
        throw ExceptionUtil.rethrow((Throwable)e);
    }

    private Result handleHasDataNeedToRequestRecords(long currentTime) {
        if (this.attemptToSendGetRecordsRequest(currentTime)) {
            this.state = this.data.isEmpty() ? State.WAITING_FOR_RECORDS : State.HAS_DATA;
        }
        return this.data.isEmpty() ? Result.NOTHING : Result.HAS_DATA;
    }

    private Result handleHasData() {
        this.state = this.data.isEmpty() ? State.WAITING_FOR_RECORDS : State.HAS_DATA;
        return this.data.isEmpty() ? Result.NOTHING : Result.HAS_DATA;
    }

    private Result handleShardClosed() {
        return this.data.isEmpty() ? Result.CLOSED : Result.HAS_DATA;
    }

    private boolean attemptToSendGetRecordsRequest(long currentTime) {
        if (currentTime < this.nextGetRecordsTime) {
            return false;
        }
        this.recordsResult = this.getRecordsAsync(this.shardIterator);
        this.updateGetNextRecordsTime(currentTime, 0L);
        return true;
    }

    private Future<GetRecordsResult> getRecordsAsync(String shardIterator) {
        GetRecordsRequest request = new GetRecordsRequest();
        request.setShardIterator(shardIterator);
        return this.kinesis.getRecordsAsync(request);
    }

    public Shard getShard() {
        return this.shard;
    }

    public String getLastSeenSeqNo() {
        return this.lastSeenSeqNo;
    }

    public Traverser<Record> clearData() {
        if (this.data.isEmpty()) {
            throw new IllegalStateException("Can't ask for data when none is available");
        }
        Traverser traverser = Traversers.traverseIterable(this.data);
        this.data = Collections.emptyList();
        return traverser;
    }

    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        descriptor = descriptor.withTag("shard", this.shard.getShardId());
        context.collect(descriptor, (Object)this);
    }

    private void updateGetNextRecordsTime(long currentTime, long minimumIncrease) {
        this.nextGetRecordsTime = currentTime + Math.max(minimumIncrease, this.getRecordsRateTracker.next());
    }

    private static enum State {
        NO_SHARD_ITERATOR,
        WAITING_FOR_SHARD_ITERATOR,
        NEED_TO_REQUEST_RECORDS,
        WAITING_FOR_RECORDS,
        HAS_DATA_NEED_TO_REQUEST_RECORDS,
        HAS_DATA,
        SHARD_CLOSED;

    }

    static enum Result {
        NOTHING,
        HAS_DATA,
        CLOSED;

    }
}

