/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.amazonaws.services.kinesisfirehose.model.transform;

import com.hazelcast.com.amazonaws.SdkClientException;
import com.hazelcast.com.amazonaws.annotation.SdkInternalApi;
import com.hazelcast.com.amazonaws.protocol.MarshallLocation;
import com.hazelcast.com.amazonaws.protocol.MarshallingInfo;
import com.hazelcast.com.amazonaws.protocol.MarshallingType;
import com.hazelcast.com.amazonaws.protocol.ProtocolMarshaller;
import com.hazelcast.com.amazonaws.services.kinesisfirehose.model.VpcConfiguration;
import java.util.List;

@SdkInternalApi
public class VpcConfigurationMarshaller {
    private static final MarshallingInfo<List> SUBNETIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetIds").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").build();
    private static final MarshallingInfo<List> SECURITYGROUPIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroupIds").build();
    private static final VpcConfigurationMarshaller instance = new VpcConfigurationMarshaller();

    public static VpcConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(VpcConfiguration vpcConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (vpcConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(vpcConfiguration.getSubnetIds(), SUBNETIDS_BINDING);
            protocolMarshaller.marshall(vpcConfiguration.getRoleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall(vpcConfiguration.getSecurityGroupIds(), SECURITYGROUPIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

