/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.amazonaws.services.kinesisfirehose.model.transform;

import com.hazelcast.com.amazonaws.SdkClientException;
import com.hazelcast.com.amazonaws.annotation.SdkInternalApi;
import com.hazelcast.com.amazonaws.protocol.MarshallLocation;
import com.hazelcast.com.amazonaws.protocol.MarshallingInfo;
import com.hazelcast.com.amazonaws.protocol.MarshallingType;
import com.hazelcast.com.amazonaws.protocol.ProtocolMarshaller;
import com.hazelcast.com.amazonaws.services.kinesisfirehose.model.Processor;
import java.util.List;

@SdkInternalApi
public class ProcessorMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<List> PARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final ProcessorMarshaller instance = new ProcessorMarshaller();

    public static ProcessorMarshaller getInstance() {
        return instance;
    }

    public void marshall(Processor processor, ProtocolMarshaller protocolMarshaller) {
        if (processor == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(processor.getType(), TYPE_BINDING);
            protocolMarshaller.marshall(processor.getParameters(), PARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

