/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.amazonaws.auth.presign;

import com.hazelcast.com.amazonaws.AmazonWebServiceRequest;
import com.hazelcast.com.amazonaws.Request;
import com.hazelcast.com.amazonaws.annotation.Immutable;
import com.hazelcast.com.amazonaws.annotation.SdkProtectedApi;
import com.hazelcast.com.amazonaws.auth.AWSCredentialsProvider;
import com.hazelcast.com.amazonaws.auth.Presigner;
import com.hazelcast.com.amazonaws.auth.presign.PresignerParams;
import com.hazelcast.com.amazonaws.internal.auth.SignerProvider;
import com.hazelcast.com.amazonaws.internal.auth.SignerProviderContext;
import com.hazelcast.com.amazonaws.util.CredentialUtils;
import com.hazelcast.com.amazonaws.util.RuntimeHttpUtils;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Immutable
@SdkProtectedApi
public final class PresignerFacade {
    private final AWSCredentialsProvider credentialsProvider;
    private final SignerProvider signerProvider;

    public PresignerFacade(PresignerParams presignerParams) {
        this.credentialsProvider = presignerParams.credentialsProvider();
        this.signerProvider = presignerParams.signerProvider();
    }

    public URL presign(Request<?> request, Date expirationDate) {
        Presigner presigner = (Presigner)((Object)this.signerProvider.getSigner(SignerProviderContext.builder().withIsRedirect(false).withRequest(request).withUri(request.getEndpoint()).build()));
        if (request.getOriginalRequest() != null) {
            this.addCustomQueryParams(request);
            this.addCustomHeaders(request);
        }
        AWSCredentialsProvider credentialsProvider = this.resolveCredentials(request);
        presigner.presignRequest(request, credentialsProvider.getCredentials(), expirationDate);
        return RuntimeHttpUtils.convertRequestToUrl(request, true, false);
    }

    private void addCustomQueryParams(Request<?> request) {
        Map<String, List<String>> queryParameters = request.getOriginalRequest().getCustomQueryParameters();
        if (queryParameters == null || queryParameters.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<String>> param : queryParameters.entrySet()) {
            request.addParameters(param.getKey(), param.getValue());
        }
    }

    private void addCustomHeaders(Request<?> request) {
        Map<String, String> headers = request.getOriginalRequest().getCustomRequestHeaders();
        if (headers == null || headers.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            request.addHeader(header.getKey(), header.getValue());
        }
    }

    private AWSCredentialsProvider resolveCredentials(Request<?> request) {
        return CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.credentialsProvider);
    }

    public static class PresigningRequest
    extends AmazonWebServiceRequest {
        public PresigningRequest withRequestCredentialsProvider(AWSCredentialsProvider credentialsProvider) {
            this.setRequestCredentialsProvider(credentialsProvider);
            return this;
        }
    }
}

