/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.type;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.linq4j.Ord;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.org.apache.calcite.util.Pair;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;

public class AssignableOperandTypeChecker
implements SqlOperandTypeChecker {
    private final List<RelDataType> paramTypes;
    private final @Nullable ImmutableList<String> paramNames;

    public AssignableOperandTypeChecker(List<RelDataType> paramTypes, @Nullable List<String> paramNames) {
        this.paramTypes = ImmutableList.copyOf(paramTypes);
        this.paramNames = paramNames == null ? null : ImmutableList.copyOf(paramNames);
    }

    @Override
    public boolean isOptional(int i) {
        return false;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(this.paramTypes.size());
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        List<SqlNode> operands = callBinding.getCall().getOperandList();
        for (Pair<RelDataType, SqlNode> pair : Pair.zip(this.paramTypes, operands)) {
            RelDataType argType = SqlTypeUtil.deriveType(callBinding, (SqlNode)pair.right);
            if (SqlTypeUtil.canAssignFrom((RelDataType)pair.left, argType)) continue;
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        return true;
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        StringBuilder sb = new StringBuilder();
        sb.append(opName);
        sb.append("(");
        for (Ord<RelDataType> paramType : Ord.zip(this.paramTypes)) {
            if (paramType.i > 0) {
                sb.append(", ");
            }
            if (this.paramNames != null) {
                sb.append((String)this.paramNames.get(paramType.i)).append(" => ");
            }
            sb.append("<");
            sb.append(((RelDataType)paramType.e).getFamily());
            sb.append(">");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }
}

