/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.core;

import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.BiRel;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.RelWriter;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.schema.TransientTable;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;
import java.util.Objects;

public abstract class RepeatUnion
extends BiRel {
    public final boolean all;
    public final int iterationLimit;
    protected final @Nullable RelOptTable transientTable;

    protected RepeatUnion(RelOptCluster cluster, RelTraitSet traitSet, RelNode seed, RelNode iterative, boolean all, int iterationLimit, @Nullable RelOptTable transientTable) {
        super(cluster, traitSet, seed, iterative);
        this.iterationLimit = iterationLimit;
        this.all = all;
        this.transientTable = transientTable;
        if (transientTable != null) {
            Objects.requireNonNull(transientTable.unwrap(TransientTable.class));
        }
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        double seedRowCount = mq.getRowCount(this.getSeedRel());
        if (this.iterationLimit == 0) {
            return seedRowCount;
        }
        return seedRowCount + mq.getRowCount(this.getIterativeRel()) * (double)(this.iterationLimit < 0 ? 10 : this.iterationLimit);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        if (this.iterationLimit >= 0) {
            pw.item("iterationLimit", this.iterationLimit);
        }
        return pw.item("all", this.all);
    }

    public RelNode getSeedRel() {
        return this.left;
    }

    public RelNode getIterativeRel() {
        return this.right;
    }

    public @Nullable RelOptTable getTransientTable() {
        return this.transientTable;
    }

    @Override
    protected RelDataType deriveRowType() {
        List<RelDataType> inputRowTypes = Util.transform(this.getInputs(), RelNode::getRowType);
        RelDataType rowType = this.getCluster().getTypeFactory().leastRestrictive(inputRowTypes);
        if (rowType == null) {
            throw new IllegalArgumentException("Cannot compute compatible row type for arguments: " + Util.sepList(inputRowTypes, ", "));
        }
        return rowType;
    }
}

