/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.adapter.enumerable;

import com.hazelcast.com.google.common.annotations.VisibleForTesting;
import com.hazelcast.com.google.common.collect.Collections2;
import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.com.google.common.collect.Iterables;
import com.hazelcast.org.apache.calcite.DataContext;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.hazelcast.org.apache.calcite.adapter.enumerable.JavaRelImplementor;
import com.hazelcast.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import com.hazelcast.org.apache.calcite.adapter.enumerable.PhysType;
import com.hazelcast.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import com.hazelcast.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import com.hazelcast.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import com.hazelcast.org.apache.calcite.linq4j.Enumerable;
import com.hazelcast.org.apache.calcite.linq4j.function.Function1;
import com.hazelcast.org.apache.calcite.linq4j.tree.BlockBuilder;
import com.hazelcast.org.apache.calcite.linq4j.tree.BlockStatement;
import com.hazelcast.org.apache.calcite.linq4j.tree.Blocks;
import com.hazelcast.org.apache.calcite.linq4j.tree.ClassDeclaration;
import com.hazelcast.org.apache.calcite.linq4j.tree.ConditionalStatement;
import com.hazelcast.org.apache.calcite.linq4j.tree.ConstantExpression;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.org.apache.calcite.linq4j.tree.ExpressionType;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.org.apache.calcite.linq4j.tree.FunctionExpression;
import com.hazelcast.org.apache.calcite.linq4j.tree.GotoStatement;
import com.hazelcast.org.apache.calcite.linq4j.tree.MemberDeclaration;
import com.hazelcast.org.apache.calcite.linq4j.tree.MethodCallExpression;
import com.hazelcast.org.apache.calcite.linq4j.tree.NewArrayExpression;
import com.hazelcast.org.apache.calcite.linq4j.tree.NewExpression;
import com.hazelcast.org.apache.calcite.linq4j.tree.ParameterExpression;
import com.hazelcast.org.apache.calcite.linq4j.tree.Primitive;
import com.hazelcast.org.apache.calcite.linq4j.tree.Statement;
import com.hazelcast.org.apache.calcite.linq4j.tree.Types;
import com.hazelcast.org.apache.calcite.linq4j.tree.UnaryExpression;
import com.hazelcast.org.apache.calcite.linq4j.tree.VisitorImpl;
import com.hazelcast.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.runtime.Bindable;
import com.hazelcast.org.apache.calcite.sql.SqlExplainLevel;
import com.hazelcast.org.apache.calcite.sql.validate.SqlConformance;
import com.hazelcast.org.apache.calcite.sql.validate.SqlConformanceEnum;
import com.hazelcast.org.apache.calcite.util.BuiltInMethod;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class EnumerableRelImplementor
extends JavaRelImplementor {
    public final Map<String, Object> map;
    private final Map<String, RexToLixTranslator.InputGetter> corrVars = new HashMap<String, RexToLixTranslator.InputGetter>();
    private final IdentityHashMap<Object, ParameterExpression> stashedParameters = new IdentityHashMap();
    protected final Function1<String, RexToLixTranslator.InputGetter> allCorrelateVariables = this::getCorrelVariableGetter;

    public EnumerableRelImplementor(RexBuilder rexBuilder, Map<String, Object> internalParameters) {
        super(rexBuilder);
        this.map = internalParameters;
    }

    public EnumerableRel.Result visitChild(EnumerableRel parent, int ordinal, EnumerableRel child, EnumerableRel.Prefer prefer) {
        if (parent != null) assert (child == parent.getInputs().get(ordinal));
        return child.implement(this, prefer);
    }

    public ClassDeclaration implementRoot(EnumerableRel rootRel, EnumerableRel.Prefer prefer) {
        EnumerableRel.Result result;
        try {
            result = rootRel.implement(this, prefer);
        }
        catch (RuntimeException e) {
            IllegalStateException ex = new IllegalStateException("Unable to implement " + RelOptUtil.toString(rootRel, SqlExplainLevel.ALL_ATTRIBUTES));
            ex.addSuppressed(e);
            throw ex;
        }
        switch (prefer) {
            case ARRAY: {
                if (result.physType.getFormat() != JavaRowFormat.ARRAY || rootRel.getRowType().getFieldCount() != 1) break;
                BlockBuilder bb = new BlockBuilder();
                Expression e = null;
                for (Statement statement : result.block.statements) {
                    if (statement instanceof GotoStatement) {
                        e = bb.append("v", Objects.requireNonNull(((GotoStatement)statement).expression, "expression"));
                        continue;
                    }
                    bb.add(statement);
                }
                if (e != null) {
                    bb.add(Expressions.return_(null, Expressions.call(null, BuiltInMethod.SLICE0.method, e)));
                }
                result = new EnumerableRel.Result(bb.toBlock(), result.physType, JavaRowFormat.SCALAR);
                break;
            }
        }
        ArrayList<MemberDeclaration> memberDeclarations = new ArrayList<MemberDeclaration>();
        new TypeRegistrar(memberDeclarations).go(result);
        Collection stashed = Collections2.transform(this.stashedParameters.values(), input -> Expressions.declare(16, input, (Expression)Expressions.convert_(Expressions.call((Expression)DataContext.ROOT, BuiltInMethod.DATA_CONTEXT_GET.method, Expressions.constant(input.name)), input.type)));
        BlockStatement block = Expressions.block(Iterables.concat(stashed, result.block.statements));
        memberDeclarations.add(Expressions.methodDecl(1, Enumerable.class, BuiltInMethod.BINDABLE_BIND.method.getName(), Expressions.list(DataContext.ROOT), block));
        memberDeclarations.add(Expressions.methodDecl(1, Class.class, BuiltInMethod.TYPED_GET_ELEMENT_TYPE.method.getName(), ImmutableList.of(), Blocks.toFunctionBlock(Expressions.return_(null, Expressions.constant(result.physType.getJavaRowType())))));
        return Expressions.classDecl(1, "Baz", null, Collections.singletonList(Bindable.class), memberDeclarations);
    }

    private static ClassDeclaration classDecl(JavaTypeFactoryImpl.SyntheticRecordType type) {
        ClassDeclaration classDeclaration = Expressions.classDecl(9, type.getName(), null, ImmutableList.of(Serializable.class), new ArrayList<MemberDeclaration>());
        for (Types.RecordField field : type.getRecordFields()) {
            classDeclaration.memberDeclarations.add(Expressions.fieldDecl(field.getModifiers(), Expressions.parameter(field.getType(), field.getName()), null));
        }
        BlockBuilder blockBuilder = new BlockBuilder();
        ArrayList parameters = new ArrayList();
        ParameterExpression thisParameter = Expressions.parameter(type, "this");
        classDeclaration.memberDeclarations.add(Expressions.constructorDecl(1, type, parameters, blockBuilder.toBlock()));
        BlockBuilder blockBuilder2 = new BlockBuilder();
        ParameterExpression thatParameter = Expressions.parameter(type, "that");
        ParameterExpression oParameter = Expressions.parameter(Object.class, "o");
        blockBuilder2.add(Expressions.ifThen(Expressions.equal(thisParameter, oParameter), Expressions.return_(null, Expressions.constant(true))));
        blockBuilder2.add(Expressions.ifThen(Expressions.not(Expressions.typeIs(oParameter, type)), Expressions.return_(null, Expressions.constant(false))));
        blockBuilder2.add(Expressions.declare(16, thatParameter, (Expression)Expressions.convert_(oParameter, type)));
        ArrayList<Expression> conditions = new ArrayList<Expression>();
        for (Types.RecordField field : type.getRecordFields()) {
            conditions.add(Primitive.is(field.getType()) ? Expressions.equal(Expressions.field((Expression)thisParameter, field.getName()), Expressions.field((Expression)thatParameter, field.getName())) : Expressions.call(BuiltInMethod.OBJECTS_EQUAL.method, Expressions.field((Expression)thisParameter, field.getName()), Expressions.field((Expression)thatParameter, field.getName())));
        }
        blockBuilder2.add(Expressions.return_(null, Expressions.foldAnd(conditions)));
        classDeclaration.memberDeclarations.add(Expressions.methodDecl(1, Boolean.TYPE, "equals", Collections.singletonList(oParameter), blockBuilder2.toBlock()));
        BlockBuilder blockBuilder3 = new BlockBuilder();
        ParameterExpression hParameter = Expressions.parameter(Integer.TYPE, "h");
        ConstantExpression constantZero = Expressions.constant(0);
        blockBuilder3.add(Expressions.declare(0, hParameter, (Expression)constantZero));
        for (Types.RecordField field : type.getRecordFields()) {
            Method method = BuiltInMethod.HASH.method;
            blockBuilder3.add(Expressions.statement(Expressions.assign(hParameter, Expressions.call(method.getDeclaringClass(), method.getName(), ImmutableList.of(hParameter, Expressions.field((Expression)thisParameter, field))))));
        }
        blockBuilder3.add(Expressions.return_(null, hParameter));
        classDeclaration.memberDeclarations.add(Expressions.methodDecl(1, Integer.TYPE, "hashCode", Collections.emptyList(), blockBuilder3.toBlock()));
        BlockBuilder blockBuilder4 = new BlockBuilder();
        ParameterExpression cParameter = Expressions.parameter(Integer.TYPE, "c");
        int mod = type.getRecordFields().size() == 1 ? 16 : 0;
        blockBuilder4.add(Expressions.declare(mod, cParameter, null));
        ConditionalStatement conditionalStatement = Expressions.ifThen(Expressions.notEqual(cParameter, constantZero), Expressions.return_(null, cParameter));
        for (Types.RecordField field : type.getRecordFields()) {
            MethodCallExpression compareCall;
            try {
                Method method = (field.nullable() ? BuiltInMethod.COMPARE_NULLS_LAST : BuiltInMethod.COMPARE).method;
                compareCall = Expressions.call(method.getDeclaringClass(), method.getName(), Expressions.field((Expression)thisParameter, field), Expressions.field((Expression)thatParameter, field));
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof NoSuchMethodException) continue;
                throw e;
            }
            blockBuilder4.add(Expressions.statement(Expressions.assign(cParameter, compareCall)));
            blockBuilder4.add(conditionalStatement);
        }
        blockBuilder4.add(Expressions.return_(null, constantZero));
        classDeclaration.memberDeclarations.add(Expressions.methodDecl(1, Integer.TYPE, "compareTo", Collections.singletonList(thatParameter), blockBuilder4.toBlock()));
        BlockBuilder blockBuilder5 = new BlockBuilder();
        Expression expression5 = null;
        for (Types.RecordField field : type.getRecordFields()) {
            expression5 = expression5 == null ? Expressions.constant("{" + field.getName() + "=") : Expressions.add(expression5, Expressions.constant(", " + field.getName() + "="));
            expression5 = Expressions.add(expression5, Expressions.field((Expression)thisParameter, field.getName()));
        }
        expression5 = expression5 == null ? Expressions.constant("{}") : Expressions.add(expression5, Expressions.constant("}"));
        blockBuilder5.add(Expressions.return_(null, expression5));
        classDeclaration.memberDeclarations.add(Expressions.methodDecl(1, String.class, "toString", Collections.emptyList(), blockBuilder5.toBlock()));
        return classDeclaration;
    }

    public <T> Expression stash(T input, Class<? super T> clazz) {
        if (input == null || input instanceof String || input instanceof Boolean || input instanceof Byte || input instanceof Short || input instanceof Integer || input instanceof Long || input instanceof Float || input instanceof Double) {
            return Expressions.constant(input, clazz);
        }
        ParameterExpression cached = this.stashedParameters.get(input);
        if (cached != null) {
            return cached;
        }
        String name = "v" + this.map.size() + "stashed";
        ParameterExpression x = Expressions.variable(clazz, name);
        this.map.put(name, input);
        this.stashedParameters.put(input, x);
        return x;
    }

    public void registerCorrelVariable(String name, ParameterExpression pe, BlockBuilder corrBlock, PhysType physType) {
        this.corrVars.put(name, (list, index, storageType) -> {
            Expression fieldReference = physType.fieldReference(pe, index, storageType);
            return corrBlock.append(name + "_" + index, fieldReference);
        });
    }

    public void clearCorrelVariable(String name) {
        assert (this.corrVars.containsKey(name)) : "Correlation variable " + name + " should be defined";
        this.corrVars.remove(name);
    }

    public RexToLixTranslator.InputGetter getCorrelVariableGetter(String name) {
        assert (this.corrVars.containsKey(name)) : "Correlation variable " + name + " should be defined";
        return this.corrVars.get(name);
    }

    public EnumerableRel.Result result(PhysType physType, BlockStatement block) {
        return new EnumerableRel.Result(block, physType, ((PhysTypeImpl)physType).format);
    }

    @Override
    public SqlConformance getConformance() {
        return (SqlConformance)this.map.getOrDefault("_conformance", SqlConformanceEnum.DEFAULT);
    }

    private static class TypeRegistrar {
        private final List<MemberDeclaration> memberDeclarations;
        private final Set<Type> seen = new HashSet<Type>();

        TypeRegistrar(List<MemberDeclaration> memberDeclarations) {
            this.memberDeclarations = memberDeclarations;
        }

        private void register(Type type) {
            if (!this.seen.add(type)) {
                return;
            }
            if (type instanceof JavaTypeFactoryImpl.SyntheticRecordType) {
                this.memberDeclarations.add(EnumerableRelImplementor.classDecl((JavaTypeFactoryImpl.SyntheticRecordType)type));
            }
            if (type instanceof ParameterizedType) {
                for (Type type1 : ((ParameterizedType)type).getActualTypeArguments()) {
                    this.register(type1);
                }
            }
        }

        public void go(EnumerableRel.Result result) {
            LinkedHashSet<Type> types = new LinkedHashSet<Type>();
            result.block.accept(new TypeFinder(types));
            types.add(result.physType.getJavaRowType());
            for (Type type : types) {
                this.register(type);
            }
        }
    }

    @VisibleForTesting
    static class TypeFinder
    extends VisitorImpl<Void> {
        private final Collection<Type> types;

        TypeFinder(Collection<Type> types) {
            this.types = types;
        }

        @Override
        public Void visit(NewExpression newExpression) {
            this.types.add(newExpression.type);
            return (Void)super.visit(newExpression);
        }

        @Override
        public Void visit(NewArrayExpression newArrayExpression) {
            Type componentType;
            Type type = newArrayExpression.type;
            while ((componentType = Types.getComponentType(type)) != null) {
                type = componentType;
            }
            this.types.add(type);
            return (Void)super.visit(newArrayExpression);
        }

        @Override
        public Void visit(ConstantExpression constantExpression) {
            Object value = constantExpression.value;
            if (value instanceof Type) {
                this.types.add((Type)value);
            }
            if (value == null) {
                Type type = constantExpression.getType();
                this.types.add(type);
            }
            return (Void)super.visit(constantExpression);
        }

        @Override
        public Void visit(FunctionExpression functionExpression) {
            List<ParameterExpression> list = functionExpression.parameterList;
            for (ParameterExpression pe : list) {
                this.types.add(pe.getType());
            }
            if (functionExpression.body == null) {
                return (Void)super.visit(functionExpression);
            }
            this.types.add(functionExpression.body.getType());
            return (Void)super.visit(functionExpression);
        }

        @Override
        public Void visit(UnaryExpression unaryExpression) {
            if (unaryExpression.nodeType == ExpressionType.Convert) {
                this.types.add(unaryExpression.getType());
            }
            return (Void)super.visit(unaryExpression);
        }
    }
}

