/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operators.predicate;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlValidator;
import com.hazelcast.jet.sql.impl.validate.operators.common.HazelcastInfixOperator;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.BetweenOperatorOperandTypeInference;
import com.hazelcast.jet.sql.impl.validate.param.NumericPrecedenceParameterConverter;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeComparability;
import com.hazelcast.org.apache.calcite.sql.SqlDynamicParam;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.fun.SqlBetweenOperator;
import com.hazelcast.org.apache.calcite.sql.type.ComparableOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.sql.impl.type.QueryDataType;

public final class HazelcastBetweenOperator
extends HazelcastInfixOperator {
    public static final HazelcastBetweenOperator BETWEEN_ASYMMETRIC;
    public static final HazelcastBetweenOperator NOT_BETWEEN_ASYMMETRIC;
    public static final HazelcastBetweenOperator BETWEEN_SYMMETRIC;
    public static final HazelcastBetweenOperator NOT_BETWEEN_SYMMETRIC;
    private static final String[] BETWEEN_NAMES;
    private static final String[] NOT_BETWEEN_NAMES;
    private static final String[] SYMMETRIC_BETWEEN_NAMES;
    private static final String[] SYMMETRIC_NOT_BETWEEN_NAMES;
    private static final int PRECEDENCE = 32;
    private static final int OPERANDS = 3;
    private final boolean negated;
    private final SqlBetweenOperator.Flag flag;

    HazelcastBetweenOperator(boolean negated, SqlBetweenOperator.Flag symmetricalFlag, String[] names) {
        super(names, SqlKind.BETWEEN, 32, ReturnTypes.BOOLEAN_NULLABLE, BetweenOperatorOperandTypeInference.INSTANCE, new ComparableOperandTypeChecker(3, RelDataTypeComparability.ALL, SqlOperandTypeChecker.Consistency.COMPARE));
        this.negated = negated;
        this.flag = symmetricalFlag;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(3);
    }

    @Override
    protected boolean checkOperandTypes(HazelcastCallBinding callBinding, boolean throwOnFailure) {
        assert (callBinding.getOperandCount() == 3);
        for (int i = 0; i < 3; ++i) {
            RelDataType type = callBinding.getOperandType(i);
            if (type.getComparability().ordinal() >= RelDataTypeComparability.ALL.ordinal()) continue;
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        HazelcastSqlValidator validator = callBinding.getValidator();
        RelDataType winningType = HazelcastTypeUtils.withHigherPrecedence(callBinding.getOperandType(0), HazelcastTypeUtils.withHigherPrecedence(callBinding.getOperandType(1), callBinding.getOperandType(2)));
        QueryDataType winnerQueryDataType = HazelcastTypeUtils.toHazelcastType(winningType);
        if (winnerQueryDataType.getTypeFamily().isNumeric()) {
            this.setNumericParameterConverter(validator, callBinding.getCall().getOperandList().get(1), winnerQueryDataType);
            this.setNumericParameterConverter(validator, callBinding.getCall().getOperandList().get(2), winnerQueryDataType);
        }
        return true;
    }

    public SqlBetweenOperator.Flag getFlag() {
        return this.flag;
    }

    public boolean isNegated() {
        return this.negated;
    }

    private void setNumericParameterConverter(HazelcastSqlValidator validator, SqlNode node, QueryDataType type) {
        if (node.getKind() == SqlKind.DYNAMIC_PARAM) {
            SqlDynamicParam node0 = (SqlDynamicParam)node;
            NumericPrecedenceParameterConverter converter = new NumericPrecedenceParameterConverter(node0.getIndex(), node.getParserPosition(), type);
            validator.setParameterConverter(node0.getIndex(), converter);
        }
    }

    static {
        BETWEEN_NAMES = new String[]{"BETWEEN ASYMMETRIC", "AND"};
        NOT_BETWEEN_NAMES = new String[]{"NOT BETWEEN ASYMMETRIC", "AND"};
        SYMMETRIC_BETWEEN_NAMES = new String[]{"BETWEEN SYMMETRIC", "AND"};
        SYMMETRIC_NOT_BETWEEN_NAMES = new String[]{"NOT BETWEEN SYMMETRIC", "AND"};
        BETWEEN_ASYMMETRIC = new HazelcastBetweenOperator(false, SqlBetweenOperator.Flag.ASYMMETRIC, BETWEEN_NAMES);
        NOT_BETWEEN_ASYMMETRIC = new HazelcastBetweenOperator(true, SqlBetweenOperator.Flag.ASYMMETRIC, NOT_BETWEEN_NAMES);
        BETWEEN_SYMMETRIC = new HazelcastBetweenOperator(false, SqlBetweenOperator.Flag.SYMMETRIC, SYMMETRIC_BETWEEN_NAMES);
        NOT_BETWEEN_SYMMETRIC = new HazelcastBetweenOperator(true, SqlBetweenOperator.Flag.SYMMETRIC, SYMMETRIC_NOT_BETWEEN_NAMES);
    }
}

