/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operators.misc;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.HazelcastResources;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlValidator;
import com.hazelcast.jet.sql.impl.validate.operators.common.HazelcastFunction;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.CoalesceOperandTypeInference;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.HazelcastReturnTypeInference;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlBasicCall;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import java.util.ArrayList;
import java.util.List;

public final class HazelcastCoalesceFunction
extends HazelcastFunction {
    public static final HazelcastCoalesceFunction INSTANCE = new HazelcastCoalesceFunction();

    private HazelcastCoalesceFunction() {
        super("COALESCE", SqlKind.COALESCE, HazelcastReturnTypeInference.wrap(ReturnTypes.ARG0_NULLABLE), CoalesceOperandTypeInference.INSTANCE, SqlFunctionCategory.SYSTEM);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.from(1);
    }

    @Override
    protected boolean checkOperandTypes(HazelcastCallBinding callBinding, boolean throwOnFailure) {
        HazelcastSqlValidator validator = callBinding.getValidator();
        SqlValidatorScope scope = callBinding.getScope();
        SqlBasicCall sqlCall = (SqlBasicCall)callBinding.getCall();
        List<SqlNode> operandList = sqlCall.getOperandList();
        ArrayList<RelDataType> argTypes = new ArrayList<RelDataType>(operandList.size());
        for (SqlNode node : operandList) {
            argTypes.add(validator.deriveType(scope, node));
        }
        assert (!argTypes.isEmpty());
        RelDataType returnType = (RelDataType)argTypes.stream().reduce(HazelcastTypeUtils::withHigherPrecedence).get();
        for (int i = 0; i < operandList.size(); ++i) {
            int finalI = i;
            boolean elementTypeCoerced = validator.getTypeCoercion().rowTypeElementCoercion(scope, operandList.get(i), returnType, sqlNode -> sqlCall.setOperand(finalI, (SqlNode)sqlNode));
            if (elementTypeCoerced) continue;
            if (throwOnFailure) {
                throw validator.newValidationError(sqlCall, HazelcastResources.RESOURCES.cannotInferCaseResult(((Object)argTypes).toString(), this.getName()));
            }
            return false;
        }
        return true;
    }
}

