/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.connector.SqlConnectorUtil;
import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.TableModifyLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.UpdateLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.ValuesLogicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastRelOptTable;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeFactory;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import java.util.ArrayList;
import java.util.List;

final class UpdateLogicalRules {
    static final RelOptRule SCAN_INSTANCE = new RelOptRule(RelOptRule.operandJ(TableModifyLogicalRel.class, Conventions.LOGICAL, TableModify::isUpdate, RelOptRule.operand(FullScanLogicalRel.class, RelOptRule.none()), new RelOptRuleOperand[0]), UpdateLogicalRules.class.getSimpleName()){

        @Override
        public void onMatch(RelOptRuleCall call) {
            TableModifyLogicalRel update = (TableModifyLogicalRel)call.rel(0);
            FullScanLogicalRel scan = (FullScanLogicalRel)call.rel(1);
            UpdateLogicalRel rel = new UpdateLogicalRel(update.getCluster(), OptUtils.toLogicalConvention(update.getTraitSet()), update.getTable(), update.getCatalogReader(), this.rewriteScan(scan), update.getUpdateColumnList(), update.getSourceExpressionList(), update.isFlattened());
            call.transformTo(rel);
        }

        private RelNode rewriteScan(FullScanLogicalRel scan) {
            HazelcastRelOptTable relTable = (HazelcastRelOptTable)scan.getTable();
            HazelcastTable hzTable = relTable.unwrap(HazelcastTable.class);
            List<RexNode> keyProjects = this.keyProjects(scan.getCluster().getRexBuilder(), (Table)hzTable.getTarget());
            HazelcastRelOptTable convertedTable = OptUtils.createRelTable(relTable, hzTable.withProject(keyProjects, null), scan.getCluster().getTypeFactory());
            return new FullScanLogicalRel(scan.getCluster(), OptUtils.toLogicalConvention(scan.getTraitSet()), convertedTable, null, -1);
        }

        public List<RexNode> keyProjects(RexBuilder rexBuilder, Table table) {
            List<String> primaryKey = SqlConnectorUtil.getJetSqlConnector(table).getPrimaryKey(table);
            ArrayList<RexNode> res = new ArrayList<RexNode>(primaryKey.size());
            for (int i = 0; i < table.getFieldCount(); ++i) {
                TableField field = table.getField(i);
                if (!primaryKey.contains(field.getName())) continue;
                RelDataType type = OptUtils.convert(field, HazelcastTypeFactory.INSTANCE);
                res.add(rexBuilder.makeInputRef(type, i));
            }
            return res;
        }
    };
    static final RelOptRule VALUES_INSTANCE = new RelOptRule(RelOptRule.operandJ(TableModifyLogicalRel.class, null, TableModify::isUpdate, RelOptRule.operand(ValuesLogicalRel.class, RelOptRule.none()), new RelOptRuleOperand[0]), UpdateLogicalRules.class.getSimpleName() + "(NOOP)"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            TableModifyLogicalRel update = (TableModifyLogicalRel)call.rel(0);
            ValuesLogicalRel values = (ValuesLogicalRel)call.rel(1);
            UpdateLogicalRel rel = new UpdateLogicalRel(update.getCluster(), OptUtils.toLogicalConvention(update.getTraitSet()), update.getTable(), update.getCatalogReader(), OptUtils.toLogicalInput(values), update.getUpdateColumnList(), update.getSourceExpressionList(), update.isFlattened());
            call.transformTo(rel);
        }
    };

    private UpdateLogicalRules() {
    }
}

