/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.generator;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.pipeline.transform.BatchSourceTransform;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.generator.SeriesTable;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class SeriesSqlConnector
implements SqlConnector {
    static final SeriesSqlConnector INSTANCE = new SeriesSqlConnector();
    private static final String TYPE_NAME = "Series";
    private static final List<TableField> FIELDS = Collections.singletonList(new TableField("v", QueryDataType.INT, false));

    SeriesSqlConnector() {
    }

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isStream() {
        return false;
    }

    @Override
    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine nodeEngine, @Nonnull Map<String, String> options, @Nonnull List<MappingField> userFields, @Nonnull String externalName) {
        throw new UnsupportedOperationException("Resolving fields not supported for " + this.typeName());
    }

    @Override
    @Nonnull
    public Table createTable(@Nonnull NodeEngine nodeEngine, @Nonnull String schemaName, @Nonnull String name, @Nonnull String externalName, @Nonnull Map<String, String> options, @Nonnull List<MappingField> resolvedFields) {
        throw new UnsupportedOperationException("Creating table not supported for " + this.typeName());
    }

    @Nonnull
    static SeriesTable createTable(String schemaName, String name, List<Expression<?>> argumentExpressions) {
        return new SeriesTable((SqlConnector)INSTANCE, FIELDS, schemaName, name, argumentExpressions);
    }

    @Override
    @Nonnull
    public Vertex fullScanReader(@Nonnull DAG dag, @Nonnull Table table0, @Nullable Expression<Boolean> predicate, @Nonnull List<Expression<?>> projections, @Nullable FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider) {
        if (eventTimePolicyProvider != null) {
            throw QueryException.error((String)"Ordering functions are not supported on top of Series mappings");
        }
        SeriesTable table = (SeriesTable)table0;
        BatchSource<JetSqlRow> source = table.items(predicate, projections);
        ProcessorMetaSupplier pms = ((BatchSourceTransform)source).metaSupplier;
        return dag.newUniqueVertex(table.toString(), pms);
    }
}

