/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryResultProducer;
import com.hazelcast.sql.impl.ResultIterator;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class StaticQueryResultProducerImpl
implements QueryResultProducer {
    private final Iterator<JetSqlRow> iterator;
    private boolean iteratorRequested;

    public StaticQueryResultProducerImpl(JetSqlRow row) {
        this(Collections.singletonList(row).iterator());
    }

    public StaticQueryResultProducerImpl(Iterator<JetSqlRow> iterator) {
        this.iterator = iterator;
    }

    public ResultIterator<JetSqlRow> iterator() {
        if (this.iteratorRequested) {
            throw new IllegalStateException("the iterator can be requested only once");
        }
        this.iteratorRequested = true;
        return new ResultIterator<JetSqlRow>(){

            public ResultIterator.HasNextResult hasNext(long timeout, TimeUnit timeUnit) {
                return StaticQueryResultProducerImpl.this.iterator.hasNext() ? ResultIterator.HasNextResult.YES : ResultIterator.HasNextResult.DONE;
            }

            public boolean hasNext() {
                return StaticQueryResultProducerImpl.this.iterator.hasNext();
            }

            public JetSqlRow next() {
                return (JetSqlRow)StaticQueryResultProducerImpl.this.iterator.next();
            }
        };
    }

    public void onError(QueryException error) {
    }
}

