/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.esri.core.geometry;

import com.hazelcast.com.esri.core.geometry.AttributeStreamOfDbl;
import com.hazelcast.com.esri.core.geometry.AttributeStreamOfInt32;
import com.hazelcast.com.esri.core.geometry.EditShape;
import com.hazelcast.com.esri.core.geometry.Envelope1D;
import com.hazelcast.com.esri.core.geometry.Geometry;
import com.hazelcast.com.esri.core.geometry.GeometryException;
import com.hazelcast.com.esri.core.geometry.MathUtils;
import com.hazelcast.com.esri.core.geometry.NonSimpleResult;
import com.hazelcast.com.esri.core.geometry.NumberUtils;
import com.hazelcast.com.esri.core.geometry.Point2D;
import com.hazelcast.com.esri.core.geometry.ProgressTracker;
import com.hazelcast.com.esri.core.geometry.Segment;
import com.hazelcast.com.esri.core.geometry.SegmentBuffer;
import com.hazelcast.com.esri.core.geometry.StridedIndexTypeCollection;
import com.hazelcast.com.esri.core.geometry.Treap;
import com.hazelcast.com.esri.core.geometry.UserCancelException;
import java.util.ArrayList;

final class TopoGraph {
    EditShape m_shape;
    StridedIndexTypeCollection m_clusterData;
    StridedIndexTypeCollection m_clusterVertices;
    int m_firstCluster = -1;
    int m_lastCluster = -1;
    StridedIndexTypeCollection m_halfEdgeData;
    StridedIndexTypeCollection m_chainData;
    AttributeStreamOfDbl m_chainAreas;
    AttributeStreamOfDbl m_chainPerimeters;
    final int c_edgeParentageMask;
    final int c_edgeBitMask;
    int m_universeChain = -1;
    ArrayList<AttributeStreamOfInt32> m_edgeIndices;
    ArrayList<AttributeStreamOfInt32> m_clusterIndices;
    ArrayList<AttributeStreamOfInt32> m_chainIndices;
    int m_geometryIDIndex = -1;
    int m_clusterIndex = -1;
    int m_halfEdgeIndex = -1;
    int m_tmpHalfEdgeParentageIndex = -1;
    int m_tmpHalfEdgeWindingNumberIndex = -1;
    int m_tmpHalfEdgeOddEvenNumberIndex = -1;
    int m_universe_geomID = -1;
    boolean m_buildChains = true;
    private boolean m_dirty_check_failed = false;
    private double m_check_dirty_planesweep_tolerance = Double.NaN;
    NonSimpleResult m_non_simple_result = new NonSimpleResult();
    int m_pointCount = 0;

    void check_dirty_planesweep(double tolerance) {
        this.m_check_dirty_planesweep_tolerance = tolerance;
    }

    boolean dirty_check_failed() {
        return this.m_dirty_check_failed;
    }

    int newCluster_() {
        if (this.m_clusterData == null) {
            this.m_clusterData = new StridedIndexTypeCollection(8);
        }
        int cluster = this.m_clusterData.newElement();
        this.m_clusterData.setField(cluster, 1, 0);
        return cluster;
    }

    int newHalfEdgePair_() {
        if (this.m_halfEdgeData == null) {
            this.m_halfEdgeData = new StridedIndexTypeCollection(8);
        }
        int halfEdge = this.m_halfEdgeData.newElement();
        this.m_halfEdgeData.setField(halfEdge, 2, 0);
        this.m_halfEdgeData.setField(halfEdge, 3, 0);
        int twinHalfEdge = this.m_halfEdgeData.newElement();
        this.m_halfEdgeData.setField(twinHalfEdge, 2, 0);
        this.m_halfEdgeData.setField(twinHalfEdge, 3, 0);
        this.setHalfEdgeTwin_(halfEdge, twinHalfEdge);
        this.setHalfEdgeTwin_(twinHalfEdge, halfEdge);
        return halfEdge;
    }

    int newChain_() {
        if (this.m_chainData == null) {
            this.m_chainData = new StridedIndexTypeCollection(8);
        }
        int chain = this.m_chainData.newElement();
        this.m_chainData.setField(chain, 2, 0);
        return chain;
    }

    int deleteChain_(int chain) {
        assert (this.m_universeChain != chain);
        int n = this.getChainNext(chain);
        this.m_chainData.deleteElement(chain);
        return n;
    }

    int getClusterIndex_(int cluster) {
        return this.m_clusterData.elementToIndex(cluster);
    }

    void setClusterVertexIterator_(int cluster, int verticeList) {
        this.m_clusterData.setField(cluster, 7, verticeList);
    }

    void setClusterHalfEdge_(int cluster, int half_edge) {
        this.m_clusterData.setField(cluster, 2, half_edge);
    }

    void setClusterParentage_(int cluster, int parentage) {
        this.m_clusterData.setField(cluster, 1, parentage);
    }

    void setPrevCluster_(int cluster, int nextCluster) {
        this.m_clusterData.setField(cluster, 3, nextCluster);
    }

    void setNextCluster_(int cluster, int nextCluster) {
        this.m_clusterData.setField(cluster, 4, nextCluster);
    }

    void setClusterVertexIndex_(int cluster, int index) {
        this.m_clusterData.setField(cluster, 5, index);
    }

    int getClusterVertexIndex_(int cluster) {
        return this.m_clusterData.getField(cluster, 5);
    }

    void setClusterChain_(int cluster, int chain) {
        this.m_clusterData.setField(cluster, 6, chain);
    }

    void addClusterToExteriorChain_(int chain, int cluster) {
        assert (this.getClusterChain(cluster) == -1);
        this.setClusterChain_(cluster, chain);
    }

    int getHalfEdgeIndex_(int he) {
        return this.m_halfEdgeData.elementToIndex(he);
    }

    void setHalfEdgeOrigin_(int half_edge, int cluster) {
        this.m_halfEdgeData.setField(half_edge, 1, cluster);
    }

    void setHalfEdgeTwin_(int half_edge, int twinHalfEdge) {
        this.m_halfEdgeData.setField(half_edge, 4, twinHalfEdge);
    }

    void setHalfEdgePrev_(int half_edge, int prevHalfEdge) {
        this.m_halfEdgeData.setField(half_edge, 5, prevHalfEdge);
    }

    void setHalfEdgeNext_(int half_edge, int nextHalfEdge) {
        this.m_halfEdgeData.setField(half_edge, 6, nextHalfEdge);
    }

    void setHalfEdgeChain_(int half_edge, int chain) {
        this.m_halfEdgeData.setField(half_edge, 2, chain);
    }

    void setHalfEdgeParentage_(int half_edge, int parentageMask) {
        this.m_halfEdgeData.setField(half_edge, 3, parentageMask);
    }

    int getHalfEdgeParentageMask_(int half_edge) {
        return this.m_halfEdgeData.getField(half_edge, 3);
    }

    void setHalfEdgeVertexIterator_(int half_edge, int vertexIterator) {
        this.m_halfEdgeData.setField(half_edge, 7, vertexIterator);
    }

    void updateVertexToHalfEdgeConnectionHelper_(int half_edge, boolean bClear) {
        int viter = this.getHalfEdgeVertexIterator(half_edge);
        if (viter != -1) {
            int he = bClear ? -1 : half_edge;
            int viter_ = this.getHalfEdgeVertexIterator(half_edge);
            while (viter_ != -1) {
                int vertex = this.getVertexFromVertexIterator(viter_);
                this.m_shape.setUserIndex(vertex, this.m_halfEdgeIndex, he);
                viter_ = this.incrementVertexIterator(viter_);
            }
        }
    }

    void updateVertexToHalfEdgeConnection_(int half_edge, boolean bClear) {
        if (half_edge == -1) {
            return;
        }
        this.updateVertexToHalfEdgeConnectionHelper_(half_edge, bClear);
        this.updateVertexToHalfEdgeConnectionHelper_(this.getHalfEdgeTwin(half_edge), bClear);
    }

    int getChainIndex_(int chain) {
        return this.m_chainData.elementToIndex(chain);
    }

    void setChainHalfEdge_(int chain, int half_edge) {
        this.m_chainData.setField(chain, 1, half_edge);
    }

    void setChainParentage_(int chain, int parentage) {
        this.m_chainData.setField(chain, 2, parentage);
    }

    void setChainParent_(int chain, int parentChain) {
        assert (this.m_chainData.getField(chain, 3) != parentChain);
        this.m_chainData.setField(chain, 3, parentChain);
        int firstIsland = this.getChainFirstIsland(parentChain);
        this.setChainNextInParent_(chain, firstIsland);
        this.setChainFirstIsland_(parentChain, chain);
    }

    void setChainFirstIsland_(int chain, int islandChain) {
        this.m_chainData.setField(chain, 4, islandChain);
    }

    void setChainNextInParent_(int chain, int nextInParent) {
        this.m_chainData.setField(chain, 5, nextInParent);
    }

    void setChainPrev_(int chain, int prev) {
        this.m_chainData.setField(chain, 6, prev);
    }

    void setChainNext_(int chain, int next) {
        this.m_chainData.setField(chain, 7, next);
    }

    void setChainArea_(int chain, double area) {
        int chainIndex = this.getChainIndex_(chain);
        this.m_chainAreas.write(chainIndex, area);
    }

    void setChainPerimeter_(int chain, double perimeter) {
        int chainIndex = this.getChainIndex_(chain);
        this.m_chainPerimeters.write(chainIndex, perimeter);
    }

    void updateChainAreaAndPerimeter_(int chain) {
        double area = 0.0;
        double perimeter = 0.0;
        int firstHalfEdge = this.getChainHalfEdge(chain);
        Point2D origin = new Point2D();
        Point2D from = new Point2D();
        Point2D to = new Point2D();
        this.getHalfEdgeFromXY(firstHalfEdge, origin);
        from.setCoords(origin);
        int half_edge = firstHalfEdge;
        do {
            this.getHalfEdgeToXY(half_edge, to);
            perimeter += Point2D.distance(from, to);
            int twinChain = this.getHalfEdgeChain(this.getHalfEdgeTwin(half_edge));
            if (twinChain != chain) {
                area += (to.x - origin.x - (from.x - origin.x)) * (to.y - origin.y + (from.y - origin.y)) * 0.5;
            }
            from.setCoords(to);
        } while ((half_edge = this.getHalfEdgeNext(half_edge)) != firstHalfEdge);
        int ind = this.getChainIndex_(chain);
        this.m_chainAreas.write(ind, area);
        this.m_chainPerimeters.write(ind, perimeter);
    }

    int getChainTopMostEdge_(int chain) {
        int firstHalfEdge = this.getChainHalfEdge(chain);
        Point2D top = new Point2D();
        this.getHalfEdgeFromXY(firstHalfEdge, top);
        int topEdge = firstHalfEdge;
        Point2D v = new Point2D();
        int half_edge = firstHalfEdge;
        do {
            this.getHalfEdgeFromXY(half_edge, v);
            if (v.compare(top) <= 0) continue;
            top.setCoords(v);
            topEdge = half_edge;
        } while ((half_edge = this.getHalfEdgeNext(half_edge)) != firstHalfEdge);
        return topEdge;
    }

    void planeSweepParentage_(int inputMode, ProgressTracker progress_tracker) {
        PlaneSweepComparator comparator = new PlaneSweepComparator(this);
        Treap aet = new Treap();
        aet.setCapacity(this.m_pointCount / 2);
        aet.setComparator(comparator);
        AttributeStreamOfInt32 new_edges = new AttributeStreamOfInt32(0);
        int treeNodeIndex = this.createUserIndexForHalfEdges();
        ClusterSweepMonikerComparator clusterMoniker = null;
        int counter = 0;
        Point2D pt = new Point2D();
        int cluster = this.getFirstCluster();
        while (cluster != -1) {
            if ((++counter & 0xFF) == 0 && progress_tracker != null && !progress_tracker.progress(-1, -1)) {
                throw new UserCancelException();
            }
            int firstHalfEdge = this.getClusterHalfEdge(cluster);
            if (firstHalfEdge != -1) {
                new_edges.resizePreserveCapacity(0);
                if (!this.tryOptimizedInsertion_(aet, treeNodeIndex, new_edges, cluster, firstHalfEdge)) {
                    int attachedTreeNode;
                    this.getXY(cluster, pt);
                    comparator.setY(pt.y);
                    int clusterHalfEdge = firstHalfEdge;
                    do {
                        if ((attachedTreeNode = this.getHalfEdgeUserIndex(clusterHalfEdge, treeNodeIndex)) != -1) {
                            assert (attachedTreeNode != StridedIndexTypeCollection.impossibleIndex2());
                            aet.deleteNode(attachedTreeNode, -1);
                            this.setHalfEdgeUserIndex(clusterHalfEdge, treeNodeIndex, StridedIndexTypeCollection.impossibleIndex2());
                        }
                        clusterHalfEdge = this.getHalfEdgeNext(this.getHalfEdgeTwin(clusterHalfEdge));
                        assert (this.getHalfEdgeOrigin(clusterHalfEdge) == cluster);
                    } while (firstHalfEdge != clusterHalfEdge);
                    clusterHalfEdge = firstHalfEdge;
                    do {
                        if ((attachedTreeNode = this.getHalfEdgeUserIndex(clusterHalfEdge, treeNodeIndex)) == -1) {
                            int newTreeNode = aet.addElement(clusterHalfEdge, -1);
                            new_edges.add(newTreeNode);
                        }
                        clusterHalfEdge = this.getHalfEdgeNext(this.getHalfEdgeTwin(clusterHalfEdge));
                        assert (this.getHalfEdgeOrigin(clusterHalfEdge) == cluster);
                    } while (firstHalfEdge != clusterHalfEdge);
                }
                for (int i = new_edges.size() - 1; i >= 0; --i) {
                    int newTreeNode = new_edges.get(i);
                    int clusterHalfEdge = aet.getElement(newTreeNode);
                    int twinEdge = this.getHalfEdgeTwin(clusterHalfEdge);
                    assert (this.getHalfEdgeUserIndex(twinEdge, treeNodeIndex) == -1);
                    this.setHalfEdgeUserIndex(twinEdge, treeNodeIndex, newTreeNode);
                    this.planeSweepParentagePropagateParentage_(aet, newTreeNode, inputMode);
                }
            } else if (this.getClusterChain(cluster) == -1) {
                if (clusterMoniker == null) {
                    clusterMoniker = new ClusterSweepMonikerComparator(this);
                }
                this.getXY(cluster, pt);
                clusterMoniker.setPointXY(pt);
                int leftNode = aet.searchLowerBound(clusterMoniker, -1);
                int chain = this.m_universeChain;
                if (leftNode != -1) {
                    int edge = aet.getElement(leftNode);
                    int leftChain = this.getHalfEdgeChain(edge);
                    if (leftChain == this.getHalfEdgeChain(this.getHalfEdgeTwin(edge))) {
                        edge = this.getLeftSkipPolylines_(aet, leftNode);
                    }
                    if (edge != -1) {
                        chain = this.getHalfEdgeChain(edge);
                    }
                }
                this.addClusterToExteriorChain_(chain, cluster);
            }
            cluster = this.getNextCluster(cluster);
        }
        this.deleteUserIndexForHalfEdges(treeNodeIndex);
    }

    void planeSweepParentagePropagateParentage_(Treap aet, int treeNode, int inputMode) {
        int edge = aet.getElement(treeNode);
        int edgeChain = this.getHalfEdgeChain(edge);
        int edgeChainParent = this.getChainParent(edgeChain);
        if (edgeChainParent != -1) {
            return;
        }
        int leftEdge = this.getLeftSkipPolylines_(aet, treeNode);
        int twinEdge = this.getHalfEdgeTwin(edge);
        int twinHalfEdgeChain = this.getHalfEdgeChain(twinEdge);
        double chainArea = this.getChainArea(edgeChain);
        double twinChainArea = this.getChainArea(twinHalfEdgeChain);
        int parentChain = this.getChainParent(edgeChain);
        int twinParentChain = this.getChainParent(twinHalfEdgeChain);
        if (leftEdge == -1 && parentChain == -1) {
            if (twinHalfEdgeChain == edgeChain) {
                this.setChainParent_(twinHalfEdgeChain, this.getFirstChain());
                parentChain = twinParentChain = this.getFirstChain();
            } else {
                assert (twinChainArea < 0.0 && chainArea > 0.0);
                if (twinParentChain == -1) {
                    this.setChainParent_(twinHalfEdgeChain, this.m_universeChain);
                    twinParentChain = this.m_universeChain;
                } else assert (this.getFirstChain() == twinParentChain);
                this.setChainParent_(edgeChain, twinHalfEdgeChain);
                parentChain = twinHalfEdgeChain;
            }
        }
        if (leftEdge != -1) {
            int leftEdgeChain = this.getHalfEdgeChain(leftEdge);
            if (twinParentChain == -1) {
                double leftArea = this.getChainArea(leftEdgeChain);
                if (leftArea <= 0.0) {
                    int leftChainParent = this.getChainParent(leftEdgeChain);
                    assert (leftChainParent != -1);
                    this.setChainParent_(twinHalfEdgeChain, leftChainParent);
                    twinParentChain = leftChainParent;
                } else {
                    this.setChainParent_(twinHalfEdgeChain, leftEdgeChain);
                    twinParentChain = leftEdgeChain;
                }
                if (twinHalfEdgeChain == edgeChain) {
                    parentChain = twinParentChain;
                }
            }
        }
        if (parentChain == -1) {
            this.trySetChainParentFromTwin_(edgeChain, twinHalfEdgeChain);
            parentChain = this.getChainParent(edgeChain);
        }
        assert (parentChain != -1);
        if (inputMode == 0) {
            this.propagate_parentage_build_graph_(aet, treeNode, edge, leftEdge, edgeChain, edgeChainParent, twinHalfEdgeChain);
        } else if (inputMode == 5) {
            this.propagate_parentage_winding_(aet, treeNode, edge, leftEdge, twinEdge, edgeChain, edgeChainParent, twinHalfEdgeChain);
        } else if (inputMode == 4) {
            this.propagate_parentage_alternate_(aet, treeNode, edge, leftEdge, twinEdge, edgeChain, edgeChainParent, twinHalfEdgeChain);
        }
    }

    void propagate_parentage_build_graph_(Treap aet, int treeNode, int edge, int leftEdge, int edgeChain, int edgeChainParent, int twinHalfEdgeChain) {
        int chainParentage = this.getChainParentage(edgeChain);
        if (leftEdge != -1) {
            int leftEdgeChain = this.getHalfEdgeChain(leftEdge);
            int twinChainParentage = this.getChainParentage(twinHalfEdgeChain);
            int leftChainParentage = this.getChainParentage(leftEdgeChain);
            int edgeParentage = this.getHalfEdgeParentage(edge);
            int spikeParentage = chainParentage & twinChainParentage & leftChainParentage;
            leftChainParentage ^= leftChainParentage & edgeParentage;
            if ((leftChainParentage |= spikeParentage) != 0) {
                this.setChainParentage_(twinHalfEdgeChain, twinChainParentage | leftChainParentage);
                this.setChainParentage_(edgeChain, leftChainParentage | chainParentage);
                chainParentage |= leftChainParentage;
            }
        }
        int rightNode = aet.getNext(treeNode);
        while (rightNode != -1) {
            int rightEdge = aet.getElement(rightNode);
            int rightTwin = this.getHalfEdgeTwin(rightEdge);
            int rightTwinChain = this.getHalfEdgeChain(rightTwin);
            int rightTwinChainParentage = this.getChainParentage(rightTwinChain);
            int rightEdgeParentage = this.getHalfEdgeParentage(rightEdge);
            int rightEdgeChain = this.getHalfEdgeChain(rightEdge);
            int rightChainParentage = this.getChainParentage(rightEdgeChain);
            int spikeParentage = rightTwinChainParentage & rightChainParentage & chainParentage;
            chainParentage ^= chainParentage & rightEdgeParentage;
            if ((chainParentage |= spikeParentage) == 0) break;
            this.setChainParentage_(rightTwinChain, rightTwinChainParentage | chainParentage);
            this.setChainParentage_(rightEdgeChain, rightChainParentage | chainParentage);
            rightNode = aet.getNext(rightNode);
        }
    }

    void propagate_parentage_winding_(Treap aet, int treeNode, int edge, int leftEdge, int twinEdge, int edgeChain, int edgeChainParent, int twinHalfEdgeChain) {
        int geometryID;
        int geometry;
        if (edgeChain == twinHalfEdgeChain) {
            return;
        }
        int edgeWinding = this.getHalfEdgeUserIndex(edge, this.m_tmpHalfEdgeWindingNumberIndex);
        edgeWinding += this.getHalfEdgeUserIndex(twinEdge, this.m_tmpHalfEdgeWindingNumberIndex);
        int winding = 0;
        AttributeStreamOfInt32 chainStack = new AttributeStreamOfInt32(0);
        AttributeStreamOfInt32 windingStack = new AttributeStreamOfInt32(0);
        windingStack.add(0);
        int leftNode = aet.getFirst(-1);
        while (leftNode != treeNode) {
            int lt_chain;
            int leftEdge1 = aet.getElement(leftNode);
            int leftTwin = this.getHalfEdgeTwin(leftEdge1);
            int l_chain = this.getHalfEdgeChain(leftEdge1);
            if (l_chain != (lt_chain = this.getHalfEdgeChain(leftTwin))) {
                int leftWinding = this.getHalfEdgeUserIndex(leftEdge1, this.m_tmpHalfEdgeWindingNumberIndex);
                winding += (leftWinding += this.getHalfEdgeUserIndex(leftTwin, this.m_tmpHalfEdgeWindingNumberIndex));
                boolean popped = false;
                if (chainStack.size() != 0 && chainStack.getLast() == lt_chain) {
                    windingStack.removeLast();
                    chainStack.removeLast();
                    popped = true;
                }
                if (this.getChainParent(lt_chain) == -1) {
                    throw GeometryException.GeometryInternalError();
                }
                if (!popped || this.getChainParent(lt_chain) != l_chain) {
                    windingStack.add(winding);
                    chainStack.add(l_chain);
                }
            }
            leftNode = aet.getNext(leftNode);
        }
        winding += edgeWinding;
        if (chainStack.size() != 0 && chainStack.getLast() == twinHalfEdgeChain) {
            windingStack.removeLast();
            chainStack.removeLast();
        }
        if (winding != 0) {
            if (windingStack.getLast() == 0) {
                geometry = this.m_shape.getFirstGeometry();
                geometryID = this.getGeometryID(geometry);
                this.setChainParentage_(edgeChain, geometryID);
            }
        } else if (windingStack.getLast() != 0) {
            geometry = this.m_shape.getFirstGeometry();
            geometryID = this.getGeometryID(geometry);
            this.setChainParentage_(edgeChain, geometryID);
        }
    }

    void propagate_parentage_alternate_(Treap aet, int treeNode, int edge, int leftEdge, int twinEdge, int edgeChain, int edgeChainParent, int twinHalfEdgeChain) {
        int geometry = this.m_shape.getFirstGeometry();
        int geometryID = this.getGeometryID(geometry);
        if (leftEdge == -1) {
            assert (this.getChainParent(twinHalfEdgeChain) == this.m_universeChain);
            assert (this.getChainParentage(twinHalfEdgeChain) == 0 || this.getChainParentage(twinHalfEdgeChain) == this.m_universe_geomID);
            assert (this.getChainParentage(edgeChain) == 0);
            this.setChainParentage_(twinHalfEdgeChain, this.m_universe_geomID);
            int parity = this.getHalfEdgeUserIndex(edge, this.m_tmpHalfEdgeOddEvenNumberIndex);
            if ((parity & 1) != 0) {
                this.setChainParentage_(edgeChain, geometryID);
            } else {
                this.setChainParentage_(edgeChain, this.m_universe_geomID);
            }
        } else {
            int twin_parentage = this.getChainParentage(twinHalfEdgeChain);
            if (twin_parentage == 0) {
                int leftEdgeChain = this.getHalfEdgeChain(leftEdge);
                int left_parentage = this.getChainParentage(leftEdgeChain);
                this.setChainParentage_(twinHalfEdgeChain, left_parentage);
                int parity = this.getHalfEdgeUserIndex(edge, this.m_tmpHalfEdgeOddEvenNumberIndex);
                if ((parity & 1) != 0) {
                    this.setChainParentage_(edgeChain, left_parentage == geometryID ? this.m_universe_geomID : geometryID);
                } else {
                    this.setChainParentage_(edgeChain, left_parentage);
                }
            } else {
                int parity = this.getHalfEdgeUserIndex(edge, this.m_tmpHalfEdgeOddEvenNumberIndex);
                if ((parity & 1) != 0) {
                    this.setChainParentage_(edgeChain, twin_parentage == geometryID ? this.m_universe_geomID : geometryID);
                } else {
                    this.setChainParentage_(edgeChain, twin_parentage);
                }
            }
        }
    }

    boolean tryOptimizedInsertion_(Treap aet, int treeNodeIndex, AttributeStreamOfInt32 new_edges, int cluster, int firstHalfEdge) {
        int clusterHalfEdge = firstHalfEdge;
        int attachedTreeNode = -1;
        int newEdge = -1;
        int count = 0;
        do {
            if (count == 2) {
                return false;
            }
            int n = this.getHalfEdgeUserIndex(clusterHalfEdge, treeNodeIndex);
            if (n != -1) {
                if (attachedTreeNode != -1) {
                    return false;
                }
                attachedTreeNode = n;
            } else {
                if (newEdge != -1) {
                    return false;
                }
                newEdge = clusterHalfEdge;
            }
            assert (this.getHalfEdgeOrigin(clusterHalfEdge) == cluster);
            ++count;
        } while (firstHalfEdge != (clusterHalfEdge = this.getHalfEdgeNext(this.getHalfEdgeTwin(clusterHalfEdge))));
        if (newEdge == -1 || attachedTreeNode == -1) {
            return false;
        }
        this.setHalfEdgeUserIndex(aet.getElement(attachedTreeNode), treeNodeIndex, StridedIndexTypeCollection.impossibleIndex2());
        aet.setElement(attachedTreeNode, newEdge);
        new_edges.add(attachedTreeNode);
        return true;
    }

    boolean trySetChainParentFromTwin_(int chainToSet, int twinChain) {
        assert (this.getChainParent(chainToSet) == -1);
        double area = this.getChainArea(chainToSet);
        if (area == 0.0) {
            return false;
        }
        double twinArea = this.getChainArea(twinChain);
        assert (twinArea != 0.0);
        if (area > 0.0 && twinArea < 0.0) {
            this.setChainParent_(chainToSet, twinChain);
            return true;
        }
        if (area < 0.0 && twinArea > 0.0) {
            this.setChainParent_(chainToSet, twinChain);
            return true;
        }
        int twinParent = this.getChainParent(twinChain);
        if (twinParent != -1) {
            this.setChainParent_(chainToSet, twinParent);
            return true;
        }
        return false;
    }

    void createHalfEdges_(int inputMode, AttributeStreamOfInt32 sorted_vertices) {
        this.m_halfEdgeIndex = this.m_shape.createUserIndex();
        int nvert = sorted_vertices.size();
        for (int i = 0; i < nvert; ++i) {
            int next;
            int vertex = sorted_vertices.get(i);
            int cluster = this.m_shape.getUserIndex(vertex, this.m_clusterIndex);
            int path = this.m_shape.getPathFromVertex(vertex);
            int geometry = this.m_shape.getGeometryFromPath(path);
            int gt = this.m_shape.getGeometryType(geometry);
            if (!Geometry.isMultiPath(gt) || (next = this.m_shape.getNextVertex(vertex)) == -1) continue;
            int clusterTo = this.m_shape.getUserIndex(next, this.m_clusterIndex);
            assert (clusterTo != -1);
            if (cluster == clusterTo) {
                if (this.m_shape.getSegment(vertex) != null ? !$assertionsDisabled && this.m_shape.getSegment(vertex).calculateLength2D() != 0.0 : !$assertionsDisabled && !this.m_shape.getXY(vertex).isEqual(this.m_shape.getXY(next))) {
                    throw new AssertionError();
                }
                continue;
            }
            int half_edge = this.newHalfEdgePair_();
            int twinEdge = this.getHalfEdgeTwin(half_edge);
            int vertIndex = this.m_clusterVertices.newElement();
            this.m_clusterVertices.setField(vertIndex, 0, vertex);
            this.m_clusterVertices.setField(vertIndex, 1, -1);
            this.setHalfEdgeVertexIterator_(half_edge, vertIndex);
            this.setHalfEdgeOrigin_(half_edge, cluster);
            int firstHalfEdge = this.getClusterHalfEdge(cluster);
            if (firstHalfEdge == -1) {
                this.setClusterHalfEdge_(cluster, half_edge);
                this.setHalfEdgePrev_(half_edge, twinEdge);
                this.setHalfEdgeNext_(twinEdge, half_edge);
            } else {
                int firstPrev = this.getHalfEdgePrev(firstHalfEdge);
                assert (this.getHalfEdgeNext(firstPrev) == firstHalfEdge);
                this.setHalfEdgePrev_(firstHalfEdge, twinEdge);
                this.setHalfEdgeNext_(twinEdge, firstHalfEdge);
                assert (this.getHalfEdgePrev(firstHalfEdge) == twinEdge);
                assert (this.getHalfEdgeNext(twinEdge) == firstHalfEdge);
                this.setHalfEdgeNext_(firstPrev, half_edge);
                this.setHalfEdgePrev_(half_edge, firstPrev);
                assert (this.getHalfEdgePrev(half_edge) == firstPrev);
                assert (this.getHalfEdgeNext(firstPrev) == half_edge);
            }
            this.setHalfEdgeOrigin_(twinEdge, clusterTo);
            int firstTo = this.getClusterHalfEdge(clusterTo);
            if (firstTo == -1) {
                this.setClusterHalfEdge_(clusterTo, twinEdge);
                this.setHalfEdgeNext_(half_edge, twinEdge);
                this.setHalfEdgePrev_(twinEdge, half_edge);
            } else {
                int firstToPrev = this.getHalfEdgePrev(firstTo);
                assert (this.getHalfEdgeNext(firstToPrev) == firstTo);
                this.setHalfEdgePrev_(firstTo, half_edge);
                this.setHalfEdgeNext_(half_edge, firstTo);
                assert (this.getHalfEdgePrev(firstTo) == half_edge);
                assert (this.getHalfEdgeNext(half_edge) == firstTo);
                this.setHalfEdgeNext_(firstToPrev, twinEdge);
                this.setHalfEdgePrev_(twinEdge, firstToPrev);
                assert (this.getHalfEdgePrev(twinEdge) == firstToPrev);
                assert (this.getHalfEdgeNext(firstToPrev) == twinEdge);
            }
            int geometryID = this.getGeometryID(geometry);
            if (inputMode == 0) {
                this.setHalfEdgeUserIndex(twinEdge, this.m_tmpHalfEdgeParentageIndex, 0);
                this.setHalfEdgeUserIndex(half_edge, this.m_tmpHalfEdgeParentageIndex, gt == 1736 ? geometryID : 0);
            } else if (inputMode == 5) {
                Point2D pt_1 = new Point2D();
                this.m_shape.getXY(vertex, pt_1);
                Point2D pt_2 = new Point2D();
                this.m_shape.getXY(next, pt_2);
                int windingNumber = 0;
                int windingNumberTwin = 0;
                if (pt_1.compare(pt_2) < 0) {
                    windingNumber = 1;
                } else {
                    windingNumberTwin = -1;
                }
                this.setHalfEdgeUserIndex(twinEdge, this.m_tmpHalfEdgeParentageIndex, 0);
                this.setHalfEdgeUserIndex(half_edge, this.m_tmpHalfEdgeParentageIndex, 0);
                this.setHalfEdgeUserIndex(half_edge, this.m_tmpHalfEdgeWindingNumberIndex, windingNumber);
                this.setHalfEdgeUserIndex(twinEdge, this.m_tmpHalfEdgeWindingNumberIndex, windingNumberTwin);
            } else if (inputMode == 7) {
                this.setHalfEdgeUserIndex(twinEdge, this.m_tmpHalfEdgeParentageIndex, this.m_universe_geomID);
                this.setHalfEdgeUserIndex(half_edge, this.m_tmpHalfEdgeParentageIndex, gt == 1736 ? geometryID : 0);
            } else if (inputMode == 4) {
                this.setHalfEdgeUserIndex(twinEdge, this.m_tmpHalfEdgeParentageIndex, 0);
                this.setHalfEdgeUserIndex(half_edge, this.m_tmpHalfEdgeParentageIndex, 0);
                this.setHalfEdgeUserIndex(half_edge, this.m_tmpHalfEdgeOddEvenNumberIndex, 1);
                this.setHalfEdgeUserIndex(twinEdge, this.m_tmpHalfEdgeOddEvenNumberIndex, 1);
            }
            int edgeBit = gt == 1736 ? this.c_edgeBitMask : 0;
            this.setHalfEdgeParentage_(half_edge, geometryID | edgeBit);
            this.setHalfEdgeParentage_(twinEdge, geometryID | edgeBit);
        }
    }

    void mergeVertexListsOfEdges_(int eDst, int eSrc) {
        assert (this.getHalfEdgeTo(eDst) == this.getHalfEdgeTo(eSrc));
        assert (this.getHalfEdgeOrigin(eDst) == this.getHalfEdgeOrigin(eSrc));
        int vertFirst2 = this.getHalfEdgeVertexIterator(eSrc);
        if (vertFirst2 != -1) {
            int vertFirst1 = this.getHalfEdgeVertexIterator(eDst);
            this.m_clusterVertices.setField(vertFirst2, 1, vertFirst1);
            this.setHalfEdgeVertexIterator_(eDst, vertFirst2);
            this.setHalfEdgeVertexIterator_(eSrc, -1);
        }
        int eDstTwin = this.getHalfEdgeTwin(eDst);
        int eSrcTwin = this.getHalfEdgeTwin(eSrc);
        int vertFirst22 = this.getHalfEdgeVertexIterator(eSrcTwin);
        if (vertFirst22 != -1) {
            int vertFirst1 = this.getHalfEdgeVertexIterator(eDstTwin);
            this.m_clusterVertices.setField(vertFirst22, 1, vertFirst1);
            this.setHalfEdgeVertexIterator_(eDstTwin, vertFirst22);
            this.setHalfEdgeVertexIterator_(eSrcTwin, -1);
        }
    }

    void sortHalfEdgesByAngle_(int inputMode) {
        AttributeStreamOfInt32 angleSorter = new AttributeStreamOfInt32(0);
        angleSorter.reserve(10);
        TopoGraphAngleComparer tgac = new TopoGraphAngleComparer(this);
        int cluster = this.getFirstCluster();
        while (cluster != -1) {
            angleSorter.clear(false);
            int first = this.getClusterHalfEdge(cluster);
            if (first != -1) {
                int edge = first;
                do {
                    angleSorter.add(edge);
                } while ((edge = this.getHalfEdgeNext(this.getHalfEdgeTwin(edge))) != first);
                if (angleSorter.size() > 1) {
                    int eTo;
                    int eTwin;
                    int e;
                    int i;
                    int e0;
                    boolean changed_order = true;
                    if (angleSorter.size() > 2) {
                        angleSorter.Sort(0, angleSorter.size(), tgac);
                        angleSorter.add(angleSorter.get(0));
                    } else if (this.compareEdgeAnglesForPair_(angleSorter.get(0), angleSorter.get(1)) > 0) {
                        int tmp = angleSorter.get(0);
                        angleSorter.set(0, angleSorter.get(1));
                        angleSorter.set(1, tmp);
                    } else {
                        changed_order = false;
                    }
                    int ePrev = e0 = angleSorter.get(0);
                    int ePrevTo = this.getHalfEdgeTo(ePrev);
                    int ePrevTwin = this.getHalfEdgeTwin(ePrev);
                    int prevMerged = -1;
                    int n = angleSorter.size();
                    for (i = 1; i < n; ++i) {
                        e = angleSorter.get(i);
                        eTwin = this.getHalfEdgeTwin(e);
                        eTo = this.getHalfEdgeOrigin(eTwin);
                        assert (this.getHalfEdgeOrigin(e) == this.getHalfEdgeOrigin(ePrev));
                        if (eTo == ePrevTo && e != ePrev) {
                            int newTwinEdgeWinding;
                            int newHalfEdgeWinding;
                            if (inputMode == 0) {
                                int newEdgeParentage = this.getHalfEdgeParentageMask_(ePrev) | this.getHalfEdgeParentageMask_(e);
                                this.setHalfEdgeParentage_(ePrev, newEdgeParentage);
                                this.setHalfEdgeParentage_(ePrevTwin, newEdgeParentage);
                                assert (this.getHalfEdgeParentageMask_(ePrev) == this.getHalfEdgeParentageMask_(ePrevTwin));
                                this.setHalfEdgeUserIndex(ePrev, this.m_tmpHalfEdgeParentageIndex, this.getHalfEdgeUserIndex(ePrev, this.m_tmpHalfEdgeParentageIndex) | this.getHalfEdgeUserIndex(e, this.m_tmpHalfEdgeParentageIndex));
                                this.setHalfEdgeUserIndex(ePrevTwin, this.m_tmpHalfEdgeParentageIndex, this.getHalfEdgeUserIndex(ePrevTwin, this.m_tmpHalfEdgeParentageIndex) | this.getHalfEdgeUserIndex(eTwin, this.m_tmpHalfEdgeParentageIndex));
                            } else if (this.m_tmpHalfEdgeWindingNumberIndex != -1) {
                                newHalfEdgeWinding = this.getHalfEdgeUserIndex(ePrev, this.m_tmpHalfEdgeWindingNumberIndex) + this.getHalfEdgeUserIndex(e, this.m_tmpHalfEdgeWindingNumberIndex);
                                newTwinEdgeWinding = this.getHalfEdgeUserIndex(ePrevTwin, this.m_tmpHalfEdgeWindingNumberIndex) + this.getHalfEdgeUserIndex(eTwin, this.m_tmpHalfEdgeWindingNumberIndex);
                                this.setHalfEdgeUserIndex(ePrev, this.m_tmpHalfEdgeWindingNumberIndex, newHalfEdgeWinding);
                                this.setHalfEdgeUserIndex(ePrevTwin, this.m_tmpHalfEdgeWindingNumberIndex, newTwinEdgeWinding);
                            } else {
                                if (inputMode == 7) {
                                    this.m_non_simple_result = new NonSimpleResult(NonSimpleResult.Reason.CrossOver, cluster, -1);
                                    return;
                                }
                                if (this.m_tmpHalfEdgeOddEvenNumberIndex != -1) {
                                    newHalfEdgeWinding = this.getHalfEdgeUserIndex(ePrev, this.m_tmpHalfEdgeOddEvenNumberIndex) + this.getHalfEdgeUserIndex(e, this.m_tmpHalfEdgeOddEvenNumberIndex);
                                    newTwinEdgeWinding = this.getHalfEdgeUserIndex(ePrevTwin, this.m_tmpHalfEdgeOddEvenNumberIndex) + this.getHalfEdgeUserIndex(eTwin, this.m_tmpHalfEdgeOddEvenNumberIndex);
                                    this.setHalfEdgeUserIndex(ePrev, this.m_tmpHalfEdgeOddEvenNumberIndex, newHalfEdgeWinding);
                                    this.setHalfEdgeUserIndex(ePrevTwin, this.m_tmpHalfEdgeOddEvenNumberIndex, newTwinEdgeWinding);
                                }
                            }
                            this.mergeVertexListsOfEdges_(ePrev, e);
                            this.deleteEdgeImpl_(e);
                            assert (n < 3 || e0 == angleSorter.getLast());
                            prevMerged = ePrev;
                            angleSorter.set(i, -1);
                            if (e != e0) continue;
                            angleSorter.set(0, -1);
                            e0 = -1;
                            continue;
                        }
                        this.updateVertexToHalfEdgeConnection_(prevMerged, false);
                        prevMerged = -1;
                        ePrev = e;
                        ePrevTo = eTo;
                        ePrevTwin = eTwin;
                    }
                    this.updateVertexToHalfEdgeConnection_(prevMerged, false);
                    prevMerged = -1;
                    if (!changed_order) {
                        e0 = -1;
                        n = angleSorter.size();
                        for (i = 0; i < n; ++i) {
                            e = angleSorter.get(i);
                            if (e == -1) continue;
                            e0 = e;
                            break;
                        }
                        if (first != e0) {
                            this.setClusterHalfEdge_(cluster, e0);
                        }
                    } else {
                        e0 = -1;
                        n = angleSorter.size();
                        for (i = 0; i < n; ++i) {
                            int par1;
                            e = angleSorter.get(i);
                            if (e == -1) continue;
                            if (e0 == -1) {
                                ePrev = e0 = e;
                                ePrevTo = this.getHalfEdgeTo(ePrev);
                                ePrevTwin = this.getHalfEdgeTwin(ePrev);
                                continue;
                            }
                            if (e == ePrev) {
                                assert (i == n - 1);
                                continue;
                            }
                            eTwin = this.getHalfEdgeTwin(e);
                            eTo = this.getHalfEdgeOrigin(eTwin);
                            assert (this.getHalfEdgeOrigin(e) == this.getHalfEdgeOrigin(ePrev));
                            assert (eTo != ePrevTo);
                            this.setHalfEdgeNext_(ePrevTwin, e);
                            this.setHalfEdgePrev_(e, ePrevTwin);
                            ePrev = e;
                            ePrevTo = eTo;
                            ePrevTwin = eTwin;
                            if (inputMode != 7 || (par1 = this.getHalfEdgeUserIndex(e, this.m_tmpHalfEdgeParentageIndex) | this.getHalfEdgeUserIndex(this.getHalfEdgePrev(e), this.m_tmpHalfEdgeParentageIndex)) != (this.m_universe_geomID | 1)) continue;
                            this.m_non_simple_result = new NonSimpleResult(NonSimpleResult.Reason.CrossOver, cluster, -1);
                            return;
                        }
                        this.setClusterHalfEdge_(cluster, e0);
                    }
                }
            }
            cluster = this.getNextCluster(cluster);
        }
    }

    void buildChains_(int inputMode) {
        int firstChain = -1;
        int visitedHalfEdgeIndex = this.createUserIndexForHalfEdges();
        int cluster = this.getFirstCluster();
        while (cluster != -1) {
            int first = this.getClusterHalfEdge(cluster);
            if (first != -1) {
                int edge = first;
                do {
                    if (this.getHalfEdgeUserIndex(edge, visitedHalfEdgeIndex) == 1) continue;
                    int chain = this.newChain_();
                    this.setChainHalfEdge_(chain, edge);
                    this.setChainNext_(chain, firstChain);
                    if (firstChain != -1) {
                        this.setChainPrev_(firstChain, chain);
                    }
                    firstChain = chain;
                    int parentage = 0;
                    int e = edge;
                    do {
                        parentage |= this.getHalfEdgeUserIndex(e, this.m_tmpHalfEdgeParentageIndex);
                        assert (this.getHalfEdgeUserIndex(e, visitedHalfEdgeIndex) != 1);
                        this.setHalfEdgeChain_(e, chain);
                        this.setHalfEdgeUserIndex(e, visitedHalfEdgeIndex, 1);
                    } while ((e = this.getHalfEdgeNext(e)) != edge);
                    assert (inputMode != 7 || parentage != (1 | this.m_universe_geomID));
                    this.setChainParentage_(chain, parentage);
                } while ((edge = this.getHalfEdgeNext(this.getHalfEdgeTwin(edge))) != first);
            }
            cluster = this.getNextCluster(cluster);
        }
        int chain = this.newChain_();
        this.setChainHalfEdge_(chain, -1);
        this.setChainNext_(chain, firstChain);
        if (firstChain != -1) {
            this.setChainPrev_(firstChain, chain);
        }
        this.m_universeChain = chain;
        this.m_chainAreas = new AttributeStreamOfDbl(this.m_chainData.size(), Double.NaN);
        this.m_chainPerimeters = new AttributeStreamOfDbl(this.m_chainData.size(), Double.NaN);
        this.setChainArea_(this.m_universeChain, NumberUtils.positiveInf());
        this.setChainPerimeter_(this.m_universeChain, NumberUtils.positiveInf());
        this.deleteUserIndexForHalfEdges(visitedHalfEdgeIndex);
    }

    void simplify_(int inputMode) {
        if (inputMode == 4) {
            this.simplifyAlternate_();
        } else if (inputMode == 5) {
            this.simplifyWinding_();
        }
    }

    void simplifyAlternate_() {
    }

    void simplifyWinding_() {
    }

    private int getFirstUnvisitedHalfEdgeOnCluster_(int cluster, int hintEdge, int vistiedEdgesIndex) {
        int edge;
        int n = edge = hintEdge != -1 ? hintEdge : this.getClusterHalfEdge(cluster);
        if (edge == -1) {
            return -1;
        }
        int f = edge;
        int v;
        while ((v = this.getHalfEdgeUserIndex(edge, vistiedEdgesIndex)) == 1) {
            int next = this.getHalfEdgeNext(this.getHalfEdgeTwin(edge));
            if (next == f) {
                return -1;
            }
            edge = next;
        }
        return edge;
    }

    boolean removeSpikes_() {
        boolean removed = false;
        int visitedIndex = this.createUserIndexForHalfEdges();
        int cluster = this.getFirstCluster();
        while (cluster != -1) {
            int firstHalfEdge;
            int nextClusterEdge = -1;
            block1: while ((firstHalfEdge = this.getFirstUnvisitedHalfEdgeOnCluster_(cluster, nextClusterEdge, visitedIndex)) != -1) {
                nextClusterEdge = this.getHalfEdgeNext(this.getHalfEdgeTwin(firstHalfEdge));
                int faceHalfEdge = firstHalfEdge;
                while (true) {
                    int faceHalfEdgeTwin;
                    int faceHalfEdgeNext = this.getHalfEdgeNext(faceHalfEdge);
                    int faceHalfEdgePrev = this.getHalfEdgePrev(faceHalfEdge);
                    if (faceHalfEdgePrev == (faceHalfEdgeTwin = this.getHalfEdgeTwin(faceHalfEdge))) {
                        this.deleteEdgeInternal_(faceHalfEdge);
                        removed = true;
                        if (nextClusterEdge == faceHalfEdge || nextClusterEdge == faceHalfEdgeTwin) {
                            nextClusterEdge = -1;
                        }
                        if (faceHalfEdge == firstHalfEdge || faceHalfEdgePrev == firstHalfEdge) {
                            firstHalfEdge = faceHalfEdgeNext;
                            if (faceHalfEdge == firstHalfEdge || faceHalfEdgePrev == firstHalfEdge) continue block1;
                            faceHalfEdge = faceHalfEdgeNext;
                            continue;
                        }
                    } else {
                        this.setHalfEdgeUserIndex(faceHalfEdge, visitedIndex, 1);
                    }
                    if ((faceHalfEdge = faceHalfEdgeNext) == firstHalfEdge) break;
                }
            }
            cluster = this.getNextCluster(cluster);
        }
        return removed;
    }

    void setEditShapeImpl_(EditShape shape, int inputMode, AttributeStreamOfInt32 editShapeGeometries, ProgressTracker progress_tracker, boolean bBuildChains) {
        assert (!this.m_dirty_check_failed);
        assert (editShapeGeometries == null || editShapeGeometries.size() > 0);
        this.removeShape();
        this.m_buildChains = bBuildChains;
        assert (this.m_shape == null);
        this.m_shape = shape;
        this.m_geometryIDIndex = this.m_shape.createGeometryUserIndex();
        AttributeStreamOfInt32 verticesSorter = new AttributeStreamOfInt32(0);
        verticesSorter.reserve(editShapeGeometries != null ? this.m_shape.getPointCount(editShapeGeometries.get(0)) : this.m_shape.getTotalPointCount());
        int path_count = 0;
        int geomID = 1;
        int geometry = editShapeGeometries != null ? editShapeGeometries.get(0) : this.m_shape.getFirstGeometry();
        int ind = 1;
        while (geometry != -1) {
            this.m_shape.setGeometryUserIndex(geometry, this.m_geometryIDIndex, geomID);
            geomID <<= 1;
            int path = this.m_shape.getFirstPath(geometry);
            while (path != -1) {
                int vertex = this.m_shape.getFirstVertex(path);
                int n = this.m_shape.getPathSize(path);
                for (int index = 0; index < n; ++index) {
                    verticesSorter.add(vertex);
                    vertex = this.m_shape.getNextVertex(vertex);
                }
                path = this.m_shape.getNextPath(path);
            }
            if (!Geometry.isPoint(this.m_shape.getGeometryType(geometry))) {
                path_count += this.m_shape.getPathCount(geometry);
            }
            if (editShapeGeometries != null) {
                geometry = ind < editShapeGeometries.size() ? editShapeGeometries.get(ind) : -1;
                ++ind;
                continue;
            }
            geometry = this.m_shape.getNextGeometry(geometry);
        }
        this.m_universe_geomID = geomID;
        this.m_pointCount = verticesSorter.size();
        this.m_shape.sortVerticesSimpleByY_(verticesSorter, 0, this.m_pointCount);
        if (this.m_clusterVertices == null) {
            this.m_clusterVertices = new StridedIndexTypeCollection(2);
            this.m_clusterData = new StridedIndexTypeCollection(8);
            this.m_halfEdgeData = new StridedIndexTypeCollection(8);
            this.m_chainData = new StridedIndexTypeCollection(8);
        }
        this.m_clusterVertices.setCapacity(this.m_pointCount);
        ProgressTracker.checkAndThrow(progress_tracker);
        this.m_clusterData.setCapacity(this.m_pointCount + 10);
        this.m_halfEdgeData.setCapacity(2 * this.m_pointCount + 32);
        this.m_chainData.setCapacity(Math.max(32, path_count));
        assert (this.m_clusterIndex == -1);
        this.m_clusterIndex = this.m_shape.createUserIndex();
        Point2D ptFirst = new Point2D();
        int ifirst = 0;
        Point2D pt = new Point2D();
        ptFirst.setNaN();
        for (int i = 0; i <= this.m_pointCount; ++i) {
            if (i < this.m_pointCount) {
                int vertex = verticesSorter.get(i);
                this.m_shape.getXY(vertex, pt);
            } else {
                pt.setNaN();
            }
            if (ptFirst.isEqual(pt)) continue;
            if (ifirst < i) {
                int cluster = this.newCluster_();
                int vertFirst = -1;
                int vert = -1;
                for (int ind2 = ifirst; ind2 < i; ++ind2) {
                    vert = verticesSorter.get(ind2);
                    this.m_shape.setUserIndex(vert, this.m_clusterIndex, cluster);
                    int vertIndex = this.m_clusterVertices.newElement();
                    this.m_clusterVertices.setField(vertIndex, 0, vert);
                    this.m_clusterVertices.setField(vertIndex, 1, vertFirst);
                    vertFirst = vertIndex;
                    int path = this.m_shape.getPathFromVertex(vert);
                    int geometry2 = this.m_shape.getGeometryFromPath(path);
                    int geometryID = this.getGeometryID(geometry2);
                    this.setClusterParentage_(cluster, this.getClusterParentage(cluster) | geometryID);
                }
                this.setClusterVertexIterator_(cluster, vertFirst);
                this.setClusterVertexIndex_(cluster, this.m_shape.getVertexIndex(vert));
                if (this.m_lastCluster != -1) {
                    this.setNextCluster_(this.m_lastCluster, cluster);
                }
                this.setPrevCluster_(cluster, this.m_lastCluster);
                this.m_lastCluster = cluster;
                if (this.m_firstCluster == -1) {
                    this.m_firstCluster = cluster;
                }
            }
            ifirst = i;
            ptFirst.setCoords(pt);
        }
        ProgressTracker.checkAndThrow(progress_tracker);
        this.m_tmpHalfEdgeParentageIndex = this.createUserIndexForHalfEdges();
        if (inputMode == 5) {
            this.m_tmpHalfEdgeWindingNumberIndex = this.createUserIndexForHalfEdges();
        }
        if (inputMode == 4) {
            this.m_tmpHalfEdgeOddEvenNumberIndex = this.createUserIndexForHalfEdges();
        }
        this.createHalfEdges_(inputMode, verticesSorter);
        if (this.m_non_simple_result.m_reason != NonSimpleResult.Reason.NotDetermined) {
            return;
        }
        this.sortHalfEdgesByAngle_(inputMode);
        if (this.m_non_simple_result.m_reason != NonSimpleResult.Reason.NotDetermined) {
            return;
        }
        if (!NumberUtils.isNaN(this.m_check_dirty_planesweep_tolerance) && !this.check_structure_after_dirty_sweep_()) {
            this.m_dirty_check_failed = true;
            return;
        }
        this.buildChains_(inputMode);
        if (this.m_non_simple_result.m_reason != NonSimpleResult.Reason.NotDetermined) {
            return;
        }
        this.deleteUserIndexForHalfEdges(this.m_tmpHalfEdgeParentageIndex);
        this.m_tmpHalfEdgeParentageIndex = -1;
        if (this.m_buildChains) {
            this.planeSweepParentage_(inputMode, progress_tracker);
        }
        this.simplify_(inputMode);
    }

    void deleteEdgeImpl_(int half_edge) {
        int cluster2;
        int clusterFirstEdge2;
        int cluster_1;
        int clusterFirstEdge1;
        int halfEdgeNext = this.getHalfEdgeNext(half_edge);
        int halfEdgePrev = this.getHalfEdgePrev(half_edge);
        int halfEdgeTwin = this.getHalfEdgeTwin(half_edge);
        int halfEdgeTwinNext = this.getHalfEdgeNext(halfEdgeTwin);
        int halfEdgeTwinPrev = this.getHalfEdgePrev(halfEdgeTwin);
        if (halfEdgeNext != halfEdgeTwin) {
            this.setHalfEdgeNext_(halfEdgeTwinPrev, halfEdgeNext);
            this.setHalfEdgePrev_(halfEdgeNext, halfEdgeTwinPrev);
        }
        if (halfEdgePrev != halfEdgeTwin) {
            this.setHalfEdgeNext_(halfEdgePrev, halfEdgeTwinNext);
            this.setHalfEdgePrev_(halfEdgeTwinNext, halfEdgePrev);
        }
        if ((clusterFirstEdge1 = this.getClusterHalfEdge(cluster_1 = this.getHalfEdgeOrigin(half_edge))) == half_edge) {
            if (halfEdgeTwinNext != half_edge) {
                this.setClusterHalfEdge_(cluster_1, halfEdgeTwinNext);
            } else {
                this.setClusterHalfEdge_(cluster_1, -1);
            }
        }
        if ((clusterFirstEdge2 = this.getClusterHalfEdge(cluster2 = this.getHalfEdgeOrigin(halfEdgeTwin))) == halfEdgeTwin) {
            if (halfEdgeNext != halfEdgeTwin) {
                this.setClusterHalfEdge_(cluster2, halfEdgeNext);
            } else {
                this.setClusterHalfEdge_(cluster2, -1);
            }
        }
        this.m_halfEdgeData.deleteElement(half_edge);
        this.m_halfEdgeData.deleteElement(halfEdgeTwin);
    }

    int getLeftSkipPolylines_(Treap aet, int treeNode) {
        int leftNode = treeNode;
        while ((leftNode = aet.getPrev(leftNode)) != -1) {
            int e = aet.getElement(leftNode);
            int leftChain = this.getHalfEdgeChain(e);
            if (leftChain == this.getHalfEdgeChain(this.getHalfEdgeTwin(e))) continue;
            return e;
        }
        return -1;
    }

    TopoGraph() {
        this.c_edgeParentageMask = 0xFFFFFFFF ^ 1 << NumberUtils.sizeOf(0) * 8 - 1;
        this.c_edgeBitMask = 1 << NumberUtils.sizeOf(0) * 8 - 1;
    }

    EditShape getShape() {
        return this.m_shape;
    }

    void setEditShape(EditShape shape, ProgressTracker progress_tracker) {
        this.setEditShapeImpl_(shape, 0, null, progress_tracker, true);
    }

    void setEditShape(EditShape shape, ProgressTracker progress_tracker, boolean bBuildChains) {
        this.setEditShapeImpl_(shape, 0, null, progress_tracker, bBuildChains);
    }

    void setAndSimplifyEditShapeAlternate(EditShape shape, int geometry, ProgressTracker progressTracker) {
        AttributeStreamOfInt32 geoms = new AttributeStreamOfInt32(0);
        geoms.add(geometry);
        this.setEditShapeImpl_(shape, 4, geoms, progressTracker, shape.getGeometryType(geometry) == Geometry.Type.Polygon.value());
    }

    void setAndSimplifyEditShapeWinding(EditShape shape, int geometry, ProgressTracker progressTracker) {
        AttributeStreamOfInt32 geoms = new AttributeStreamOfInt32(0);
        geoms.add(geometry);
        this.setEditShapeImpl_(shape, 5, geoms, progressTracker, true);
    }

    void removeShape() {
        if (this.m_shape == null) {
            return;
        }
        if (this.m_geometryIDIndex != -1) {
            this.m_shape.removeGeometryUserIndex(this.m_geometryIDIndex);
            this.m_geometryIDIndex = -1;
        }
        if (this.m_clusterIndex != -1) {
            this.m_shape.removeUserIndex(this.m_clusterIndex);
            this.m_clusterIndex = -1;
        }
        if (this.m_halfEdgeIndex != -1) {
            this.m_shape.removeUserIndex(this.m_halfEdgeIndex);
            this.m_halfEdgeIndex = -1;
        }
        if (this.m_tmpHalfEdgeParentageIndex != -1) {
            this.deleteUserIndexForHalfEdges(this.m_tmpHalfEdgeParentageIndex);
            this.m_tmpHalfEdgeParentageIndex = -1;
        }
        if (this.m_tmpHalfEdgeWindingNumberIndex != -1) {
            this.deleteUserIndexForHalfEdges(this.m_tmpHalfEdgeWindingNumberIndex);
            this.m_tmpHalfEdgeWindingNumberIndex = -1;
        }
        if (this.m_tmpHalfEdgeOddEvenNumberIndex != -1) {
            this.deleteUserIndexForHalfEdges(this.m_tmpHalfEdgeOddEvenNumberIndex);
            this.m_tmpHalfEdgeOddEvenNumberIndex = -1;
        }
        this.m_shape = null;
        this.m_clusterData.deleteAll(true);
        this.m_clusterVertices.deleteAll(true);
        this.m_firstCluster = -1;
        this.m_lastCluster = -1;
        if (this.m_halfEdgeData != null) {
            this.m_halfEdgeData.deleteAll(true);
        }
        if (this.m_edgeIndices != null) {
            this.m_edgeIndices.clear();
        }
        if (this.m_clusterIndices != null) {
            this.m_clusterIndices.clear();
        }
        if (this.m_chainIndices != null) {
            this.m_chainIndices.clear();
        }
        if (this.m_chainData != null) {
            this.m_chainData.deleteAll(true);
        }
        this.m_universeChain = -1;
        this.m_chainAreas = null;
    }

    int getClusterHalfEdge(int cluster) {
        return this.m_clusterData.getField(cluster, 2);
    }

    void getXY(int cluster, Point2D pt) {
        int vindex = this.getClusterVertexIndex_(cluster);
        this.m_shape.getXYWithIndex(vindex, pt);
    }

    int getClusterParentage(int cluster) {
        return this.m_clusterData.getField(cluster, 1);
    }

    int getFirstCluster() {
        return this.m_firstCluster;
    }

    int getPrevCluster(int cluster) {
        return this.m_clusterData.getField(cluster, 3);
    }

    int getNextCluster(int cluster) {
        return this.m_clusterData.getField(cluster, 4);
    }

    int getClusterChain(int cluster) {
        return this.m_clusterData.getField(cluster, 6);
    }

    int getClusterVertexIterator(int cluster) {
        return this.m_clusterData.getField(cluster, 7);
    }

    int incrementVertexIterator(int vertexIterator) {
        return this.m_clusterVertices.getField(vertexIterator, 1);
    }

    int getVertexFromVertexIterator(int vertexIterator) {
        return this.m_clusterVertices.getField(vertexIterator, 0);
    }

    int getClusterUserIndex(int cluster, int index) {
        int i = this.getClusterIndex_(cluster);
        AttributeStreamOfInt32 stream = this.m_clusterIndices.get(index);
        if (stream.size() <= i) {
            return -1;
        }
        return stream.read(i);
    }

    void setClusterUserIndex(int cluster, int index, int value) {
        int i = this.getClusterIndex_(cluster);
        AttributeStreamOfInt32 stream = this.m_clusterIndices.get(index);
        if (stream.size() <= i) {
            stream.resize(this.m_clusterData.size(), -1.0);
        }
        stream.write(i, value);
    }

    int createUserIndexForClusters() {
        if (this.m_clusterIndices == null) {
            this.m_clusterIndices = new ArrayList(3);
        }
        AttributeStreamOfInt32 new_stream = new AttributeStreamOfInt32(this.m_clusterData.capacity(), -1);
        int n = this.m_clusterIndices.size();
        for (int i = 0; i < n; ++i) {
            if (this.m_clusterIndices.get(i) != null) continue;
            this.m_clusterIndices.set(i, new_stream);
            return i;
        }
        this.m_clusterIndices.add(new_stream);
        return this.m_clusterIndices.size() - 1;
    }

    void deleteUserIndexForClusters(int userIndex) {
        assert (this.m_clusterIndices.get(userIndex) != null);
        this.m_clusterIndices.set(userIndex, null);
    }

    int getHalfEdgeOrigin(int half_edge) {
        return this.m_halfEdgeData.getField(half_edge, 1);
    }

    int getHalfEdgeTo(int half_edge) {
        return this.getHalfEdgeOrigin(this.getHalfEdgeTwin(half_edge));
    }

    int getHalfEdgeTwin(int half_edge) {
        return this.m_halfEdgeData.getField(half_edge, 4);
    }

    int getHalfEdgePrev(int half_edge) {
        return this.m_halfEdgeData.getField(half_edge, 5);
    }

    int getHalfEdgeNext(int half_edge) {
        return this.m_halfEdgeData.getField(half_edge, 6);
    }

    int getHalfEdgeChain(int half_edge) {
        return this.m_halfEdgeData.getField(half_edge, 2);
    }

    int getHalfEdgeFaceParentage(int half_edge) {
        return this.getChainParentage(this.m_halfEdgeData.getField(half_edge, 2));
    }

    int getHalfEdgeVertexIterator(int half_edge) {
        return this.m_halfEdgeData.getField(half_edge, 7);
    }

    void getHalfEdgeFromXY(int half_edge, Point2D pt) {
        this.getXY(this.getHalfEdgeOrigin(half_edge), pt);
    }

    void getHalfEdgeToXY(int half_edge, Point2D pt) {
        this.getXY(this.getHalfEdgeTo(half_edge), pt);
    }

    int getHalfEdgeParentage(int half_edge) {
        return this.m_halfEdgeData.getField(half_edge, 3) & this.c_edgeParentageMask;
    }

    int getHalfEdgeUserIndex(int half_edge, int index) {
        int i = this.getHalfEdgeIndex_(half_edge);
        AttributeStreamOfInt32 stream = this.m_edgeIndices.get(index);
        if (stream.size() <= i) {
            return -1;
        }
        return stream.read(i);
    }

    void setHalfEdgeUserIndex(int half_edge, int index, int value) {
        int i = this.getHalfEdgeIndex_(half_edge);
        AttributeStreamOfInt32 stream = this.m_edgeIndices.get(index);
        if (stream.size() <= i) {
            stream.resize(this.m_halfEdgeData.size(), -1.0);
        }
        stream.write(i, value);
    }

    int createUserIndexForHalfEdges() {
        if (this.m_edgeIndices == null) {
            this.m_edgeIndices = new ArrayList(3);
        }
        AttributeStreamOfInt32 new_stream = new AttributeStreamOfInt32(this.m_halfEdgeData.capacity(), -1);
        int n = this.m_edgeIndices.size();
        for (int i = 0; i < n; ++i) {
            if (this.m_edgeIndices.get(i) != null) continue;
            this.m_edgeIndices.set(i, new_stream);
            return i;
        }
        this.m_edgeIndices.add(new_stream);
        return this.m_edgeIndices.size() - 1;
    }

    void deleteUserIndexForHalfEdges(int userIndex) {
        assert (this.m_edgeIndices.get(userIndex) != null);
        this.m_edgeIndices.set(userIndex, null);
    }

    int deleteEdgeInternal_(int half_edge) {
        int chainIndex;
        double v;
        int chain = this.getHalfEdgeChain(half_edge);
        int halfEdgeTwin = this.getHalfEdgeTwin(half_edge);
        int chainTwin = this.getHalfEdgeChain(halfEdgeTwin);
        assert (chainTwin == chain);
        assert (half_edge == this.getHalfEdgeNext(halfEdgeTwin) || halfEdgeTwin == this.getHalfEdgeNext(half_edge));
        int n = this.getHalfEdgeNext(half_edge);
        if (n == halfEdgeTwin && (n = this.getHalfEdgeNext(n)) == half_edge) {
            n = -1;
        }
        if (this.getChainHalfEdge(chain) == half_edge) {
            this.setChainHalfEdge_(chain, n);
        }
        if (!NumberUtils.isNaN(v = this.m_chainAreas.read(chainIndex = this.getChainIndex_(chain)))) {
            this.setChainArea_(chain, Double.NaN);
            this.setChainPerimeter_(chain, Double.NaN);
        }
        this.updateVertexToHalfEdgeConnection_(half_edge, true);
        this.deleteEdgeImpl_(half_edge);
        return n;
    }

    void deleteEdgesBreakFaces_(AttributeStreamOfInt32 edgesToDelete) {
        int n = edgesToDelete.size();
        for (int i = 0; i < n; ++i) {
            int half_edge = edgesToDelete.get(i);
            int chain = this.getHalfEdgeChain(half_edge);
            int halfEdgeTwin = this.getHalfEdgeTwin(half_edge);
            int chainTwin = this.getHalfEdgeChain(halfEdgeTwin);
            this.setChainHalfEdge_(chain, -1);
            this.setChainHalfEdge_(chainTwin, -1);
            this.updateVertexToHalfEdgeConnection_(half_edge, true);
            this.deleteEdgeImpl_(half_edge);
        }
    }

    boolean doesHalfEdgeBelongToAPolygonInterior(int half_edge, int polygonId) {
        int p_1 = this.getHalfEdgeFaceParentage(half_edge);
        int p_2 = this.getHalfEdgeFaceParentage(this.getHalfEdgeTwin(half_edge));
        return (p_1 & polygonId) != 0 && (p_2 & polygonId) != 0;
    }

    boolean doesHalfEdgeBelongToAPolygonExterior(int half_edge, int polygonId) {
        int p_1 = this.getHalfEdgeFaceParentage(half_edge);
        int p_2 = this.getHalfEdgeFaceParentage(this.getHalfEdgeTwin(half_edge));
        return (p_1 & polygonId) == 0 && (p_2 & polygonId) == 0;
    }

    boolean doesHalfEdgeBelongToAPolygonBoundary(int half_edge, int polygonId) {
        int p_1 = this.getHalfEdgeParentage(half_edge);
        return (p_1 & polygonId) != 0;
    }

    boolean doesHalfEdgeBelongToAPolylineInterior(int half_edge, int polylineId) {
        int p_1 = this.getHalfEdgeParentage(half_edge);
        return (p_1 & polylineId) != 0;
    }

    boolean doesHalfEdgeBelongToAPolylineExterior(int half_edge, int polylineId) {
        int c;
        int pc;
        int p_1 = this.getHalfEdgeParentage(half_edge);
        return (p_1 & polylineId) == 0 && ((pc = this.getClusterParentage(c = this.getHalfEdgeOrigin(half_edge))) & polylineId) == 0 && ((pc = this.getClusterParentage(c = this.getHalfEdgeTo(half_edge))) & polylineId) == 0;
    }

    boolean doesClusterBelongToAPolygonInterior(int cluster, int polygonId) {
        int chain = this.getClusterChain(cluster);
        if (chain != -1) {
            if ((this.getChainParentage(chain) & polygonId) != 0) {
                return true;
            }
        } else {
            int p_1 = this.getClusterParentage(cluster);
            if ((p_1 & polygonId) == 0) {
                int half_edge = this.getClusterHalfEdge(cluster);
                assert (half_edge != -1);
                int p_2 = this.getHalfEdgeFaceParentage(half_edge);
                if ((p_2 & polygonId) != 0) {
                    return true;
                }
            }
        }
        return false;
    }

    boolean doesClusterBelongToAPolygonExterior(int cluster, int polygonId) {
        int p_1 = this.getClusterParentage(cluster);
        if ((p_1 & polygonId) == 0) {
            return this.doesClusterBelongToAPolygonInterior(cluster, polygonId);
        }
        return false;
    }

    boolean doesClusterBelongToAPolygonBoundary(int cluster, int polygonId) {
        int p_1 = this.getClusterParentage(cluster);
        return (p_1 & polygonId) != 0;
    }

    int getFirstChain() {
        return this.m_universeChain;
    }

    int getChainHalfEdge(int chain) {
        return this.m_chainData.getField(chain, 1);
    }

    int getChainParentage(int chain) {
        return this.m_chainData.getField(chain, 2);
    }

    int getChainParent(int chain) {
        return this.m_chainData.getField(chain, 3);
    }

    int getChainFirstIsland(int chain) {
        return this.m_chainData.getField(chain, 4);
    }

    int getChainNextInParent(int chain) {
        return this.m_chainData.getField(chain, 5);
    }

    int getChainNext(int chain) {
        return this.m_chainData.getField(chain, 7);
    }

    double getChainArea(int chain) {
        int chainIndex = this.getChainIndex_(chain);
        double v = this.m_chainAreas.read(chainIndex);
        if (NumberUtils.isNaN(v)) {
            this.updateChainAreaAndPerimeter_(chain);
            v = this.m_chainAreas.read(chainIndex);
        }
        return v;
    }

    double getChainPerimeter(int chain) {
        int chainIndex = this.getChainIndex_(chain);
        double v = this.m_chainPerimeters.read(chainIndex);
        if (NumberUtils.isNaN(v)) {
            this.updateChainAreaAndPerimeter_(chain);
            v = this.m_chainPerimeters.read(chainIndex);
        }
        return v;
    }

    int getChainUserIndex(int chain, int index) {
        int i = this.getChainIndex_(chain);
        AttributeStreamOfInt32 stream = this.m_chainIndices.get(index);
        if (stream.size() <= i) {
            return -1;
        }
        return stream.read(i);
    }

    void setChainUserIndex(int chain, int index, int value) {
        int i = this.getChainIndex_(chain);
        AttributeStreamOfInt32 stream = this.m_chainIndices.get(index);
        if (stream.size() <= i) {
            stream.resize(this.m_chainData.size(), -1.0);
        }
        stream.write(i, value);
    }

    int createUserIndexForChains() {
        if (this.m_chainIndices == null) {
            this.m_chainIndices = new ArrayList(3);
        }
        AttributeStreamOfInt32 new_stream = new AttributeStreamOfInt32(this.m_chainData.capacity(), -1);
        int n = this.m_chainIndices.size();
        for (int i = 0; i < n; ++i) {
            if (this.m_chainIndices.get(i) != null) continue;
            this.m_chainIndices.set(i, new_stream);
            return i;
        }
        this.m_chainIndices.add(new_stream);
        return this.m_chainIndices.size() - 1;
    }

    void deleteUserIndexForChains(int userIndex) {
        assert (this.m_chainIndices.get(userIndex) != null);
        this.m_chainIndices.set(userIndex, null);
    }

    int getGeometryID(int geometry) {
        return this.m_shape.getGeometryUserIndex(geometry, this.m_geometryIDIndex);
    }

    int getClusterFromVertex(int vertex) {
        return this.m_shape.getUserIndex(vertex, this.m_clusterIndex);
    }

    int getHalfEdgeFromVertex(int vertex) {
        return this.m_shape.getUserIndex(vertex, this.m_halfEdgeIndex);
    }

    int getHalfEdgeConnector(int clusterFrom, int clusterTo) {
        int first_edge = this.getClusterHalfEdge(clusterFrom);
        if (first_edge == -1) {
            return -1;
        }
        int edge = first_edge;
        int firstEdgeTo = -1;
        int eTo = -1;
        do {
            if (this.getHalfEdgeTo(edge) == clusterTo) {
                return edge;
            }
            if (firstEdgeTo == -1) {
                firstEdgeTo = this.getClusterHalfEdge(clusterTo);
                if (firstEdgeTo == -1) {
                    return -1;
                }
                eTo = firstEdgeTo;
            }
            if (this.getHalfEdgeTo(eTo) == clusterFrom) {
                edge = this.getHalfEdgeTwin(eTo);
                assert (this.getHalfEdgeTo(edge) == clusterTo && this.getHalfEdgeOrigin(edge) == clusterFrom);
                return edge;
            }
            edge = this.getHalfEdgeNext(this.getHalfEdgeTwin(edge));
            eTo = this.getHalfEdgeNext(this.getHalfEdgeTwin(eTo));
        } while (edge != first_edge && eTo != firstEdgeTo);
        return -1;
    }

    void querySegmentXY(int half_edge, SegmentBuffer outBuffer) {
        outBuffer.createLine();
        Segment seg = outBuffer.get();
        Point2D pt = new Point2D();
        this.getHalfEdgeFromXY(half_edge, pt);
        seg.setStartXY(pt);
        this.getHalfEdgeToXY(half_edge, pt);
        seg.setEndXY(pt);
    }

    int compareEdgeAngles_(int edge1, int edge2) {
        if (edge1 == edge2) {
            return 0;
        }
        Point2D pt_1 = new Point2D();
        this.getHalfEdgeToXY(edge1, pt_1);
        Point2D pt_2 = new Point2D();
        this.getHalfEdgeToXY(edge2, pt_2);
        if (pt_1.isEqual(pt_2)) {
            return 0;
        }
        Point2D pt10 = new Point2D();
        this.getHalfEdgeFromXY(edge1, pt10);
        Point2D v_1 = new Point2D();
        v_1.sub(pt_1, pt10);
        Point2D v_2 = new Point2D();
        v_2.sub(pt_2, pt10);
        int result = Point2D._compareVectors(v_1, v_2);
        return result;
    }

    int compareEdgeAnglesForPair_(int edge1, int edge2) {
        if (edge1 == edge2) {
            return 0;
        }
        Point2D pt_1 = new Point2D();
        this.getHalfEdgeToXY(edge1, pt_1);
        Point2D pt_2 = new Point2D();
        this.getHalfEdgeToXY(edge2, pt_2);
        if (pt_1.isEqual(pt_2)) {
            return 0;
        }
        Point2D pt10 = new Point2D();
        this.getHalfEdgeFromXY(edge1, pt10);
        Point2D v_1 = new Point2D();
        v_1.sub(pt_1, pt10);
        Point2D v_2 = new Point2D();
        v_2.sub(pt_2, pt10);
        if (v_2.y >= 0.0 && v_1.y > 0.0) {
            int result = Point2D._compareVectors(v_1, v_2);
            return result;
        }
        return 0;
    }

    boolean check_structure_after_dirty_sweep_() {
        assert (!this.m_dirty_check_failed);
        assert (!NumberUtils.isNaN(this.m_check_dirty_planesweep_tolerance));
        double sqr_tol = MathUtils.sqr(this.m_check_dirty_planesweep_tolerance);
        Point2D pt10 = new Point2D();
        Point2D pt_2 = new Point2D();
        Point2D pt_1 = new Point2D();
        Point2D v_1 = new Point2D();
        Point2D v_2 = new Point2D();
        int cluster = this.getFirstCluster();
        while (cluster != -1) {
            int first = this.getClusterHalfEdge(cluster);
            if (first != -1) {
                int edge = first;
                this.getHalfEdgeFromXY(edge, pt10);
                this.getHalfEdgeToXY(edge, pt_2);
                v_2.sub(pt_2, pt10);
                double sqr_len2 = v_2.sqrLength();
                do {
                    int prev = edge;
                    if ((edge = this.getHalfEdgeNext(this.getHalfEdgeTwin(edge))) == prev) continue;
                    this.getHalfEdgeToXY(edge, pt_1);
                    assert (!pt_1.isEqual(pt_2));
                    v_1.sub(pt_1, pt10);
                    double sqr_len1 = v_1.sqrLength();
                    double cross = v_1.crossProduct(v_2);
                    double sqr_sinA = cross * cross / (sqr_len1 * sqr_len2);
                    double sqr_dist = Math.min(sqr_len1, sqr_len2) * sqr_sinA;
                    if (sqr_dist <= sqr_tol) {
                        return false;
                    }
                    v_2.setCoords(v_1);
                    sqr_len2 = sqr_len1;
                    pt_2.setCoords(pt_1);
                } while (edge != first);
            }
            cluster = this.getNextCluster(cluster);
        }
        return true;
    }

    static final class ClusterSweepMonikerComparator
    extends Treap.MonikerComparator {
        TopoGraph m_parent;
        SegmentBuffer m_segment_buffer;
        Point2D m_point;
        Envelope1D m_interval;

        ClusterSweepMonikerComparator(TopoGraph parent) {
            this.m_parent = parent;
            this.m_segment_buffer = new SegmentBuffer();
            this.m_point = new Point2D();
            this.m_interval = new Envelope1D();
        }

        void setPointXY(Point2D pt) {
            this.m_point.setCoords(pt);
        }

        @Override
        int compare(Treap treap, int node) {
            int half_edge = treap.getElement(node);
            this.m_parent.querySegmentXY(half_edge, this.m_segment_buffer);
            Segment seg = this.m_segment_buffer.get();
            this.m_interval.setCoords(seg.getStartX(), seg.getEndX());
            if (this.m_point.x < this.m_interval.vmin) {
                return -1;
            }
            if (this.m_point.x > this.m_interval.vmax) {
                return 1;
            }
            double x = seg.intersectionOfYMonotonicWithAxisX(this.m_point.y, this.m_point.x);
            assert (x != this.m_point.x);
            return this.m_point.x < x ? -1 : (this.m_point.x > x ? 1 : 0);
        }
    }

    static final class TopoGraphAngleComparer
    extends AttributeStreamOfInt32.IntComparator {
        TopoGraph m_parent;

        TopoGraphAngleComparer(TopoGraph parent_) {
            this.m_parent = parent_;
        }

        @Override
        public int compare(int v1, int v2) {
            return this.m_parent.compareEdgeAngles_(v1, v2);
        }
    }

    static final class PlaneSweepComparator
    extends Treap.Comparator {
        TopoGraph m_helper;
        SegmentBuffer m_buffer_left;
        SegmentBuffer m_buffer_right;
        Envelope1D interval_left;
        Envelope1D interval_right;
        double m_y_scanline;

        PlaneSweepComparator(TopoGraph helper) {
            this.m_helper = helper;
            this.m_y_scanline = Double.NaN;
            this.m_buffer_left = new SegmentBuffer();
            this.m_buffer_right = new SegmentBuffer();
            this.interval_left = new Envelope1D();
            this.interval_right = new Envelope1D();
        }

        @Override
        int compare(Treap treap, int left, int node) {
            double xRight;
            double xLeft;
            boolean bRightHorz;
            int right = treap.getElement(node);
            this.m_helper.querySegmentXY(left, this.m_buffer_left);
            this.m_helper.querySegmentXY(right, this.m_buffer_right);
            Segment segLeft = this.m_buffer_left.get();
            Segment segRight = this.m_buffer_right.get();
            assert (segLeft.getStartXY().compare(segLeft.getEndXY()) < 0);
            assert (segRight.getStartXY().compare(segRight.getEndXY()) < 0);
            this.interval_left.setCoords(segLeft.getStartX(), segLeft.getEndX());
            this.interval_right.setCoords(segRight.getStartX(), segRight.getEndX());
            if (this.interval_left.vmax < this.interval_right.vmin) {
                return -1;
            }
            if (this.interval_left.vmin > this.interval_right.vmax) {
                return 1;
            }
            boolean bLeftHorz = segLeft.getStartY() == segLeft.getEndY();
            boolean bl = bRightHorz = segRight.getStartY() == segRight.getEndY();
            if (bLeftHorz || bRightHorz) {
                if (bLeftHorz && bRightHorz) {
                    assert (this.interval_left.equals(this.interval_right));
                    return 0;
                }
                if (segLeft.getStartY() == segRight.getStartY() && segLeft.getStartX() == segRight.getStartX()) {
                    return bLeftHorz ? 1 : -1;
                }
                if (segLeft.getEndY() == segRight.getEndY() && segLeft.getEndX() == segRight.getEndX()) {
                    return bLeftHorz ? -1 : 1;
                }
            }
            if ((xLeft = segLeft.intersectionOfYMonotonicWithAxisX(this.m_y_scanline, this.interval_left.vmin)) == (xRight = segRight.intersectionOfYMonotonicWithAxisX(this.m_y_scanline, this.interval_right.vmin))) {
                double yRight;
                double yLeft = segLeft.getEndY();
                double miny = Math.min(yLeft, yRight = segRight.getEndY());
                double y = (miny + this.m_y_scanline) * 0.5;
                if (y == this.m_y_scanline) {
                    y = miny;
                }
                xLeft = segLeft.intersectionOfYMonotonicWithAxisX(y, this.interval_left.vmin);
                xRight = segRight.intersectionOfYMonotonicWithAxisX(y, this.interval_right.vmin);
            }
            return xLeft < xRight ? -1 : (xLeft > xRight ? 1 : 0);
        }

        void setY(double y) {
            this.m_y_scanline = y;
        }
    }

    static interface EnumInputMode {
        public static final int enumInputModeBuildGraph = 0;
        public static final int enumInputModeSimplifyAlternate = 4;
        public static final int enumInputModeSimplifyWinding = 5;
        public static final int enumInputModeIsSimplePolygon = 7;
    }
}

