/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.sql;

import com.hazelcast.webmonitor.sql.Histories;
import com.hazelcast.webmonitor.sql.QueryHistoryRecord;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.stereotype.Repository;

@Repository
public class JdbiHistories
implements Histories {
    private static final String USERNAME = "username";
    private static final String CLUSTER = "cluster";
    private final Jdbi jdbi;

    public JdbiHistories(Jdbi jdbi) {
        this.jdbi = jdbi;
    }

    public void save(QueryHistoryRecord historyRecord, int maxLimit) {
        this.jdbi.useTransaction(handle -> {
            int count = (Integer)((Query)((Query)handle.createQuery("select count(1) from query_history where username = :username and cluster = :cluster").bind(USERNAME, historyRecord.getUsername())).bind(CLUSTER, historyRecord.getCluster())).mapTo(Integer.TYPE).first();
            if (count == maxLimit) {
                ((Update)((Update)handle.createUpdate("delete from query_history\nwhere username = :username\n      and cluster = :cluster\n      and execution_time = (\n           select  min(execution_time) as execution_time\n           from    query_history\n           where   username = :username\n                   and cluster = :cluster\n           group by username, cluster)").bind(USERNAME, historyRecord.getUsername())).bind(CLUSTER, historyRecord.getCluster())).execute();
            }
            ((Update)handle.createUpdate("insert into query_history (cluster, sql_string, username, execution_time, status)\nvalues (:cluster, :sqlString, :username, :executionTime, :status)").bindBean((Object)historyRecord)).execute();
        });
    }

    public Collection<QueryHistoryRecord> findBy(String username, String cluster) {
        return (Collection)this.jdbi.withHandle(handle -> (List)((Query)((Query)handle.createQuery("select * from query_history \nwhere username = :username and cluster = :cluster\norder by execution_time asc").bind(USERNAME, username)).bind(CLUSTER, cluster)).mapToBean(QueryHistoryRecord.class).collect(Collectors.toList()));
    }

    public void removeByCluster(String cluster) {
        this.jdbi.useHandle(handle -> ((Update)handle.createUpdate("delete from query_history where cluster = :cluster").bind(CLUSTER, cluster)).execute());
    }

    public void removeByUser(String username) {
        this.jdbi.useHandle(handle -> ((Update)handle.createUpdate("delete from query_history where username = :username").bind(USERNAME, username)).execute());
    }
}

