/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.telemetry;

import com.hazelcast.webmonitor.model.telemetry.PhoneHomeData;
import com.hazelcast.webmonitor.service.telemetry.PhoneHomeDataFactory;
import com.hazelcast.webmonitor.service.telemetry.PhoneHomeService;
import com.hazelcast.webmonitor.utils.SerializationUtil;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoneHomeServiceImpl
implements AutoCloseable,
PhoneHomeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoneHomeServiceImpl.class);
    private static final int INITIAL_DELAY_MINUTES = 30;
    private static final int TIMEOUT_MILLIS = 5000;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "PhoneHomeService"));
    private final CloseableHttpClient httpClient = HttpClientBuilder.create().build();
    private String phoneHomeUrl;
    private final PhoneHomeDataFactory phoneHomeDataFactory;
    private final RequestConfig requestConfig;

    public PhoneHomeServiceImpl(String phoneHomeUrl, PhoneHomeDataFactory phoneHomeDataFactory) {
        this.phoneHomeUrl = phoneHomeUrl;
        this.phoneHomeDataFactory = phoneHomeDataFactory;
        this.requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(5000).build();
        this.executor.scheduleAtFixedRate(() -> this.sendData(), 30L, TimeUnit.DAYS.toMinutes(1L), TimeUnit.MINUTES);
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
        this.httpClient.close();
    }

    public void sendData() {
        try {
            PhoneHomeData phoneHomeData = this.phoneHomeDataFactory.create();
            StringEntity entity = new StringEntity(SerializationUtil.OBJECT_MAPPER.writeValueAsString((Object)phoneHomeData), ContentType.APPLICATION_JSON);
            HttpUriRequest request = RequestBuilder.post((String)this.phoneHomeUrl).setConfig(this.requestConfig).setEntity((HttpEntity)entity).build();
            try (CloseableHttpResponse response = this.httpClient.execute(request);){
                LOGGER.debug("Response from PhoneHome: {}", (Object)response.getStatusLine());
            }
        }
        catch (Exception e) {
            LOGGER.debug("Phone home failed.", (Throwable)e);
        }
    }

    public void setPhoneHomeUrl(String phoneHomeUrl) {
        this.phoneHomeUrl = phoneHomeUrl;
    }
}

