/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.metrics;

import com.hazelcast.webmonitor.controller.dto.metrics.storage.MetricsStorageDiagnosticsDTO;
import com.hazelcast.webmonitor.service.metrics.MetricsStorageDiagnosticsSupplier;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.text.MessageFormat;
import java.text.StringCharacterIterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MetricsStorageDiagnosticsLogger
implements AutoCloseable,
DisposableBean,
InitializingBean {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsStorageDiagnosticsLogger.class);
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final int LOGGING_INTERVAL = 1;
    private final ScheduledExecutorService pSyncExecutor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "MetricsStorageDiagnostics"));
    private final MetricsStorageDiagnosticsSupplier diagnosticsDataSupplier;

    void logDiagnosticsData() {
        MetricsStorageDiagnosticsDTO data = this.diagnosticsDataSupplier.get();
        log.info(MessageFormat.format("{0}{0}Known time series: {1}{0}Tracked minute buckets: {2}{0}Number of persistence runs: {3}{0}Total persistence run time: {4}{0}Max persistence run time: {5}{0}Average persistence run time: {6}{0}Last hour average persistence run time: {7}{0}Total persisted minute buckets: {8}{0}Max persisted minute buckets per run: {9}{0}Average persisted minute buckets per run: {10}{0}Last hour average persisted minute buckets per run: {11}{0}Total dropped data points that arrived when the target minute bucket is no longer tracked, but not yet released(persisted) : {12}{0}Total evicted dangling minute series : {13}{0}Persistent store TTL: {14}{0}Persistent store size on disk: {15}{0}Data point memory compression ratio: {16,number,#.##}{0}", LINE_SEPARATOR, data.getKnownTimeSeries(), data.getTrackedMinuteBuckets(), data.getPersistenceRuns(), DurationFormatUtils.formatDurationHMS((long)data.getTotalPersistenceRunTimeInMs()), DurationFormatUtils.formatDurationHMS((long)data.getMaxPersistenceRunTimeInMs()), DurationFormatUtils.formatDurationHMS((long)data.getAvgPersistenceRunTimeInMs()), DurationFormatUtils.formatDurationHMS((long)data.getLastHourAvgPersistenceRunTimeInMs()), data.getTotalPersistedMinuteBuckets(), data.getMaxPersistedMinuteBucketsPerRun(), data.getAvgPersistedMinuteBucketsPerRun(), data.getLastHourAvgPersistedMinuteBucketsPerRun(), data.getTotalDroppedDataPoints(), data.getTotalEvictedDanglingMinuteSeries(), DurationFormatUtils.formatDuration((long)TimeUnit.SECONDS.toMillis(data.getPersistentStoreTTLSeconds()), (String)"HH:mm:ss"), MetricsStorageDiagnosticsLogger.formatFileSizeToHumanReadable((long)data.getStorageSizeInBytes()), data.getDataPointMemoryCompressionRatio()));
    }

    static String formatFileSizeToHumanReadable(long bytes) {
        long absB;
        long l = absB = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (absB < 1024L) {
            return bytes + " B";
        }
        long value = absB;
        StringCharacterIterator ci = new StringCharacterIterator("KMGTPE");
        for (int i = 40; i >= 0 && absB > 0xFFFCCCCCCCCCCCCL >> i; i -= 10) {
            value >>= 10;
            ci.next();
        }
        return String.format("%.1f %ciB", (double)(value *= (long)Long.signum(bytes)) / 1024.0, Character.valueOf(ci.current()));
    }

    public void afterPropertiesSet() throws Exception {
        this.pSyncExecutor.scheduleAtFixedRate(() -> this.logDiagnosticsData(), 1L, 1L, TimeUnit.HOURS);
    }

    public void destroy() throws Exception {
        this.close();
    }

    @Override
    public void close() throws Exception {
        this.pSyncExecutor.shutdown();
        this.pSyncExecutor.awaitTermination(1L, TimeUnit.SECONDS);
    }

    @ConstructorProperties(value={"diagnosticsDataSupplier"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MetricsStorageDiagnosticsLogger(MetricsStorageDiagnosticsSupplier diagnosticsDataSupplier) {
        this.diagnosticsDataSupplier = diagnosticsDataSupplier;
    }
}

