/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.memberconfig;

import com.hazelcast.config.Config;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import com.hazelcast.webmonitor.service.memberconfig.XmlParsingTimeListener;
import java.time.Clock;
import javax.annotation.Nonnull;

final class InstrumentedMemberConfig
extends MemberConfig {
    private volatile XmlParsingTimeListener listener;
    private final Clock clock;
    private final MemberIdentifier memberIdent;

    InstrumentedMemberConfig(@Nonnull String rawXmlConfig, XmlParsingTimeListener listener, Clock clock, MemberIdentifier memberIdent) {
        super(rawXmlConfig);
        this.clock = clock;
        this.listener = listener;
        this.memberIdent = memberIdent;
    }

    protected Config doParseXml(String xmlConfig) {
        long startAt = this.clock.millis();
        Config config = super.doParseXml(xmlConfig);
        long duration = Math.max(0L, this.clock.millis() - startAt);
        this.listener.configXmlParsed(this.memberIdent, duration);
        return config;
    }

    public void detachListener() {
        this.listener = XmlParsingTimeListener.NONE;
    }
}

